/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The notification configuration for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketNotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketNotificationConfiguration.Builder, AwsS3BucketNotificationConfiguration> {
    private static final SdkField<List<AwsS3BucketNotificationConfigurationDetail>> CONFIGURATIONS_FIELD = SdkField
            .<List<AwsS3BucketNotificationConfigurationDetail>> builder(MarshallingType.LIST)
            .memberName("Configurations")
            .getter(getter(AwsS3BucketNotificationConfiguration::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketNotificationConfigurationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsS3BucketNotificationConfigurationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsS3BucketNotificationConfigurationDetail> configurations;

    private AwsS3BucketNotificationConfiguration(BuilderImpl builder) {
        this.configurations = builder.configurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configurations for S3 bucket notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Configurations for S3 bucket notifications.
     */
    public final List<AwsS3BucketNotificationConfigurationDetail> configurations() {
        return configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketNotificationConfiguration)) {
            return false;
        }
        AwsS3BucketNotificationConfiguration other = (AwsS3BucketNotificationConfiguration) obj;
        return hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketNotificationConfiguration")
                .add("Configurations", hasConfigurations() ? configurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketNotificationConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketNotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketNotificationConfiguration> {
        /**
         * <p>
         * Configurations for S3 bucket notifications.
         * </p>
         * 
         * @param configurations
         *        Configurations for S3 bucket notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<AwsS3BucketNotificationConfigurationDetail> configurations);

        /**
         * <p>
         * Configurations for S3 bucket notifications.
         * </p>
         * 
         * @param configurations
         *        Configurations for S3 bucket notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(AwsS3BucketNotificationConfigurationDetail... configurations);

        /**
         * <p>
         * Configurations for S3 bucket notifications.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsS3BucketNotificationConfigurationDetail>.Builder} avoiding the need to create one manually via
         * {@link List<AwsS3BucketNotificationConfigurationDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsS3BucketNotificationConfigurationDetail>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configurations(List<AwsS3BucketNotificationConfigurationDetail>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on {@link List<AwsS3BucketNotificationConfigurationDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(List<AwsS3BucketNotificationConfigurationDetail>)
         */
        Builder configurations(Consumer<AwsS3BucketNotificationConfigurationDetail.Builder>... configurations);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsS3BucketNotificationConfigurationDetail> configurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketNotificationConfiguration model) {
            configurations(model.configurations);
        }

        public final List<AwsS3BucketNotificationConfigurationDetail.Builder> getConfigurations() {
            List<AwsS3BucketNotificationConfigurationDetail.Builder> result = AwsS3BucketNotificationConfigurationDetailsCopier
                    .copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<AwsS3BucketNotificationConfigurationDetail.BuilderImpl> configurations) {
            this.configurations = AwsS3BucketNotificationConfigurationDetailsCopier.copyFromBuilder(configurations);
        }

        @Override
        @Transient
        public final Builder configurations(Collection<AwsS3BucketNotificationConfigurationDetail> configurations) {
            this.configurations = AwsS3BucketNotificationConfigurationDetailsCopier.copy(configurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurations(AwsS3BucketNotificationConfigurationDetail... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurations(Consumer<AwsS3BucketNotificationConfigurationDetail.Builder>... configurations) {
            configurations(Stream.of(configurations)
                    .map(c -> AwsS3BucketNotificationConfigurationDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsS3BucketNotificationConfiguration build() {
            return new AwsS3BucketNotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
