/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rules to redirect the request if the condition in <code>Condition</code> is met.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder, AwsS3BucketWebsiteConfigurationRoutingRuleRedirect> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::hostname))
            .setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> HTTP_REDIRECT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpRedirectCode").getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::httpRedirectCode))
            .setter(setter(Builder::httpRedirectCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpRedirectCode").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> REPLACE_KEY_PREFIX_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplaceKeyPrefixWith")
            .getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::replaceKeyPrefixWith))
            .setter(setter(Builder::replaceKeyPrefixWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceKeyPrefixWith").build())
            .build();

    private static final SdkField<String> REPLACE_KEY_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplaceKeyWith").getter(getter(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::replaceKeyWith))
            .setter(setter(Builder::replaceKeyWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceKeyWith").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD,
            HTTP_REDIRECT_CODE_FIELD, PROTOCOL_FIELD, REPLACE_KEY_PREFIX_WITH_FIELD, REPLACE_KEY_WITH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final String httpRedirectCode;

    private final String protocol;

    private final String replaceKeyPrefixWith;

    private final String replaceKeyWith;

    private AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.httpRedirectCode = builder.httpRedirectCode;
        this.protocol = builder.protocol;
        this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
        this.replaceKeyWith = builder.replaceKeyWith;
    }

    /**
     * <p>
     * The host name to use in the redirect request.
     * </p>
     * 
     * @return The host name to use in the redirect request.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The HTTP redirect code to use in the response.
     * </p>
     * 
     * @return The HTTP redirect code to use in the response.
     */
    public final String httpRedirectCode() {
        return httpRedirectCode;
    }

    /**
     * <p>
     * The protocol to use to redirect the request. By default, uses the protocol from the original request.
     * </p>
     * 
     * @return The protocol to use to redirect the request. By default, uses the protocol from the original request.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The object key prefix to use in the redirect request.
     * </p>
     * <p>
     * Cannot be provided if <code>ReplaceKeyWith</code> is present.
     * </p>
     * 
     * @return The object key prefix to use in the redirect request.</p>
     *         <p>
     *         Cannot be provided if <code>ReplaceKeyWith</code> is present.
     */
    public final String replaceKeyPrefixWith() {
        return replaceKeyPrefixWith;
    }

    /**
     * <p>
     * The specific object key to use in the redirect request.
     * </p>
     * <p>
     * Cannot be provided if <code>ReplaceKeyPrefixWith</code> is present.
     * </p>
     * 
     * @return The specific object key to use in the redirect request.</p>
     *         <p>
     *         Cannot be provided if <code>ReplaceKeyPrefixWith</code> is present.
     */
    public final String replaceKeyWith() {
        return replaceKeyWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(httpRedirectCode());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(replaceKeyPrefixWith());
        hashCode = 31 * hashCode + Objects.hashCode(replaceKeyWith());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfigurationRoutingRuleRedirect)) {
            return false;
        }
        AwsS3BucketWebsiteConfigurationRoutingRuleRedirect other = (AwsS3BucketWebsiteConfigurationRoutingRuleRedirect) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(httpRedirectCode(), other.httpRedirectCode())
                && Objects.equals(protocol(), other.protocol())
                && Objects.equals(replaceKeyPrefixWith(), other.replaceKeyPrefixWith())
                && Objects.equals(replaceKeyWith(), other.replaceKeyWith());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketWebsiteConfigurationRoutingRuleRedirect").add("Hostname", hostname())
                .add("HttpRedirectCode", httpRedirectCode()).add("Protocol", protocol())
                .add("ReplaceKeyPrefixWith", replaceKeyPrefixWith()).add("ReplaceKeyWith", replaceKeyWith()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "HttpRedirectCode":
            return Optional.ofNullable(clazz.cast(httpRedirectCode()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "ReplaceKeyPrefixWith":
            return Optional.ofNullable(clazz.cast(replaceKeyPrefixWith()));
        case "ReplaceKeyWith":
            return Optional.ofNullable(clazz.cast(replaceKeyWith()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfigurationRoutingRuleRedirect, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfigurationRoutingRuleRedirect) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketWebsiteConfigurationRoutingRuleRedirect> {
        /**
         * <p>
         * The host name to use in the redirect request.
         * </p>
         * 
         * @param hostname
         *        The host name to use in the redirect request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The HTTP redirect code to use in the response.
         * </p>
         * 
         * @param httpRedirectCode
         *        The HTTP redirect code to use in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRedirectCode(String httpRedirectCode);

        /**
         * <p>
         * The protocol to use to redirect the request. By default, uses the protocol from the original request.
         * </p>
         * 
         * @param protocol
         *        The protocol to use to redirect the request. By default, uses the protocol from the original request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The object key prefix to use in the redirect request.
         * </p>
         * <p>
         * Cannot be provided if <code>ReplaceKeyWith</code> is present.
         * </p>
         * 
         * @param replaceKeyPrefixWith
         *        The object key prefix to use in the redirect request.</p>
         *        <p>
         *        Cannot be provided if <code>ReplaceKeyWith</code> is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceKeyPrefixWith(String replaceKeyPrefixWith);

        /**
         * <p>
         * The specific object key to use in the redirect request.
         * </p>
         * <p>
         * Cannot be provided if <code>ReplaceKeyPrefixWith</code> is present.
         * </p>
         * 
         * @param replaceKeyWith
         *        The specific object key to use in the redirect request.</p>
         *        <p>
         *        Cannot be provided if <code>ReplaceKeyPrefixWith</code> is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceKeyWith(String replaceKeyWith);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private String httpRedirectCode;

        private String protocol;

        private String replaceKeyPrefixWith;

        private String replaceKeyWith;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect model) {
            hostname(model.hostname);
            httpRedirectCode(model.httpRedirectCode);
            protocol(model.protocol);
            replaceKeyPrefixWith(model.replaceKeyPrefixWith);
            replaceKeyWith(model.replaceKeyWith);
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        @Transient
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getHttpRedirectCode() {
            return httpRedirectCode;
        }

        public final void setHttpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
        }

        @Override
        @Transient
        public final Builder httpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getReplaceKeyPrefixWith() {
            return replaceKeyPrefixWith;
        }

        public final void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        @Override
        @Transient
        public final Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
            return this;
        }

        public final String getReplaceKeyWith() {
            return replaceKeyWith;
        }

        public final void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        @Override
        @Transient
        public final Builder replaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
            return this;
        }

        @Override
        public AwsS3BucketWebsiteConfigurationRoutingRuleRedirect build() {
            return new AwsS3BucketWebsiteConfigurationRoutingRuleRedirect(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
