/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the compliance for a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSsmPatch implements SdkPojo, Serializable, ToCopyableBuilder<AwsSsmPatch.Builder, AwsSsmPatch> {
    private static final SdkField<AwsSsmComplianceSummary> COMPLIANCE_SUMMARY_FIELD = SdkField
            .<AwsSsmComplianceSummary> builder(MarshallingType.SDK_POJO).memberName("ComplianceSummary")
            .getter(getter(AwsSsmPatch::complianceSummary)).setter(setter(Builder::complianceSummary))
            .constructor(AwsSsmComplianceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsSsmComplianceSummary complianceSummary;

    private AwsSsmPatch(BuilderImpl builder) {
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The compliance status details for the patch.
     * </p>
     * 
     * @return The compliance status details for the patch.
     */
    public final AwsSsmComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSsmPatch)) {
            return false;
        }
        AwsSsmPatch other = (AwsSsmPatch) obj;
        return Objects.equals(complianceSummary(), other.complianceSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSsmPatch").add("ComplianceSummary", complianceSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSsmPatch, T> g) {
        return obj -> g.apply((AwsSsmPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSsmPatch> {
        /**
         * <p>
         * The compliance status details for the patch.
         * </p>
         * 
         * @param complianceSummary
         *        The compliance status details for the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(AwsSsmComplianceSummary complianceSummary);

        /**
         * <p>
         * The compliance status details for the patch.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSsmComplianceSummary.Builder} avoiding the
         * need to create one manually via {@link AwsSsmComplianceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSsmComplianceSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceSummary(AwsSsmComplianceSummary)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link AwsSsmComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(AwsSsmComplianceSummary)
         */
        default Builder complianceSummary(Consumer<AwsSsmComplianceSummary.Builder> complianceSummary) {
            return complianceSummary(AwsSsmComplianceSummary.builder().applyMutation(complianceSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsSsmComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSsmPatch model) {
            complianceSummary(model.complianceSummary);
        }

        public final AwsSsmComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        public final void setComplianceSummary(AwsSsmComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder complianceSummary(AwsSsmComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        @Override
        public AwsSsmPatch build() {
            return new AwsSsmPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
