/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableSecurityHubRequest extends SecurityHubRequest implements
        ToCopyableBuilder<EnableSecurityHubRequest.Builder, EnableSecurityHubRequest> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EnableSecurityHubRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_STANDARDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDefaultStandards").getter(getter(EnableSecurityHubRequest::enableDefaultStandards))
            .setter(setter(Builder::enableDefaultStandards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultStandards").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD,
            ENABLE_DEFAULT_STANDARDS_FIELD));

    private final Map<String, String> tags;

    private final Boolean enableDefaultStandards;

    private EnableSecurityHubRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.enableDefaultStandards = builder.enableDefaultStandards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the hub resource when you enable Security Hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the hub resource when you enable Security Hub.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not
     * provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the
     * automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * 
     * @return Whether to enable the security standards that Security Hub has designated as automatically enabled. If
     *         you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To
     *         not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to
     *         <code>false</code>.
     */
    public final Boolean enableDefaultStandards() {
        return enableDefaultStandards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultStandards());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSecurityHubRequest)) {
            return false;
        }
        EnableSecurityHubRequest other = (EnableSecurityHubRequest) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(enableDefaultStandards(), other.enableDefaultStandards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableSecurityHubRequest").add("Tags", hasTags() ? tags() : null)
                .add("EnableDefaultStandards", enableDefaultStandards()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EnableDefaultStandards":
            return Optional.ofNullable(clazz.cast(enableDefaultStandards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableSecurityHubRequest, T> g) {
        return obj -> g.apply((EnableSecurityHubRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableSecurityHubRequest> {
        /**
         * <p>
         * The tags to add to the hub resource when you enable Security Hub.
         * </p>
         * 
         * @param tags
         *        The tags to add to the hub resource when you enable Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do
         * not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable
         * the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
         * </p>
         * 
         * @param enableDefaultStandards
         *        Whether to enable the security standards that Security Hub has designated as automatically enabled. If
         *        you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To
         *        not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultStandards(Boolean enableDefaultStandards);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableDefaultStandards;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSecurityHubRequest model) {
            super(model);
            tags(model.tags);
            enableDefaultStandards(model.enableDefaultStandards);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getEnableDefaultStandards() {
            return enableDefaultStandards;
        }

        public final void setEnableDefaultStandards(Boolean enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
        }

        @Override
        @Transient
        public final Builder enableDefaultStandards(Boolean enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSecurityHubRequest build() {
            return new EnableSecurityHubRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
