/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A finding aggregator. A finding aggregator contains the configuration for finding aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingAggregator implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingAggregator.Builder, FindingAggregator> {
    private static final SdkField<String> FINDING_AGGREGATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FindingAggregatorArn").getter(getter(FindingAggregator::findingAggregatorArn))
            .setter(setter(Builder::findingAggregatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregatorArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_AGGREGATOR_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingAggregatorArn;

    private FindingAggregator(BuilderImpl builder) {
        this.findingAggregatorArn = builder.findingAggregatorArn;
    }

    /**
     * <p>
     * The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and delete
     * the finding aggregator.
     * </p>
     * 
     * @return The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update,
     *         and delete the finding aggregator.
     */
    public final String findingAggregatorArn() {
        return findingAggregatorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingAggregatorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingAggregator)) {
            return false;
        }
        FindingAggregator other = (FindingAggregator) obj;
        return Objects.equals(findingAggregatorArn(), other.findingAggregatorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingAggregator").add("FindingAggregatorArn", findingAggregatorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingAggregatorArn":
            return Optional.ofNullable(clazz.cast(findingAggregatorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingAggregator, T> g) {
        return obj -> g.apply((FindingAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingAggregator> {
        /**
         * <p>
         * The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update, and
         * delete the finding aggregator.
         * </p>
         * 
         * @param findingAggregatorArn
         *        The ARN of the finding aggregator. You use the finding aggregator ARN to retrieve details for, update,
         *        and delete the finding aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingAggregatorArn(String findingAggregatorArn);
    }

    static final class BuilderImpl implements Builder {
        private String findingAggregatorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingAggregator model) {
            findingAggregatorArn(model.findingAggregatorArn);
        }

        public final String getFindingAggregatorArn() {
            return findingAggregatorArn;
        }

        public final void setFindingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
        }

        @Override
        @Transient
        public final Builder findingAggregatorArn(String findingAggregatorArn) {
            this.findingAggregatorArn = findingAggregatorArn;
            return this;
        }

        @Override
        public FindingAggregator build() {
            return new FindingAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
