/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A stateless rule group that is used by the firewall policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallPolicyStatelessRuleGroupReferencesDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<FirewallPolicyStatelessRuleGroupReferencesDetails.Builder, FirewallPolicyStatelessRuleGroupReferencesDetails> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(FirewallPolicyStatelessRuleGroupReferencesDetails::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(FirewallPolicyStatelessRuleGroupReferencesDetails::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD,
            RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer priority;

    private final String resourceArn;

    private FirewallPolicyStatelessRuleGroupReferencesDetails(BuilderImpl builder) {
        this.priority = builder.priority;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The order in which to run the stateless rule group.
     * </p>
     * 
     * @return The order in which to run the stateless rule group.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ARN of the stateless rule group.
     * </p>
     * 
     * @return The ARN of the stateless rule group.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicyStatelessRuleGroupReferencesDetails)) {
            return false;
        }
        FirewallPolicyStatelessRuleGroupReferencesDetails other = (FirewallPolicyStatelessRuleGroupReferencesDetails) obj;
        return Objects.equals(priority(), other.priority()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallPolicyStatelessRuleGroupReferencesDetails").add("Priority", priority())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicyStatelessRuleGroupReferencesDetails, T> g) {
        return obj -> g.apply((FirewallPolicyStatelessRuleGroupReferencesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallPolicyStatelessRuleGroupReferencesDetails> {
        /**
         * <p>
         * The order in which to run the stateless rule group.
         * </p>
         * 
         * @param priority
         *        The order in which to run the stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ARN of the stateless rule group.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private Integer priority;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicyStatelessRuleGroupReferencesDetails model) {
            priority(model.priority);
            resourceArn(model.resourceArn);
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public FirewallPolicyStatelessRuleGroupReferencesDetails build() {
            return new FirewallPolicyStatelessRuleGroupReferencesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
