/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of malware related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Malware implements SdkPojo, Serializable, ToCopyableBuilder<Malware.Builder, Malware> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Malware::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Malware::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(Malware::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Malware::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            PATH_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String path;

    private final String state;

    private Malware(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.path = builder.path;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @return The name of the malware that was observed.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MalwareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the malware that was observed.
     * @see MalwareType
     */
    public final MalwareType type() {
        return MalwareType.fromValue(type);
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MalwareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the malware that was observed.
     * @see MalwareType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The file system path of the malware that was observed.
     * </p>
     * 
     * @return The file system path of the malware that was observed.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MalwareState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the malware that was observed.
     * @see MalwareState
     */
    public final MalwareState state() {
        return MalwareState.fromValue(state);
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MalwareState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the malware that was observed.
     * @see MalwareState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Malware)) {
            return false;
        }
        Malware other = (Malware) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(path(), other.path()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Malware").add("Name", name()).add("Type", typeAsString()).add("Path", path())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Malware, T> g) {
        return obj -> g.apply((Malware) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Malware> {
        /**
         * <p>
         * The name of the malware that was observed.
         * </p>
         * 
         * @param name
         *        The name of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the malware that was observed.
         * </p>
         * 
         * @param type
         *        The type of the malware that was observed.
         * @see MalwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the malware that was observed.
         * </p>
         * 
         * @param type
         *        The type of the malware that was observed.
         * @see MalwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareType
         */
        Builder type(MalwareType type);

        /**
         * <p>
         * The file system path of the malware that was observed.
         * </p>
         * 
         * @param path
         *        The file system path of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The state of the malware that was observed.
         * </p>
         * 
         * @param state
         *        The state of the malware that was observed.
         * @see MalwareState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the malware that was observed.
         * </p>
         * 
         * @param state
         *        The state of the malware that was observed.
         * @see MalwareState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareState
         */
        Builder state(MalwareState state);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String path;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Malware model) {
            name(model.name);
            type(model.type);
            path(model.path);
            state(model.state);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(MalwareType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(MalwareState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Malware build() {
            return new Malware(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
