/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the destination of the next component in the network path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkPathComponentDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkPathComponentDetails.Builder, NetworkPathComponentDetails> {
    private static final SdkField<List<String>> ADDRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Address")
            .getter(getter(NetworkPathComponentDetails::address))
            .setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(NetworkPathComponentDetails::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            PORT_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> address;

    private final List<PortRange> portRanges;

    private NetworkPathComponentDetails(BuilderImpl builder) {
        this.address = builder.address;
        this.portRanges = builder.portRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Address property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddress() {
        return address != null && !(address instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses of the destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddress} method.
     * </p>
     * 
     * @return The IP addresses of the destination.
     */
    public final List<String> address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of port ranges for the destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return A list of port ranges for the destination.
     */
    public final List<PortRange> portRanges() {
        return portRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddress() ? address() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPathComponentDetails)) {
            return false;
        }
        NetworkPathComponentDetails other = (NetworkPathComponentDetails) obj;
        return hasAddress() == other.hasAddress() && Objects.equals(address(), other.address())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkPathComponentDetails").add("Address", hasAddress() ? address() : null)
                .add("PortRanges", hasPortRanges() ? portRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkPathComponentDetails, T> g) {
        return obj -> g.apply((NetworkPathComponentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkPathComponentDetails> {
        /**
         * <p>
         * The IP addresses of the destination.
         * </p>
         * 
         * @param address
         *        The IP addresses of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Collection<String> address);

        /**
         * <p>
         * The IP addresses of the destination.
         * </p>
         * 
         * @param address
         *        The IP addresses of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String... address);

        /**
         * <p>
         * A list of port ranges for the destination.
         * </p>
         * 
         * @param portRanges
         *        A list of port ranges for the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<PortRange> portRanges);

        /**
         * <p>
         * A list of port ranges for the destination.
         * </p>
         * 
         * @param portRanges
         *        A list of port ranges for the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(PortRange... portRanges);

        /**
         * <p>
         * A list of port ranges for the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #portRanges(List<PortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(List<PortRange>)
         */
        Builder portRanges(Consumer<PortRange.Builder>... portRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<String> address = DefaultSdkAutoConstructList.getInstance();

        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkPathComponentDetails model) {
            address(model.address);
            portRanges(model.portRanges);
        }

        public final Collection<String> getAddress() {
            if (address instanceof SdkAutoConstructList) {
                return null;
            }
            return address;
        }

        public final void setAddress(Collection<String> address) {
            this.address = StringListCopier.copy(address);
        }

        @Override
        @Transient
        public final Builder address(Collection<String> address) {
            this.address = StringListCopier.copy(address);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder address(String... address) {
            address(Arrays.asList(address));
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        @Transient
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portRanges(PortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> PortRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkPathComponentDetails build() {
            return new NetworkPathComponentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
