/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An occurrence of sensitive data in an Adobe Portable Document Format (PDF) file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Page implements SdkPojo, Serializable, ToCopyableBuilder<Page.Builder, Page> {
    private static final SdkField<Long> PAGE_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PageNumber").getter(getter(Page::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final SdkField<Range> LINE_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("LineRange").getter(getter(Page::lineRange)).setter(setter(Builder::lineRange))
            .constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineRange").build()).build();

    private static final SdkField<Range> OFFSET_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("OffsetRange").getter(getter(Page::offsetRange)).setter(setter(Builder::offsetRange))
            .constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffsetRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_NUMBER_FIELD,
            LINE_RANGE_FIELD, OFFSET_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long pageNumber;

    private final Range lineRange;

    private final Range offsetRange;

    private Page(BuilderImpl builder) {
        this.pageNumber = builder.pageNumber;
        this.lineRange = builder.lineRange;
        this.offsetRange = builder.offsetRange;
    }

    /**
     * <p>
     * The page number of the page that contains the sensitive data.
     * </p>
     * 
     * @return The page number of the page that contains the sensitive data.
     */
    public final Long pageNumber() {
        return pageNumber;
    }

    /**
     * <p>
     * An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary text
     * files include files such as HTML, XML, JSON, and TXT files.
     * </p>
     * 
     * @return An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary
     *         text files include files such as HTML, XML, JSON, and TXT files.
     */
    public final Range lineRange() {
        return lineRange;
    }

    /**
     * <p>
     * An occurrence of sensitive data detected in a binary text file.
     * </p>
     * 
     * @return An occurrence of sensitive data detected in a binary text file.
     */
    public final Range offsetRange() {
        return offsetRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lineRange());
        hashCode = 31 * hashCode + Objects.hashCode(offsetRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page) obj;
        return Objects.equals(pageNumber(), other.pageNumber()) && Objects.equals(lineRange(), other.lineRange())
                && Objects.equals(offsetRange(), other.offsetRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Page").add("PageNumber", pageNumber()).add("LineRange", lineRange())
                .add("OffsetRange", offsetRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        case "LineRange":
            return Optional.ofNullable(clazz.cast(lineRange()));
        case "OffsetRange":
            return Optional.ofNullable(clazz.cast(offsetRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Page> {
        /**
         * <p>
         * The page number of the page that contains the sensitive data.
         * </p>
         * 
         * @param pageNumber
         *        The page number of the page that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Long pageNumber);

        /**
         * <p>
         * An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary text
         * files include files such as HTML, XML, JSON, and TXT files.
         * </p>
         * 
         * @param lineRange
         *        An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file.
         *        Non-binary text files include files such as HTML, XML, JSON, and TXT files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRange(Range lineRange);

        /**
         * <p>
         * An occurrence of sensitive data detected in a non-binary text file or a Microsoft Word file. Non-binary text
         * files include files such as HTML, XML, JSON, and TXT files.
         * </p>
         * This is a convenience that creates an instance of the {@link Range.Builder} avoiding the need to create one
         * manually via {@link Range#builder()}.
         *
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #lineRange(Range)}.
         * 
         * @param lineRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineRange(Range)
         */
        default Builder lineRange(Consumer<Range.Builder> lineRange) {
            return lineRange(Range.builder().applyMutation(lineRange).build());
        }

        /**
         * <p>
         * An occurrence of sensitive data detected in a binary text file.
         * </p>
         * 
         * @param offsetRange
         *        An occurrence of sensitive data detected in a binary text file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRange(Range offsetRange);

        /**
         * <p>
         * An occurrence of sensitive data detected in a binary text file.
         * </p>
         * This is a convenience that creates an instance of the {@link Range.Builder} avoiding the need to create one
         * manually via {@link Range#builder()}.
         *
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #offsetRange(Range)}.
         * 
         * @param offsetRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offsetRange(Range)
         */
        default Builder offsetRange(Consumer<Range.Builder> offsetRange) {
            return offsetRange(Range.builder().applyMutation(offsetRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long pageNumber;

        private Range lineRange;

        private Range offsetRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            pageNumber(model.pageNumber);
            lineRange(model.lineRange);
            offsetRange(model.offsetRange);
        }

        public final Long getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        @Transient
        public final Builder pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Range.Builder getLineRange() {
            return lineRange != null ? lineRange.toBuilder() : null;
        }

        public final void setLineRange(Range.BuilderImpl lineRange) {
            this.lineRange = lineRange != null ? lineRange.build() : null;
        }

        @Override
        @Transient
        public final Builder lineRange(Range lineRange) {
            this.lineRange = lineRange;
            return this;
        }

        public final Range.Builder getOffsetRange() {
            return offsetRange != null ? offsetRange.toBuilder() : null;
        }

        public final void setOffsetRange(Range.BuilderImpl offsetRange) {
            this.offsetRange = offsetRange != null ? offsetRange.build() : null;
        }

        @Override
        @Transient
        public final Builder offsetRange(Range offsetRange) {
            this.offsetRange = offsetRange;
            return this;
        }

        @Override
        public Page build() {
            return new Page(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
