/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupDetails.Builder, RuleGroupDetails> {
    private static final SdkField<RuleGroupVariables> RULE_VARIABLES_FIELD = SdkField
            .<RuleGroupVariables> builder(MarshallingType.SDK_POJO).memberName("RuleVariables")
            .getter(getter(RuleGroupDetails::ruleVariables)).setter(setter(Builder::ruleVariables))
            .constructor(RuleGroupVariables::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVariables").build()).build();

    private static final SdkField<RuleGroupSource> RULES_SOURCE_FIELD = SdkField
            .<RuleGroupSource> builder(MarshallingType.SDK_POJO).memberName("RulesSource")
            .getter(getter(RuleGroupDetails::rulesSource)).setter(setter(Builder::rulesSource))
            .constructor(RuleGroupSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_VARIABLES_FIELD,
            RULES_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuleGroupVariables ruleVariables;

    private final RuleGroupSource rulesSource;

    private RuleGroupDetails(BuilderImpl builder) {
        this.ruleVariables = builder.ruleVariables;
        this.rulesSource = builder.rulesSource;
    }

    /**
     * <p>
     * Additional settings to use in the specified rules.
     * </p>
     * 
     * @return Additional settings to use in the specified rules.
     */
    public final RuleGroupVariables ruleVariables() {
        return ruleVariables;
    }

    /**
     * <p>
     * The rules and actions for the rule group.
     * </p>
     * <p>
     * For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or
     * <code>StatefulRules</code>.
     * </p>
     * <p>
     * For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.
     * </p>
     * 
     * @return The rules and actions for the rule group.</p>
     *         <p>
     *         For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or
     *         <code>StatefulRules</code>.
     *         </p>
     *         <p>
     *         For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.
     */
    public final RuleGroupSource rulesSource() {
        return rulesSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleVariables());
        hashCode = 31 * hashCode + Objects.hashCode(rulesSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupDetails)) {
            return false;
        }
        RuleGroupDetails other = (RuleGroupDetails) obj;
        return Objects.equals(ruleVariables(), other.ruleVariables()) && Objects.equals(rulesSource(), other.rulesSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupDetails").add("RuleVariables", ruleVariables()).add("RulesSource", rulesSource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleVariables":
            return Optional.ofNullable(clazz.cast(ruleVariables()));
        case "RulesSource":
            return Optional.ofNullable(clazz.cast(rulesSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupDetails, T> g) {
        return obj -> g.apply((RuleGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupDetails> {
        /**
         * <p>
         * Additional settings to use in the specified rules.
         * </p>
         * 
         * @param ruleVariables
         *        Additional settings to use in the specified rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVariables(RuleGroupVariables ruleVariables);

        /**
         * <p>
         * Additional settings to use in the specified rules.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleGroupVariables.Builder} avoiding the need to
         * create one manually via {@link RuleGroupVariables#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupVariables.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleVariables(RuleGroupVariables)}.
         * 
         * @param ruleVariables
         *        a consumer that will call methods on {@link RuleGroupVariables.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleVariables(RuleGroupVariables)
         */
        default Builder ruleVariables(Consumer<RuleGroupVariables.Builder> ruleVariables) {
            return ruleVariables(RuleGroupVariables.builder().applyMutation(ruleVariables).build());
        }

        /**
         * <p>
         * The rules and actions for the rule group.
         * </p>
         * <p>
         * For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or
         * <code>StatefulRules</code>.
         * </p>
         * <p>
         * For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.
         * </p>
         * 
         * @param rulesSource
         *        The rules and actions for the rule group.</p>
         *        <p>
         *        For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or
         *        <code>StatefulRules</code>.
         *        </p>
         *        <p>
         *        For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesSource(RuleGroupSource rulesSource);

        /**
         * <p>
         * The rules and actions for the rule group.
         * </p>
         * <p>
         * For stateful rule groups, can contain <code>RulesString</code>, <code>RulesSourceList</code>, or
         * <code>StatefulRules</code>.
         * </p>
         * <p>
         * For stateless rule groups, contains <code>StatelessRulesAndCustomActions</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleGroupSource.Builder} avoiding the need to
         * create one manually via {@link RuleGroupSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupSource.Builder#build()} is called immediately and its
         * result is passed to {@link #rulesSource(RuleGroupSource)}.
         * 
         * @param rulesSource
         *        a consumer that will call methods on {@link RuleGroupSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesSource(RuleGroupSource)
         */
        default Builder rulesSource(Consumer<RuleGroupSource.Builder> rulesSource) {
            return rulesSource(RuleGroupSource.builder().applyMutation(rulesSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleGroupVariables ruleVariables;

        private RuleGroupSource rulesSource;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupDetails model) {
            ruleVariables(model.ruleVariables);
            rulesSource(model.rulesSource);
        }

        public final RuleGroupVariables.Builder getRuleVariables() {
            return ruleVariables != null ? ruleVariables.toBuilder() : null;
        }

        public final void setRuleVariables(RuleGroupVariables.BuilderImpl ruleVariables) {
            this.ruleVariables = ruleVariables != null ? ruleVariables.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleVariables(RuleGroupVariables ruleVariables) {
            this.ruleVariables = ruleVariables;
            return this;
        }

        public final RuleGroupSource.Builder getRulesSource() {
            return rulesSource != null ? rulesSource.toBuilder() : null;
        }

        public final void setRulesSource(RuleGroupSource.BuilderImpl rulesSource) {
            this.rulesSource = rulesSource != null ? rulesSource.build() : null;
        }

        @Override
        @Transient
        public final Builder rulesSource(RuleGroupSource rulesSource) {
            this.rulesSource = rulesSource;
            return this;
        }

        @Override
        public RuleGroupDetails build() {
            return new RuleGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
