/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rules and actions for the rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSource implements SdkPojo, Serializable, ToCopyableBuilder<RuleGroupSource.Builder, RuleGroupSource> {
    private static final SdkField<RuleGroupSourceListDetails> RULES_SOURCE_LIST_FIELD = SdkField
            .<RuleGroupSourceListDetails> builder(MarshallingType.SDK_POJO).memberName("RulesSourceList")
            .getter(getter(RuleGroupSource::rulesSourceList)).setter(setter(Builder::rulesSourceList))
            .constructor(RuleGroupSourceListDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSourceList").build()).build();

    private static final SdkField<String> RULES_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RulesString").getter(getter(RuleGroupSource::rulesString)).setter(setter(Builder::rulesString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesString").build()).build();

    private static final SdkField<List<RuleGroupSourceStatefulRulesDetails>> STATEFUL_RULES_FIELD = SdkField
            .<List<RuleGroupSourceStatefulRulesDetails>> builder(MarshallingType.LIST)
            .memberName("StatefulRules")
            .getter(getter(RuleGroupSource::statefulRules))
            .setter(setter(Builder::statefulRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatefulRulesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatefulRulesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RuleGroupSourceStatelessRulesAndCustomActionsDetails> STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD = SdkField
            .<RuleGroupSourceStatelessRulesAndCustomActionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("StatelessRulesAndCustomActions")
            .getter(getter(RuleGroupSource::statelessRulesAndCustomActions))
            .setter(setter(Builder::statelessRulesAndCustomActions))
            .constructor(RuleGroupSourceStatelessRulesAndCustomActionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRulesAndCustomActions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_SOURCE_LIST_FIELD,
            RULES_STRING_FIELD, STATEFUL_RULES_FIELD, STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuleGroupSourceListDetails rulesSourceList;

    private final String rulesString;

    private final List<RuleGroupSourceStatefulRulesDetails> statefulRules;

    private final RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions;

    private RuleGroupSource(BuilderImpl builder) {
        this.rulesSourceList = builder.rulesSourceList;
        this.rulesString = builder.rulesString;
        this.statefulRules = builder.statefulRules;
        this.statelessRulesAndCustomActions = builder.statelessRulesAndCustomActions;
    }

    /**
     * <p>
     * Stateful inspection criteria for a domain list rule group. A domain list rule group determines access by specific
     * protocols to specific domains.
     * </p>
     * 
     * @return Stateful inspection criteria for a domain list rule group. A domain list rule group determines access by
     *         specific protocols to specific domains.
     */
    public final RuleGroupSourceListDetails rulesSourceList() {
        return rulesSourceList;
    }

    /**
     * <p>
     * Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
     * </p>
     * 
     * @return Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
     */
    public final String rulesString() {
        return rulesString;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatefulRules() {
        return statefulRules != null && !(statefulRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Suricata rule specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulRules} method.
     * </p>
     * 
     * @return Suricata rule specifications.
     */
    public final List<RuleGroupSourceStatefulRulesDetails> statefulRules() {
        return statefulRules;
    }

    /**
     * <p>
     * The stateless rules and custom actions used by a stateless rule group.
     * </p>
     * 
     * @return The stateless rules and custom actions used by a stateless rule group.
     */
    public final RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions() {
        return statelessRulesAndCustomActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rulesSourceList());
        hashCode = 31 * hashCode + Objects.hashCode(rulesString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRules() ? statefulRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statelessRulesAndCustomActions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSource)) {
            return false;
        }
        RuleGroupSource other = (RuleGroupSource) obj;
        return Objects.equals(rulesSourceList(), other.rulesSourceList()) && Objects.equals(rulesString(), other.rulesString())
                && hasStatefulRules() == other.hasStatefulRules() && Objects.equals(statefulRules(), other.statefulRules())
                && Objects.equals(statelessRulesAndCustomActions(), other.statelessRulesAndCustomActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSource").add("RulesSourceList", rulesSourceList()).add("RulesString", rulesString())
                .add("StatefulRules", hasStatefulRules() ? statefulRules() : null)
                .add("StatelessRulesAndCustomActions", statelessRulesAndCustomActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RulesSourceList":
            return Optional.ofNullable(clazz.cast(rulesSourceList()));
        case "RulesString":
            return Optional.ofNullable(clazz.cast(rulesString()));
        case "StatefulRules":
            return Optional.ofNullable(clazz.cast(statefulRules()));
        case "StatelessRulesAndCustomActions":
            return Optional.ofNullable(clazz.cast(statelessRulesAndCustomActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSource, T> g) {
        return obj -> g.apply((RuleGroupSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSource> {
        /**
         * <p>
         * Stateful inspection criteria for a domain list rule group. A domain list rule group determines access by
         * specific protocols to specific domains.
         * </p>
         * 
         * @param rulesSourceList
         *        Stateful inspection criteria for a domain list rule group. A domain list rule group determines access
         *        by specific protocols to specific domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesSourceList(RuleGroupSourceListDetails rulesSourceList);

        /**
         * <p>
         * Stateful inspection criteria for a domain list rule group. A domain list rule group determines access by
         * specific protocols to specific domains.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleGroupSourceListDetails.Builder} avoiding the
         * need to create one manually via {@link RuleGroupSourceListDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupSourceListDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #rulesSourceList(RuleGroupSourceListDetails)}.
         * 
         * @param rulesSourceList
         *        a consumer that will call methods on {@link RuleGroupSourceListDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesSourceList(RuleGroupSourceListDetails)
         */
        default Builder rulesSourceList(Consumer<RuleGroupSourceListDetails.Builder> rulesSourceList) {
            return rulesSourceList(RuleGroupSourceListDetails.builder().applyMutation(rulesSourceList).build());
        }

        /**
         * <p>
         * Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
         * </p>
         * 
         * @param rulesString
         *        Stateful inspection criteria, provided in Suricata compatible intrusion prevention system (IPS) rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesString(String rulesString);

        /**
         * <p>
         * Suricata rule specifications.
         * </p>
         * 
         * @param statefulRules
         *        Suricata rule specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRules(Collection<RuleGroupSourceStatefulRulesDetails> statefulRules);

        /**
         * <p>
         * Suricata rule specifications.
         * </p>
         * 
         * @param statefulRules
         *        Suricata rule specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRules(RuleGroupSourceStatefulRulesDetails... statefulRules);

        /**
         * <p>
         * Suricata rule specifications.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <RuleGroupSourceStatefulRulesDetails>.Builder} avoiding the need to create one manually via {@link List
         * <RuleGroupSourceStatefulRulesDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleGroupSourceStatefulRulesDetails>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #statefulRules(List<RuleGroupSourceStatefulRulesDetails>)}.
         * 
         * @param statefulRules
         *        a consumer that will call methods on {@link List<RuleGroupSourceStatefulRulesDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRules(List<RuleGroupSourceStatefulRulesDetails>)
         */
        Builder statefulRules(Consumer<RuleGroupSourceStatefulRulesDetails.Builder>... statefulRules);

        /**
         * <p>
         * The stateless rules and custom actions used by a stateless rule group.
         * </p>
         * 
         * @param statelessRulesAndCustomActions
         *        The stateless rules and custom actions used by a stateless rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions);

        /**
         * <p>
         * The stateless rules and custom actions used by a stateless rule group.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder} avoiding the need to create one manually
         * via {@link RuleGroupSourceStatelessRulesAndCustomActionsDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails)}.
         * 
         * @param statelessRulesAndCustomActions
         *        a consumer that will call methods on
         *        {@link RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails)
         */
        default Builder statelessRulesAndCustomActions(
                Consumer<RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder> statelessRulesAndCustomActions) {
            return statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails.builder()
                    .applyMutation(statelessRulesAndCustomActions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleGroupSourceListDetails rulesSourceList;

        private String rulesString;

        private List<RuleGroupSourceStatefulRulesDetails> statefulRules = DefaultSdkAutoConstructList.getInstance();

        private RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSource model) {
            rulesSourceList(model.rulesSourceList);
            rulesString(model.rulesString);
            statefulRules(model.statefulRules);
            statelessRulesAndCustomActions(model.statelessRulesAndCustomActions);
        }

        public final RuleGroupSourceListDetails.Builder getRulesSourceList() {
            return rulesSourceList != null ? rulesSourceList.toBuilder() : null;
        }

        public final void setRulesSourceList(RuleGroupSourceListDetails.BuilderImpl rulesSourceList) {
            this.rulesSourceList = rulesSourceList != null ? rulesSourceList.build() : null;
        }

        @Override
        @Transient
        public final Builder rulesSourceList(RuleGroupSourceListDetails rulesSourceList) {
            this.rulesSourceList = rulesSourceList;
            return this;
        }

        public final String getRulesString() {
            return rulesString;
        }

        public final void setRulesString(String rulesString) {
            this.rulesString = rulesString;
        }

        @Override
        @Transient
        public final Builder rulesString(String rulesString) {
            this.rulesString = rulesString;
            return this;
        }

        public final List<RuleGroupSourceStatefulRulesDetails.Builder> getStatefulRules() {
            List<RuleGroupSourceStatefulRulesDetails.Builder> result = RuleGroupSourceStatefulRulesListCopier
                    .copyToBuilder(this.statefulRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRules(Collection<RuleGroupSourceStatefulRulesDetails.BuilderImpl> statefulRules) {
            this.statefulRules = RuleGroupSourceStatefulRulesListCopier.copyFromBuilder(statefulRules);
        }

        @Override
        @Transient
        public final Builder statefulRules(Collection<RuleGroupSourceStatefulRulesDetails> statefulRules) {
            this.statefulRules = RuleGroupSourceStatefulRulesListCopier.copy(statefulRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statefulRules(RuleGroupSourceStatefulRulesDetails... statefulRules) {
            statefulRules(Arrays.asList(statefulRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statefulRules(Consumer<RuleGroupSourceStatefulRulesDetails.Builder>... statefulRules) {
            statefulRules(Stream.of(statefulRules)
                    .map(c -> RuleGroupSourceStatefulRulesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder getStatelessRulesAndCustomActions() {
            return statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.toBuilder() : null;
        }

        public final void setStatelessRulesAndCustomActions(
                RuleGroupSourceStatelessRulesAndCustomActionsDetails.BuilderImpl statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder statelessRulesAndCustomActions(
                RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
            return this;
        }

        @Override
        public RuleGroupSource build() {
            return new RuleGroupSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
