/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom action definition. A custom action is an optional, non-standard action to use for stateless packet handling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceCustomActionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceCustomActionsDetails.Builder, RuleGroupSourceCustomActionsDetails> {
    private static final SdkField<StatelessCustomActionDefinition> ACTION_DEFINITION_FIELD = SdkField
            .<StatelessCustomActionDefinition> builder(MarshallingType.SDK_POJO).memberName("ActionDefinition")
            .getter(getter(RuleGroupSourceCustomActionsDetails::actionDefinition)).setter(setter(Builder::actionDefinition))
            .constructor(StatelessCustomActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDefinition").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(RuleGroupSourceCustomActionsDetails::actionName))
            .setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_DEFINITION_FIELD,
            ACTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatelessCustomActionDefinition actionDefinition;

    private final String actionName;

    private RuleGroupSourceCustomActionsDetails(BuilderImpl builder) {
        this.actionDefinition = builder.actionDefinition;
        this.actionName = builder.actionName;
    }

    /**
     * <p>
     * The definition of a custom action.
     * </p>
     * 
     * @return The definition of a custom action.
     */
    public final StatelessCustomActionDefinition actionDefinition() {
        return actionDefinition;
    }

    /**
     * <p>
     * A descriptive name of the custom action.
     * </p>
     * 
     * @return A descriptive name of the custom action.
     */
    public final String actionName() {
        return actionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceCustomActionsDetails)) {
            return false;
        }
        RuleGroupSourceCustomActionsDetails other = (RuleGroupSourceCustomActionsDetails) obj;
        return Objects.equals(actionDefinition(), other.actionDefinition()) && Objects.equals(actionName(), other.actionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceCustomActionsDetails").add("ActionDefinition", actionDefinition())
                .add("ActionName", actionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionDefinition":
            return Optional.ofNullable(clazz.cast(actionDefinition()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceCustomActionsDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceCustomActionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceCustomActionsDetails> {
        /**
         * <p>
         * The definition of a custom action.
         * </p>
         * 
         * @param actionDefinition
         *        The definition of a custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinition(StatelessCustomActionDefinition actionDefinition);

        /**
         * <p>
         * The definition of a custom action.
         * </p>
         * This is a convenience that creates an instance of the {@link StatelessCustomActionDefinition.Builder}
         * avoiding the need to create one manually via {@link StatelessCustomActionDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatelessCustomActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #actionDefinition(StatelessCustomActionDefinition)}.
         * 
         * @param actionDefinition
         *        a consumer that will call methods on {@link StatelessCustomActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionDefinition(StatelessCustomActionDefinition)
         */
        default Builder actionDefinition(Consumer<StatelessCustomActionDefinition.Builder> actionDefinition) {
            return actionDefinition(StatelessCustomActionDefinition.builder().applyMutation(actionDefinition).build());
        }

        /**
         * <p>
         * A descriptive name of the custom action.
         * </p>
         * 
         * @param actionName
         *        A descriptive name of the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);
    }

    static final class BuilderImpl implements Builder {
        private StatelessCustomActionDefinition actionDefinition;

        private String actionName;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceCustomActionsDetails model) {
            actionDefinition(model.actionDefinition);
            actionName(model.actionName);
        }

        public final StatelessCustomActionDefinition.Builder getActionDefinition() {
            return actionDefinition != null ? actionDefinition.toBuilder() : null;
        }

        public final void setActionDefinition(StatelessCustomActionDefinition.BuilderImpl actionDefinition) {
            this.actionDefinition = actionDefinition != null ? actionDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder actionDefinition(StatelessCustomActionDefinition actionDefinition) {
            this.actionDefinition = actionDefinition;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        @Override
        public RuleGroupSourceCustomActionsDetails build() {
            return new RuleGroupSourceCustomActionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
