/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Suricata rule specification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatefulRulesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceStatefulRulesDetails.Builder, RuleGroupSourceStatefulRulesDetails> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(RuleGroupSourceStatefulRulesDetails::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<RuleGroupSourceStatefulRulesHeaderDetails> HEADER_FIELD = SdkField
            .<RuleGroupSourceStatefulRulesHeaderDetails> builder(MarshallingType.SDK_POJO).memberName("Header")
            .getter(getter(RuleGroupSourceStatefulRulesDetails::header)).setter(setter(Builder::header))
            .constructor(RuleGroupSourceStatefulRulesHeaderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final SdkField<List<RuleGroupSourceStatefulRulesOptionsDetails>> RULE_OPTIONS_FIELD = SdkField
            .<List<RuleGroupSourceStatefulRulesOptionsDetails>> builder(MarshallingType.LIST)
            .memberName("RuleOptions")
            .getter(getter(RuleGroupSourceStatefulRulesDetails::ruleOptions))
            .setter(setter(Builder::ruleOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatefulRulesOptionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatefulRulesOptionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, HEADER_FIELD,
            RULE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final RuleGroupSourceStatefulRulesHeaderDetails header;

    private final List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions;

    private RuleGroupSourceStatefulRulesDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.header = builder.header;
        this.ruleOptions = builder.ruleOptions;
    }

    /**
     * <p>
     * Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful
     * rule criteria.
     * </p>
     * 
     * @return Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the
     *         stateful rule criteria.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The stateful inspection criteria for the rule.
     * </p>
     * 
     * @return The stateful inspection criteria for the rule.
     */
    public final RuleGroupSourceStatefulRulesHeaderDetails header() {
        return header;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleOptions() {
        return ruleOptions != null && !(ruleOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional options for the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleOptions} method.
     * </p>
     * 
     * @return Additional options for the rule.
     */
    public final List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions() {
        return ruleOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleOptions() ? ruleOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatefulRulesDetails)) {
            return false;
        }
        RuleGroupSourceStatefulRulesDetails other = (RuleGroupSourceStatefulRulesDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(header(), other.header())
                && hasRuleOptions() == other.hasRuleOptions() && Objects.equals(ruleOptions(), other.ruleOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatefulRulesDetails").add("Action", action()).add("Header", header())
                .add("RuleOptions", hasRuleOptions() ? ruleOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "RuleOptions":
            return Optional.ofNullable(clazz.cast(ruleOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatefulRulesDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatefulRulesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatefulRulesDetails> {
        /**
         * <p>
         * Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful
         * rule criteria.
         * </p>
         * 
         * @param action
         *        Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the
         *        stateful rule criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The stateful inspection criteria for the rule.
         * </p>
         * 
         * @param header
         *        The stateful inspection criteria for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(RuleGroupSourceStatefulRulesHeaderDetails header);

        /**
         * <p>
         * The stateful inspection criteria for the rule.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link RuleGroupSourceStatefulRulesHeaderDetails.Builder} avoiding the need to create one manually via
         * {@link RuleGroupSourceStatefulRulesHeaderDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupSourceStatefulRulesHeaderDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #header(RuleGroupSourceStatefulRulesHeaderDetails)}.
         * 
         * @param header
         *        a consumer that will call methods on {@link RuleGroupSourceStatefulRulesHeaderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #header(RuleGroupSourceStatefulRulesHeaderDetails)
         */
        default Builder header(Consumer<RuleGroupSourceStatefulRulesHeaderDetails.Builder> header) {
            return header(RuleGroupSourceStatefulRulesHeaderDetails.builder().applyMutation(header).build());
        }

        /**
         * <p>
         * Additional options for the rule.
         * </p>
         * 
         * @param ruleOptions
         *        Additional options for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions);

        /**
         * <p>
         * Additional options for the rule.
         * </p>
         * 
         * @param ruleOptions
         *        Additional options for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(RuleGroupSourceStatefulRulesOptionsDetails... ruleOptions);

        /**
         * <p>
         * Additional options for the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <RuleGroupSourceStatefulRulesOptionsDetails>.Builder} avoiding the need to create one manually via
         * {@link List<RuleGroupSourceStatefulRulesOptionsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleGroupSourceStatefulRulesOptionsDetails>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ruleOptions(List<RuleGroupSourceStatefulRulesOptionsDetails>)}.
         * 
         * @param ruleOptions
         *        a consumer that will call methods on {@link List<RuleGroupSourceStatefulRulesOptionsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleOptions(List<RuleGroupSourceStatefulRulesOptionsDetails>)
         */
        Builder ruleOptions(Consumer<RuleGroupSourceStatefulRulesOptionsDetails.Builder>... ruleOptions);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private RuleGroupSourceStatefulRulesHeaderDetails header;

        private List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatefulRulesDetails model) {
            action(model.action);
            header(model.header);
            ruleOptions(model.ruleOptions);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final RuleGroupSourceStatefulRulesHeaderDetails.Builder getHeader() {
            return header != null ? header.toBuilder() : null;
        }

        public final void setHeader(RuleGroupSourceStatefulRulesHeaderDetails.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        @Transient
        public final Builder header(RuleGroupSourceStatefulRulesHeaderDetails header) {
            this.header = header;
            return this;
        }

        public final List<RuleGroupSourceStatefulRulesOptionsDetails.Builder> getRuleOptions() {
            List<RuleGroupSourceStatefulRulesOptionsDetails.Builder> result = RuleGroupSourceStatefulRulesOptionsListCopier
                    .copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleGroupSourceStatefulRulesOptionsListCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        @Transient
        public final Builder ruleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions) {
            this.ruleOptions = RuleGroupSourceStatefulRulesOptionsListCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ruleOptions(RuleGroupSourceStatefulRulesOptionsDetails... ruleOptions) {
            ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleGroupSourceStatefulRulesOptionsDetails.Builder>... ruleOptions) {
            ruleOptions(Stream.of(ruleOptions)
                    .map(c -> RuleGroupSourceStatefulRulesOptionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleGroupSourceStatefulRulesDetails build() {
            return new RuleGroupSourceStatefulRulesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
