/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inspection criteria for a stateful rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatefulRulesHeaderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceStatefulRulesHeaderDetails.Builder, RuleGroupSourceStatefulRulesHeaderDetails> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPort").getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::direction))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePort").getter(getter(RuleGroupSourceStatefulRulesHeaderDetails::sourcePort))
            .setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            DESTINATION_PORT_FIELD, DIRECTION_FIELD, PROTOCOL_FIELD, SOURCE_FIELD, SOURCE_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final String destinationPort;

    private final String direction;

    private final String protocol;

    private final String source;

    private final String sourcePort;

    private RuleGroupSourceStatefulRulesHeaderDetails(BuilderImpl builder) {
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
        this.direction = builder.direction;
        this.protocol = builder.protocol;
        this.source = builder.source;
        this.sourcePort = builder.sourcePort;
    }

    /**
     * <p>
     * The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify
     * <code>ANY</code>.
     * </p>
     * 
     * @return The destination IP address or address range to inspect for, in CIDR notation. To match with any address,
     *         specify <code>ANY</code>.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The destination port to inspect for. You can specify an individual port, such as <code>1994</code>. You also can
     * specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The destination port to inspect for. You can specify an individual port, such as <code>1994</code>. You
     *         also can specify a port range, such as <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
     * traffic, both from the source to the destination and from the destination to the source. If set to
     * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
     * </p>
     * 
     * @return The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
     *         bidirectional traffic, both from the source to the destination and from the destination to the source. If
     *         set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
     *         destination.
     */
    public final String direction() {
        return direction;
    }

    /**
     * <p>
     * The protocol to inspect for. To inspector for all protocols, use <code>IP</code>.
     * </p>
     * 
     * @return The protocol to inspect for. To inspector for all protocols, use <code>IP</code>.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify
     * <code>ANY</code>.
     * </p>
     * 
     * @return The source IP address or address range to inspect for, in CIDR notation. To match with any address,
     *         specify <code>ANY</code>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The source port to inspect for. You can specify an individual port, such as <code>1994</code>. You also can
     * specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The source port to inspect for. You can specify an individual port, such as <code>1994</code>. You also
     *         can specify a port range, such as <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String sourcePort() {
        return sourcePort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(direction());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatefulRulesHeaderDetails)) {
            return false;
        }
        RuleGroupSourceStatefulRulesHeaderDetails other = (RuleGroupSourceStatefulRulesHeaderDetails) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(direction(), other.direction()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(source(), other.source()) && Objects.equals(sourcePort(), other.sourcePort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatefulRulesHeaderDetails").add("Destination", destination())
                .add("DestinationPort", destinationPort()).add("Direction", direction()).add("Protocol", protocol())
                .add("Source", source()).add("SourcePort", sourcePort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(direction()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatefulRulesHeaderDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatefulRulesHeaderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatefulRulesHeaderDetails> {
        /**
         * <p>
         * The destination IP address or address range to inspect for, in CIDR notation. To match with any address,
         * specify <code>ANY</code>.
         * </p>
         * 
         * @param destination
         *        The destination IP address or address range to inspect for, in CIDR notation. To match with any
         *        address, specify <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The destination port to inspect for. You can specify an individual port, such as <code>1994</code>. You also
         * can specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
         * </p>
         * 
         * @param destinationPort
         *        The destination port to inspect for. You can specify an individual port, such as <code>1994</code>.
         *        You also can specify a port range, such as <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(String destinationPort);

        /**
         * <p>
         * The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches bidirectional
         * traffic, both from the source to the destination and from the destination to the source. If set to
         * <code>FORWARD</code>, the inspection only matches traffic going from the source to the destination.
         * </p>
         * 
         * @param direction
         *        The direction of traffic flow to inspect. If set to <code>ANY</code>, the inspection matches
         *        bidirectional traffic, both from the source to the destination and from the destination to the source.
         *        If set to <code>FORWARD</code>, the inspection only matches traffic going from the source to the
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder direction(String direction);

        /**
         * <p>
         * The protocol to inspect for. To inspector for all protocols, use <code>IP</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol to inspect for. To inspector for all protocols, use <code>IP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify
         * <code>ANY</code>.
         * </p>
         * 
         * @param source
         *        The source IP address or address range to inspect for, in CIDR notation. To match with any address,
         *        specify <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The source port to inspect for. You can specify an individual port, such as <code>1994</code>. You also can
         * specify a port range, such as <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
         * </p>
         * 
         * @param sourcePort
         *        The source port to inspect for. You can specify an individual port, such as <code>1994</code>. You
         *        also can specify a port range, such as <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(String sourcePort);
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private String destinationPort;

        private String direction;

        private String protocol;

        private String source;

        private String sourcePort;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatefulRulesHeaderDetails model) {
            destination(model.destination);
            destinationPort(model.destinationPort);
            direction(model.direction);
            protocol(model.protocol);
            source(model.source);
            sourcePort(model.sourcePort);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        @Transient
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        @Transient
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        @Transient
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        @Override
        public RuleGroupSourceStatefulRulesHeaderDetails build() {
            return new RuleGroupSourceStatefulRulesHeaderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
