/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A destination IP address or range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRuleMatchAttributesDestinations
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder, RuleGroupSourceStatelessRuleMatchAttributesDestinations> {
    private static final SdkField<String> ADDRESS_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressDefinition")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributesDestinations::addressDefinition))
            .setter(setter(Builder::addressDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addressDefinition;

    private RuleGroupSourceStatelessRuleMatchAttributesDestinations(BuilderImpl builder) {
        this.addressDefinition = builder.addressDefinition;
    }

    /**
     * <p>
     * An IP address or a block of IP addresses.
     * </p>
     * 
     * @return An IP address or a block of IP addresses.
     */
    public final String addressDefinition() {
        return addressDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleMatchAttributesDestinations)) {
            return false;
        }
        RuleGroupSourceStatelessRuleMatchAttributesDestinations other = (RuleGroupSourceStatelessRuleMatchAttributesDestinations) obj;
        return Objects.equals(addressDefinition(), other.addressDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRuleMatchAttributesDestinations")
                .add("AddressDefinition", addressDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressDefinition":
            return Optional.ofNullable(clazz.cast(addressDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleMatchAttributesDestinations, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleMatchAttributesDestinations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributesDestinations> {
        /**
         * <p>
         * An IP address or a block of IP addresses.
         * </p>
         * 
         * @param addressDefinition
         *        An IP address or a block of IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressDefinition(String addressDefinition);
    }

    static final class BuilderImpl implements Builder {
        private String addressDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleMatchAttributesDestinations model) {
            addressDefinition(model.addressDefinition);
        }

        public final String getAddressDefinition() {
            return addressDefinition;
        }

        public final void setAddressDefinition(String addressDefinition) {
            this.addressDefinition = addressDefinition;
        }

        @Override
        @Transient
        public final Builder addressDefinition(String addressDefinition) {
            this.addressDefinition = addressDefinition;
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRuleMatchAttributesDestinations build() {
            return new RuleGroupSourceStatelessRuleMatchAttributesDestinations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
