/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of a custom action that can be used for stateless packet handling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatelessCustomActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<StatelessCustomActionDefinition.Builder, StatelessCustomActionDefinition> {
    private static final SdkField<StatelessCustomPublishMetricAction> PUBLISH_METRIC_ACTION_FIELD = SdkField
            .<StatelessCustomPublishMetricAction> builder(MarshallingType.SDK_POJO).memberName("PublishMetricAction")
            .getter(getter(StatelessCustomActionDefinition::publishMetricAction)).setter(setter(Builder::publishMetricAction))
            .constructor(StatelessCustomPublishMetricAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishMetricAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISH_METRIC_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatelessCustomPublishMetricAction publishMetricAction;

    private StatelessCustomActionDefinition(BuilderImpl builder) {
        this.publishMetricAction = builder.publishMetricAction;
    }

    /**
     * <p>
     * Information about metrics to publish to CloudWatch.
     * </p>
     * 
     * @return Information about metrics to publish to CloudWatch.
     */
    public final StatelessCustomPublishMetricAction publishMetricAction() {
        return publishMetricAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publishMetricAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatelessCustomActionDefinition)) {
            return false;
        }
        StatelessCustomActionDefinition other = (StatelessCustomActionDefinition) obj;
        return Objects.equals(publishMetricAction(), other.publishMetricAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatelessCustomActionDefinition").add("PublishMetricAction", publishMetricAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublishMetricAction":
            return Optional.ofNullable(clazz.cast(publishMetricAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatelessCustomActionDefinition, T> g) {
        return obj -> g.apply((StatelessCustomActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatelessCustomActionDefinition> {
        /**
         * <p>
         * Information about metrics to publish to CloudWatch.
         * </p>
         * 
         * @param publishMetricAction
         *        Information about metrics to publish to CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishMetricAction(StatelessCustomPublishMetricAction publishMetricAction);

        /**
         * <p>
         * Information about metrics to publish to CloudWatch.
         * </p>
         * This is a convenience that creates an instance of the {@link StatelessCustomPublishMetricAction.Builder}
         * avoiding the need to create one manually via {@link StatelessCustomPublishMetricAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatelessCustomPublishMetricAction.Builder#build()} is called
         * immediately and its result is passed to {@link #publishMetricAction(StatelessCustomPublishMetricAction)}.
         * 
         * @param publishMetricAction
         *        a consumer that will call methods on {@link StatelessCustomPublishMetricAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publishMetricAction(StatelessCustomPublishMetricAction)
         */
        default Builder publishMetricAction(Consumer<StatelessCustomPublishMetricAction.Builder> publishMetricAction) {
            return publishMetricAction(StatelessCustomPublishMetricAction.builder().applyMutation(publishMetricAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StatelessCustomPublishMetricAction publishMetricAction;

        private BuilderImpl() {
        }

        private BuilderImpl(StatelessCustomActionDefinition model) {
            publishMetricAction(model.publishMetricAction);
        }

        public final StatelessCustomPublishMetricAction.Builder getPublishMetricAction() {
            return publishMetricAction != null ? publishMetricAction.toBuilder() : null;
        }

        public final void setPublishMetricAction(StatelessCustomPublishMetricAction.BuilderImpl publishMetricAction) {
            this.publishMetricAction = publishMetricAction != null ? publishMetricAction.build() : null;
        }

        @Override
        @Transient
        public final Builder publishMetricAction(StatelessCustomPublishMetricAction publishMetricAction) {
            this.publishMetricAction = publishMetricAction;
            return this;
        }

        @Override
        public StatelessCustomActionDefinition build() {
            return new StatelessCustomActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
