/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityHubConfigurationRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateSecurityHubConfigurationRequest.Builder, UpdateSecurityHubConfigurationRequest> {
    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnableControls").getter(getter(UpdateSecurityHubConfigurationRequest::autoEnableControls))
            .setter(setter(Builder::autoEnableControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_CONTROLS_FIELD));

    private final Boolean autoEnableControls;

    private UpdateSecurityHubConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableControls = builder.autoEnableControls;
    }

    /**
     * <p>
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     * </p>
     * <p>
     * By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically
     * enable new controls, set this to <code>false</code>.
     * </p>
     * 
     * @return Whether to automatically enable new controls when they are added to standards that are enabled.</p>
     *         <p>
     *         By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
     *         automatically enable new controls, set this to <code>false</code>.
     */
    public final Boolean autoEnableControls() {
        return autoEnableControls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableControls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityHubConfigurationRequest)) {
            return false;
        }
        UpdateSecurityHubConfigurationRequest other = (UpdateSecurityHubConfigurationRequest) obj;
        return Objects.equals(autoEnableControls(), other.autoEnableControls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityHubConfigurationRequest").add("AutoEnableControls", autoEnableControls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnableControls":
            return Optional.ofNullable(clazz.cast(autoEnableControls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityHubConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSecurityHubConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityHubConfigurationRequest> {
        /**
         * <p>
         * Whether to automatically enable new controls when they are added to standards that are enabled.
         * </p>
         * <p>
         * By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
         * automatically enable new controls, set this to <code>false</code>.
         * </p>
         * 
         * @param autoEnableControls
         *        Whether to automatically enable new controls when they are added to standards that are enabled.</p>
         *        <p>
         *        By default, this is set to <code>true</code>, and new controls are enabled automatically. To not
         *        automatically enable new controls, set this to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableControls(Boolean autoEnableControls);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private Boolean autoEnableControls;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityHubConfigurationRequest model) {
            super(model);
            autoEnableControls(model.autoEnableControls);
        }

        public final Boolean getAutoEnableControls() {
            return autoEnableControls;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        @Transient
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityHubConfigurationRequest build() {
            return new UpdateSecurityHubConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
