/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A vendor that generates a vulnerability report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VulnerabilityVendor implements SdkPojo, Serializable,
        ToCopyableBuilder<VulnerabilityVendor.Builder, VulnerabilityVendor> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VulnerabilityVendor::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(VulnerabilityVendor::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> VENDOR_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorSeverity").getter(getter(VulnerabilityVendor::vendorSeverity))
            .setter(setter(Builder::vendorSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorSeverity").build()).build();

    private static final SdkField<String> VENDOR_CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorCreatedAt").getter(getter(VulnerabilityVendor::vendorCreatedAt))
            .setter(setter(Builder::vendorCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorCreatedAt").build()).build();

    private static final SdkField<String> VENDOR_UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorUpdatedAt").getter(getter(VulnerabilityVendor::vendorUpdatedAt))
            .setter(setter(Builder::vendorUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, URL_FIELD,
            VENDOR_SEVERITY_FIELD, VENDOR_CREATED_AT_FIELD, VENDOR_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String url;

    private final String vendorSeverity;

    private final String vendorCreatedAt;

    private final String vendorUpdatedAt;

    private VulnerabilityVendor(BuilderImpl builder) {
        this.name = builder.name;
        this.url = builder.url;
        this.vendorSeverity = builder.vendorSeverity;
        this.vendorCreatedAt = builder.vendorCreatedAt;
        this.vendorUpdatedAt = builder.vendorUpdatedAt;
    }

    /**
     * <p>
     * The name of the vendor.
     * </p>
     * 
     * @return The name of the vendor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The URL of the vulnerability advisory.
     * </p>
     * 
     * @return The URL of the vulnerability advisory.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The severity that the vendor assigned to the vulnerability.
     * </p>
     * 
     * @return The severity that the vendor assigned to the vulnerability.
     */
    public final String vendorSeverity() {
        return vendorSeverity;
    }

    /**
     * <p>
     * Indicates when the vulnerability advisory was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the vulnerability advisory was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String vendorCreatedAt() {
        return vendorCreatedAt;
    }

    /**
     * <p>
     * Indicates when the vulnerability advisory was last updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the vulnerability advisory was last updated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String vendorUpdatedAt() {
        return vendorUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(vendorSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(vendorCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vendorUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerabilityVendor)) {
            return false;
        }
        VulnerabilityVendor other = (VulnerabilityVendor) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(url(), other.url())
                && Objects.equals(vendorSeverity(), other.vendorSeverity())
                && Objects.equals(vendorCreatedAt(), other.vendorCreatedAt())
                && Objects.equals(vendorUpdatedAt(), other.vendorUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VulnerabilityVendor").add("Name", name()).add("Url", url())
                .add("VendorSeverity", vendorSeverity()).add("VendorCreatedAt", vendorCreatedAt())
                .add("VendorUpdatedAt", vendorUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "VendorSeverity":
            return Optional.ofNullable(clazz.cast(vendorSeverity()));
        case "VendorCreatedAt":
            return Optional.ofNullable(clazz.cast(vendorCreatedAt()));
        case "VendorUpdatedAt":
            return Optional.ofNullable(clazz.cast(vendorUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VulnerabilityVendor, T> g) {
        return obj -> g.apply((VulnerabilityVendor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VulnerabilityVendor> {
        /**
         * <p>
         * The name of the vendor.
         * </p>
         * 
         * @param name
         *        The name of the vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URL of the vulnerability advisory.
         * </p>
         * 
         * @param url
         *        The URL of the vulnerability advisory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The severity that the vendor assigned to the vulnerability.
         * </p>
         * 
         * @param vendorSeverity
         *        The severity that the vendor assigned to the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorSeverity(String vendorSeverity);

        /**
         * <p>
         * Indicates when the vulnerability advisory was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param vendorCreatedAt
         *        Indicates when the vulnerability advisory was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorCreatedAt(String vendorCreatedAt);

        /**
         * <p>
         * Indicates when the vulnerability advisory was last updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param vendorUpdatedAt
         *        Indicates when the vulnerability advisory was last updated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorUpdatedAt(String vendorUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String url;

        private String vendorSeverity;

        private String vendorCreatedAt;

        private String vendorUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerabilityVendor model) {
            name(model.name);
            url(model.url);
            vendorSeverity(model.vendorSeverity);
            vendorCreatedAt(model.vendorCreatedAt);
            vendorUpdatedAt(model.vendorUpdatedAt);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getVendorSeverity() {
            return vendorSeverity;
        }

        public final void setVendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
        }

        @Override
        @Transient
        public final Builder vendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
            return this;
        }

        public final String getVendorCreatedAt() {
            return vendorCreatedAt;
        }

        public final void setVendorCreatedAt(String vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
        }

        @Override
        @Transient
        public final Builder vendorCreatedAt(String vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
            return this;
        }

        public final String getVendorUpdatedAt() {
            return vendorUpdatedAt;
        }

        public final void setVendorUpdatedAt(String vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
        }

        @Override
        @Transient
        public final Builder vendorUpdatedAt(String vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
            return this;
        }

        @Override
        public VulnerabilityVendor build() {
            return new VulnerabilityVendor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
