/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the Amazon SNS event notifications for the specified backup vault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupVaultNotificationsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupVaultNotificationsDetails.Builder, AwsBackupBackupVaultNotificationsDetails> {
    private static final SdkField<List<String>> BACKUP_VAULT_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BackupVaultEvents")
            .getter(getter(AwsBackupBackupVaultNotificationsDetails::backupVaultEvents))
            .setter(setter(Builder::backupVaultEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(AwsBackupBackupVaultNotificationsDetails::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_EVENTS_FIELD,
            SNS_TOPIC_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> backupVaultEvents;

    private final String snsTopicArn;

    private AwsBackupBackupVaultNotificationsDetails(BuilderImpl builder) {
        this.backupVaultEvents = builder.backupVaultEvents;
        this.snsTopicArn = builder.snsTopicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupVaultEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupVaultEvents() {
        return backupVaultEvents != null && !(backupVaultEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of events that indicate the status of jobs to back up resources to the backup vault. The following
     * events are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupVaultEvents} method.
     * </p>
     * 
     * @return An array of events that indicate the status of jobs to back up resources to the backup vault. The
     *         following events are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
     *         </p>
     *         </li>
     */
    public final List<String> backupVaultEvents() {
        return backupVaultEvents;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the Amazon SNS topic for a backup vault’s events.
     * </p>
     * 
     * @return An ARN that uniquely identifies the Amazon SNS topic for a backup vault’s events.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupVaultEvents() ? backupVaultEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupVaultNotificationsDetails)) {
            return false;
        }
        AwsBackupBackupVaultNotificationsDetails other = (AwsBackupBackupVaultNotificationsDetails) obj;
        return hasBackupVaultEvents() == other.hasBackupVaultEvents()
                && Objects.equals(backupVaultEvents(), other.backupVaultEvents())
                && Objects.equals(snsTopicArn(), other.snsTopicArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupVaultNotificationsDetails")
                .add("BackupVaultEvents", hasBackupVaultEvents() ? backupVaultEvents() : null).add("SnsTopicArn", snsTopicArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultEvents":
            return Optional.ofNullable(clazz.cast(backupVaultEvents()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupVaultNotificationsDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupVaultNotificationsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupVaultNotificationsDetails> {
        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault. The following
         * events are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault. The
         *        following events are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(Collection<String> backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault. The following
         * events are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault. The
         *        following events are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(String... backupVaultEvents);

        /**
         * <p>
         * An ARN that uniquely identifies the Amazon SNS topic for a backup vault’s events.
         * </p>
         * 
         * @param snsTopicArn
         *        An ARN that uniquely identifies the Amazon SNS topic for a backup vault’s events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> backupVaultEvents = DefaultSdkAutoConstructList.getInstance();

        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupVaultNotificationsDetails model) {
            backupVaultEvents(model.backupVaultEvents);
            snsTopicArn(model.snsTopicArn);
        }

        public final Collection<String> getBackupVaultEvents() {
            if (backupVaultEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return backupVaultEvents;
        }

        public final void setBackupVaultEvents(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = NonEmptyStringListCopier.copy(backupVaultEvents);
        }

        @Override
        public final Builder backupVaultEvents(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = NonEmptyStringListCopier.copy(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEvents(String... backupVaultEvents) {
            backupVaultEvents(Arrays.asList(backupVaultEvents));
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        @Override
        public AwsBackupBackupVaultNotificationsDetails build() {
            return new AwsBackupBackupVaultNotificationsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
