/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2InstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2InstanceDetails.Builder, AwsEc2InstanceDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEc2InstanceDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(AwsEc2InstanceDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpV4Addresses")
            .getter(getter(AwsEc2InstanceDetails::ipV4Addresses))
            .setter(setter(Builder::ipV4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpV6Addresses")
            .getter(getter(AwsEc2InstanceDetails::ipV6Addresses))
            .setter(setter(Builder::ipV6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(AwsEc2InstanceDetails::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamInstanceProfileArn").getter(getter(AwsEc2InstanceDetails::iamInstanceProfileArn))
            .setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileArn").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2InstanceDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AwsEc2InstanceDetails::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchedAt").getter(getter(AwsEc2InstanceDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final SdkField<List<AwsEc2InstanceNetworkInterfacesDetails>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<AwsEc2InstanceNetworkInterfacesDetails>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(AwsEc2InstanceDetails::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2InstanceNetworkInterfacesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2InstanceNetworkInterfacesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType").getter(getter(AwsEc2InstanceDetails::virtualizationType))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").build())
            .build();

    private static final SdkField<AwsEc2InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<AwsEc2InstanceMetadataOptions> builder(MarshallingType.SDK_POJO).memberName("MetadataOptions")
            .getter(getter(AwsEc2InstanceDetails::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(AwsEc2InstanceMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IMAGE_ID_FIELD,
            IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD, KEY_NAME_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, VPC_ID_FIELD,
            SUBNET_ID_FIELD, LAUNCHED_AT_FIELD, NETWORK_INTERFACES_FIELD, VIRTUALIZATION_TYPE_FIELD, METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String imageId;

    private final List<String> ipV4Addresses;

    private final List<String> ipV6Addresses;

    private final String keyName;

    private final String iamInstanceProfileArn;

    private final String vpcId;

    private final String subnetId;

    private final String launchedAt;

    private final List<AwsEc2InstanceNetworkInterfacesDetails> networkInterfaces;

    private final String virtualizationType;

    private final AwsEc2InstanceMetadataOptions metadataOptions;

    private AwsEc2InstanceDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.imageId = builder.imageId;
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.keyName = builder.keyName;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.launchedAt = builder.launchedAt;
        this.networkInterfaces = builder.networkInterfaces;
        this.virtualizationType = builder.virtualizationType;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * 
     * @return The instance type of the instance.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) ID of the instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV4Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV4Addresses() {
        return ipV4Addresses != null && !(ipV4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV4Addresses} method.
     * </p>
     * 
     * @return The IPv4 addresses associated with the instance.
     */
    public final List<String> ipV4Addresses() {
        return ipV4Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV6Addresses() {
        return ipV6Addresses != null && !(ipV6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses associated with the instance.
     */
    public final List<String> ipV6Addresses() {
        return ipV6Addresses;
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * 
     * @return The key name associated with the instance.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * 
     * @return The IAM profile ARN of the instance.
     */
    public final String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the VPC that the instance was launched in.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the subnet that the instance was launched in.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Indicates when the instance was launched.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the instance was launched.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String launchedAt() {
        return launchedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in a
     * corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return The identifiers of the network interfaces for the EC2 instance. The details for each network interface
     *         are in a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
     */
    public final List<AwsEc2InstanceNetworkInterfacesDetails> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
     * </p>
     * 
     * @return The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
     */
    public final String virtualizationType() {
        return virtualizationType;
    }

    /**
     * <p>
     * Details about the metadata options for the Amazon EC2 instance.
     * </p>
     * 
     * @return Details about the metadata options for the Amazon EC2 instance.
     */
    public final AwsEc2InstanceMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV4Addresses() ? ipV4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV6Addresses() ? ipV6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceDetails)) {
            return false;
        }
        AwsEc2InstanceDetails other = (AwsEc2InstanceDetails) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(imageId(), other.imageId())
                && hasIpV4Addresses() == other.hasIpV4Addresses() && Objects.equals(ipV4Addresses(), other.ipV4Addresses())
                && hasIpV6Addresses() == other.hasIpV6Addresses() && Objects.equals(ipV6Addresses(), other.ipV6Addresses())
                && Objects.equals(keyName(), other.keyName())
                && Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(launchedAt(), other.launchedAt()) && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(virtualizationType(), other.virtualizationType())
                && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2InstanceDetails").add("Type", type()).add("ImageId", imageId())
                .add("IpV4Addresses", hasIpV4Addresses() ? ipV4Addresses() : null)
                .add("IpV6Addresses", hasIpV6Addresses() ? ipV6Addresses() : null).add("KeyName", keyName())
                .add("IamInstanceProfileArn", iamInstanceProfileArn()).add("VpcId", vpcId()).add("SubnetId", subnetId())
                .add("LaunchedAt", launchedAt()).add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("VirtualizationType", virtualizationType()).add("MetadataOptions", metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "IpV4Addresses":
            return Optional.ofNullable(clazz.cast(ipV4Addresses()));
        case "IpV6Addresses":
            return Optional.ofNullable(clazz.cast(ipV6Addresses()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "IamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationType()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceDetails, T> g) {
        return obj -> g.apply((AwsEc2InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2InstanceDetails> {
        /**
         * <p>
         * The instance type of the instance.
         * </p>
         * 
         * @param type
         *        The instance type of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID of the instance.
         * </p>
         * 
         * @param imageId
         *        The Amazon Machine Image (AMI) ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(Collection<String> ipV4Addresses);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(String... ipV4Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(Collection<String> ipV6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(String... ipV6Addresses);

        /**
         * <p>
         * The key name associated with the instance.
         * </p>
         * 
         * @param keyName
         *        The key name associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The IAM profile ARN of the instance.
         * </p>
         * 
         * @param iamInstanceProfileArn
         *        The IAM profile ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * <p>
         * The identifier of the VPC that the instance was launched in.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The identifier of the subnet that the instance was launched in.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Indicates when the instance was launched.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param launchedAt
         *        Indicates when the instance was launched.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(String launchedAt);

        /**
         * <p>
         * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in
         * a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
         * </p>
         * 
         * @param networkInterfaces
         *        The identifiers of the network interfaces for the EC2 instance. The details for each network interface
         *        are in a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<AwsEc2InstanceNetworkInterfacesDetails> networkInterfaces);

        /**
         * <p>
         * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in
         * a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
         * </p>
         * 
         * @param networkInterfaces
         *        The identifiers of the network interfaces for the EC2 instance. The details for each network interface
         *        are in a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(AwsEc2InstanceNetworkInterfacesDetails... networkInterfaces);

        /**
         * <p>
         * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in
         * a corresponding <code>AwsEc2NetworkInterfacesDetails</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #networkInterfaces(List<AwsEc2InstanceNetworkInterfacesDetails>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<AwsEc2InstanceNetworkInterfacesDetails>)
         */
        Builder networkInterfaces(Consumer<AwsEc2InstanceNetworkInterfacesDetails.Builder>... networkInterfaces);

        /**
         * <p>
         * The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * Details about the metadata options for the Amazon EC2 instance.
         * </p>
         * 
         * @param metadataOptions
         *        Details about the metadata options for the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(AwsEc2InstanceMetadataOptions metadataOptions);

        /**
         * <p>
         * Details about the metadata options for the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEc2InstanceMetadataOptions.Builder}
         * avoiding the need to create one manually via {@link AwsEc2InstanceMetadataOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2InstanceMetadataOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(AwsEc2InstanceMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link AwsEc2InstanceMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(AwsEc2InstanceMetadataOptions)
         */
        default Builder metadataOptions(Consumer<AwsEc2InstanceMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(AwsEc2InstanceMetadataOptions.builder().applyMutation(metadataOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String imageId;

        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String keyName;

        private String iamInstanceProfileArn;

        private String vpcId;

        private String subnetId;

        private String launchedAt;

        private List<AwsEc2InstanceNetworkInterfacesDetails> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String virtualizationType;

        private AwsEc2InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceDetails model) {
            type(model.type);
            imageId(model.imageId);
            ipV4Addresses(model.ipV4Addresses);
            ipV6Addresses(model.ipV6Addresses);
            keyName(model.keyName);
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            vpcId(model.vpcId);
            subnetId(model.subnetId);
            launchedAt(model.launchedAt);
            networkInterfaces(model.networkInterfaces);
            virtualizationType(model.virtualizationType);
            metadataOptions(model.metadataOptions);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Collection<String> getIpV4Addresses() {
            if (ipV4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV4Addresses;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String... ipV4Addresses) {
            ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final Collection<String> getIpV6Addresses() {
            if (ipV6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV6Addresses;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String... ipV6Addresses) {
            ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getLaunchedAt() {
            return launchedAt;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final List<AwsEc2InstanceNetworkInterfacesDetails.Builder> getNetworkInterfaces() {
            List<AwsEc2InstanceNetworkInterfacesDetails.Builder> result = AwsEc2InstanceNetworkInterfacesListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<AwsEc2InstanceNetworkInterfacesDetails.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = AwsEc2InstanceNetworkInterfacesListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<AwsEc2InstanceNetworkInterfacesDetails> networkInterfaces) {
            this.networkInterfaces = AwsEc2InstanceNetworkInterfacesListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(AwsEc2InstanceNetworkInterfacesDetails... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<AwsEc2InstanceNetworkInterfacesDetails.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> AwsEc2InstanceNetworkInterfacesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final AwsEc2InstanceMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(AwsEc2InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(AwsEc2InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        @Override
        public AwsEc2InstanceDetails build() {
            return new AwsEc2InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
