/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the VPN tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpnConnectionVgwTelemetryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpnConnectionVgwTelemetryDetails.Builder, AwsEc2VpnConnectionVgwTelemetryDetails> {
    private static final SdkField<Integer> ACCEPTED_ROUTE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AcceptedRouteCount").getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::acceptedRouteCount))
            .setter(setter(Builder::acceptedRouteCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptedRouteCount").build())
            .build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> LAST_STATUS_CHANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastStatusChange").getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusChange").build()).build();

    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutsideIpAddress").getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::outsideIpAddress))
            .setter(setter(Builder::outsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(AwsEc2VpnConnectionVgwTelemetryDetails::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_ROUTE_COUNT_FIELD,
            CERTIFICATE_ARN_FIELD, LAST_STATUS_CHANGE_FIELD, OUTSIDE_IP_ADDRESS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer acceptedRouteCount;

    private final String certificateArn;

    private final String lastStatusChange;

    private final String outsideIpAddress;

    private final String status;

    private final String statusMessage;

    private AwsEc2VpnConnectionVgwTelemetryDetails(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.certificateArn = builder.certificateArn;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The number of accepted routes.
     * </p>
     * 
     * @return The number of accepted routes.
     */
    public final Integer acceptedRouteCount() {
        return acceptedRouteCount;
    }

    /**
     * <p>
     * The ARN of the VPN tunnel endpoint certificate.
     * </p>
     * 
     * @return The ARN of the VPN tunnel endpoint certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The date and time of the last change in status.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The date and time of the last change in status.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastStatusChange() {
        return lastStatusChange;
    }

    /**
     * <p>
     * The Internet-routable IP address of the virtual private gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the virtual private gateway's outside interface.
     */
    public final String outsideIpAddress() {
        return outsideIpAddress;
    }

    /**
     * <p>
     * The status of the VPN tunnel. Valid values are <code>DOWN</code> or <code>UP</code>.
     * </p>
     * 
     * @return The status of the VPN tunnel. Valid values are <code>DOWN</code> or <code>UP</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurs, a description of the error.
     * </p>
     * 
     * @return If an error occurs, a description of the error.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptedRouteCount());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionVgwTelemetryDetails)) {
            return false;
        }
        AwsEc2VpnConnectionVgwTelemetryDetails other = (AwsEc2VpnConnectionVgwTelemetryDetails) obj;
        return Objects.equals(acceptedRouteCount(), other.acceptedRouteCount())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(lastStatusChange(), other.lastStatusChange())
                && Objects.equals(outsideIpAddress(), other.outsideIpAddress()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpnConnectionVgwTelemetryDetails").add("AcceptedRouteCount", acceptedRouteCount())
                .add("CertificateArn", certificateArn()).add("LastStatusChange", lastStatusChange())
                .add("OutsideIpAddress", outsideIpAddress()).add("Status", status()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptedRouteCount":
            return Optional.ofNullable(clazz.cast(acceptedRouteCount()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "LastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        case "OutsideIpAddress":
            return Optional.ofNullable(clazz.cast(outsideIpAddress()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionVgwTelemetryDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionVgwTelemetryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpnConnectionVgwTelemetryDetails> {
        /**
         * <p>
         * The number of accepted routes.
         * </p>
         * 
         * @param acceptedRouteCount
         *        The number of accepted routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedRouteCount(Integer acceptedRouteCount);

        /**
         * <p>
         * The ARN of the VPN tunnel endpoint certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the VPN tunnel endpoint certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The date and time of the last change in status.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastStatusChange
         *        The date and time of the last change in status.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(String lastStatusChange);

        /**
         * <p>
         * The Internet-routable IP address of the virtual private gateway's outside interface.
         * </p>
         * 
         * @param outsideIpAddress
         *        The Internet-routable IP address of the virtual private gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddress(String outsideIpAddress);

        /**
         * <p>
         * The status of the VPN tunnel. Valid values are <code>DOWN</code> or <code>UP</code>.
         * </p>
         * 
         * @param status
         *        The status of the VPN tunnel. Valid values are <code>DOWN</code> or <code>UP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurs, a description of the error.
         * </p>
         * 
         * @param statusMessage
         *        If an error occurs, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Integer acceptedRouteCount;

        private String certificateArn;

        private String lastStatusChange;

        private String outsideIpAddress;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionVgwTelemetryDetails model) {
            acceptedRouteCount(model.acceptedRouteCount);
            certificateArn(model.certificateArn);
            lastStatusChange(model.lastStatusChange);
            outsideIpAddress(model.outsideIpAddress);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return acceptedRouteCount;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getLastStatusChange() {
            return lastStatusChange;
        }

        public final void setLastStatusChange(String lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(String lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final String getOutsideIpAddress() {
            return outsideIpAddress;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public AwsEc2VpnConnectionVgwTelemetryDetails build() {
            return new AwsEc2VpnConnectionVgwTelemetryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
