/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a task definition. A task definition describes the container and volume definitions of an Amazon
 * Elastic Container Service task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionDetails.Builder, AwsEcsTaskDefinitionDetails> {
    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsDetails>> CONTAINER_DEFINITIONS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsDetails>> builder(MarshallingType.LIST)
            .memberName("ContainerDefinitions")
            .getter(getter(AwsEcsTaskDefinitionDetails::containerDefinitions))
            .setter(setter(Builder::containerDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cpu")
            .getter(getter(AwsEcsTaskDefinitionDetails::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(AwsEcsTaskDefinitionDetails::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Family")
            .getter(getter(AwsEcsTaskDefinitionDetails::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>> INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>> builder(MarshallingType.LIST)
            .memberName("InferenceAccelerators")
            .getter(getter(AwsEcsTaskDefinitionDetails::inferenceAccelerators))
            .setter(setter(Builder::inferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAccelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionInferenceAcceleratorsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IPC_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpcMode").getter(getter(AwsEcsTaskDefinitionDetails::ipcMode)).setter(setter(Builder::ipcMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpcMode").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Memory")
            .getter(getter(AwsEcsTaskDefinitionDetails::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()).build();

    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkMode").getter(getter(AwsEcsTaskDefinitionDetails::networkMode))
            .setter(setter(Builder::networkMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkMode").build()).build();

    private static final SdkField<String> PID_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PidMode").getter(getter(AwsEcsTaskDefinitionDetails::pidMode)).setter(setter(Builder::pidMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PidMode").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionPlacementConstraintsDetails>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionPlacementConstraintsDetails>> builder(MarshallingType.LIST)
            .memberName("PlacementConstraints")
            .getter(getter(AwsEcsTaskDefinitionDetails::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionPlacementConstraintsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionPlacementConstraintsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEcsTaskDefinitionProxyConfigurationDetails> PROXY_CONFIGURATION_FIELD = SdkField
            .<AwsEcsTaskDefinitionProxyConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("ProxyConfiguration")
            .getter(getter(AwsEcsTaskDefinitionDetails::proxyConfiguration)).setter(setter(Builder::proxyConfiguration))
            .constructor(AwsEcsTaskDefinitionProxyConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfiguration").build())
            .build();

    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequiresCompatibilities")
            .getter(getter(AwsEcsTaskDefinitionDetails::requiresCompatibilities))
            .setter(setter(Builder::requiresCompatibilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresCompatibilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskRoleArn").getter(getter(AwsEcsTaskDefinitionDetails::taskRoleArn))
            .setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRoleArn").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionVolumesDetails>> VOLUMES_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionVolumesDetails>> builder(MarshallingType.LIST)
            .memberName("Volumes")
            .getter(getter(AwsEcsTaskDefinitionDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionVolumesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionVolumesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_DEFINITIONS_FIELD,
            CPU_FIELD, EXECUTION_ROLE_ARN_FIELD, FAMILY_FIELD, INFERENCE_ACCELERATORS_FIELD, IPC_MODE_FIELD, MEMORY_FIELD,
            NETWORK_MODE_FIELD, PID_MODE_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PROXY_CONFIGURATION_FIELD,
            REQUIRES_COMPATIBILITIES_FIELD, TASK_ROLE_ARN_FIELD, VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions;

    private final String cpu;

    private final String executionRoleArn;

    private final String family;

    private final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators;

    private final String ipcMode;

    private final String memory;

    private final String networkMode;

    private final String pidMode;

    private final List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints;

    private final AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration;

    private final List<String> requiresCompatibilities;

    private final String taskRoleArn;

    private final List<AwsEcsTaskDefinitionVolumesDetails> volumes;

    private AwsEcsTaskDefinitionDetails(BuilderImpl builder) {
        this.containerDefinitions = builder.containerDefinitions;
        this.cpu = builder.cpu;
        this.executionRoleArn = builder.executionRoleArn;
        this.family = builder.family;
        this.inferenceAccelerators = builder.inferenceAccelerators;
        this.ipcMode = builder.ipcMode;
        this.memory = builder.memory;
        this.networkMode = builder.networkMode;
        this.pidMode = builder.pidMode;
        this.placementConstraints = builder.placementConstraints;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.taskRoleArn = builder.taskRoleArn;
        this.volumes = builder.volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerDefinitions() {
        return containerDefinitions != null && !(containerDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container definitions that describe the containers that make up the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerDefinitions} method.
     * </p>
     * 
     * @return The container definitions that describe the containers that make up the task.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions() {
        return containerDefinitions;
    }

    /**
     * <p>
     * The number of CPU units used by the task.Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>256 (.25 vCPU)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>512 (.5 vCPU)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>1024 (1 vCPU)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>2048 (2 vCPU)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>4096 (4 vCPU)</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of CPU units used by the task.Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>256 (.25 vCPU)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>512 (.5 vCPU)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>1024 (1 vCPU)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>2048 (2 vCPU)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>4096 (4 vCPU)</code>
     *         </p>
     *         </li>
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the
     * container user.
     * </p>
     * 
     * @return The ARN of the task execution role that grants the container agent permission to make API calls on behalf
     *         of the container user.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The name of a family that this task definition is registered to.
     * </p>
     * 
     * @return The name of a family that this task definition is registered to.
     */
    public final String family() {
        return family;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceAccelerators property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceAccelerators() {
        return inferenceAccelerators != null && !(inferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Inference accelerators to use for the containers in the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceAccelerators} method.
     * </p>
     * 
     * @return The Elastic Inference accelerators to use for the containers in the task.
     */
    public final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators() {
        return inferenceAccelerators;
    }

    /**
     * <p>
     * The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid values are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>host</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>task</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid
     *         values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>host</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>task</code>
     *         </p>
     *         </li>
     */
    public final String ipcMode() {
        return ipcMode;
    }

    /**
     * <p>
     * The amount (in MiB) of memory used by the task.
     * </p>
     * <p>
     * For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level memory
     * value. For tasks that are hosted on Fargate, you must use one of the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size"
     * >specified values</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>, which determines
     * your range of supported values for the <code>Cpu</code> and <code>Memory</code> parameters.
     * </p>
     * 
     * @return The amount (in MiB) of memory used by the task. </p>
     *         <p>
     *         For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level
     *         memory value. For tasks that are hosted on Fargate, you must use one of the <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size"
     *         >specified values</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>, which
     *         determines your range of supported values for the <code>Cpu</code> and <code>Memory</code> parameters.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The Docker networking mode to use for the containers in the task. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>awsvpc</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bridge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Docker networking mode to use for the containers in the task. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>awsvpc</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bridge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code>
     *         </p>
     *         </li>
     */
    public final String networkMode() {
        return networkMode;
    }

    /**
     * <p>
     * The process namespace to use for the containers in the task. Valid values are <code>host</code> or
     * <code>task</code>.
     * </p>
     * 
     * @return The process namespace to use for the containers in the task. Valid values are <code>host</code> or
     *         <code>task</code>.
     */
    public final String pidMode() {
        return pidMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The placement constraint objects to use for tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return The placement constraint objects to use for tasks.
     */
    public final List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints() {
        return placementConstraints;
    }

    /**
     * <p>
     * The configuration details for the App Mesh proxy.
     * </p>
     * 
     * @return The configuration details for the App Mesh proxy.
     */
    public final AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration() {
        return proxyConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiresCompatibilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequiresCompatibilities() {
        return requiresCompatibilities != null && !(requiresCompatibilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task launch types that the task definition was validated against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiresCompatibilities} method.
     * </p>
     * 
     * @return The task launch types that the task definition was validated against.
     */
    public final List<String> requiresCompatibilities() {
        return requiresCompatibilities;
    }

    /**
     * <p>
     * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services
     * API operations on your behalf.
     * </p>
     * 
     * @return The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web
     *         Services API operations on your behalf.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data volume definitions for the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return The data volume definitions for the task.
     */
    public final List<AwsEcsTaskDefinitionVolumesDetails> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerDefinitions() ? containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceAccelerators() ? inferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipcMode());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(networkMode());
        hashCode = 31 * hashCode + Objects.hashCode(pidMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiresCompatibilities() ? requiresCompatibilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionDetails other = (AwsEcsTaskDefinitionDetails) obj;
        return hasContainerDefinitions() == other.hasContainerDefinitions()
                && Objects.equals(containerDefinitions(), other.containerDefinitions()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(family(), other.family())
                && hasInferenceAccelerators() == other.hasInferenceAccelerators()
                && Objects.equals(inferenceAccelerators(), other.inferenceAccelerators())
                && Objects.equals(ipcMode(), other.ipcMode()) && Objects.equals(memory(), other.memory())
                && Objects.equals(networkMode(), other.networkMode()) && Objects.equals(pidMode(), other.pidMode())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && Objects.equals(proxyConfiguration(), other.proxyConfiguration())
                && hasRequiresCompatibilities() == other.hasRequiresCompatibilities()
                && Objects.equals(requiresCompatibilities(), other.requiresCompatibilities())
                && Objects.equals(taskRoleArn(), other.taskRoleArn()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionDetails")
                .add("ContainerDefinitions", hasContainerDefinitions() ? containerDefinitions() : null).add("Cpu", cpu())
                .add("ExecutionRoleArn", executionRoleArn()).add("Family", family())
                .add("InferenceAccelerators", hasInferenceAccelerators() ? inferenceAccelerators() : null)
                .add("IpcMode", ipcMode()).add("Memory", memory()).add("NetworkMode", networkMode()).add("PidMode", pidMode())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("ProxyConfiguration", proxyConfiguration())
                .add("RequiresCompatibilities", hasRequiresCompatibilities() ? requiresCompatibilities() : null)
                .add("TaskRoleArn", taskRoleArn()).add("Volumes", hasVolumes() ? volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerDefinitions":
            return Optional.ofNullable(clazz.cast(containerDefinitions()));
        case "Cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "InferenceAccelerators":
            return Optional.ofNullable(clazz.cast(inferenceAccelerators()));
        case "IpcMode":
            return Optional.ofNullable(clazz.cast(ipcMode()));
        case "Memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "NetworkMode":
            return Optional.ofNullable(clazz.cast(networkMode()));
        case "PidMode":
            return Optional.ofNullable(clazz.cast(pidMode()));
        case "PlacementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "ProxyConfiguration":
            return Optional.ofNullable(clazz.cast(proxyConfiguration()));
        case "RequiresCompatibilities":
            return Optional.ofNullable(clazz.cast(requiresCompatibilities()));
        case "TaskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "Volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionDetails> {
        /**
         * <p>
         * The container definitions that describe the containers that make up the task.
         * </p>
         * 
         * @param containerDefinitions
         *        The container definitions that describe the containers that make up the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions);

        /**
         * <p>
         * The container definitions that describe the containers that make up the task.
         * </p>
         * 
         * @param containerDefinitions
         *        The container definitions that describe the containers that make up the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDefinitions(AwsEcsTaskDefinitionContainerDefinitionsDetails... containerDefinitions);

        /**
         * <p>
         * The container definitions that describe the containers that make up the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #containerDefinitions(List<AwsEcsTaskDefinitionContainerDefinitionsDetails>)}.
         * 
         * @param containerDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDefinitions(java.util.Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails>)
         */
        Builder containerDefinitions(Consumer<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder>... containerDefinitions);

        /**
         * <p>
         * The number of CPU units used by the task.Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>256 (.25 vCPU)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>512 (.5 vCPU)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>1024 (1 vCPU)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>2048 (2 vCPU)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>4096 (4 vCPU)</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpu
         *        The number of CPU units used by the task.Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>256 (.25 vCPU)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>512 (.5 vCPU)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>1024 (1 vCPU)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>2048 (2 vCPU)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>4096 (4 vCPU)</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of
         * the container user.
         * </p>
         * 
         * @param executionRoleArn
         *        The ARN of the task execution role that grants the container agent permission to make API calls on
         *        behalf of the container user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The name of a family that this task definition is registered to.
         * </p>
         * 
         * @param family
         *        The name of a family that this task definition is registered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerators to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerators to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(AwsEcsTaskDefinitionInferenceAcceleratorsDetails... inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerators to use for the containers in the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #inferenceAccelerators(List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>)}.
         * 
         * @param inferenceAccelerators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceAccelerators(java.util.Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>)
         */
        Builder inferenceAccelerators(Consumer<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder>... inferenceAccelerators);

        /**
         * <p>
         * The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid values
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>host</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipcMode
         *        The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid
         *        values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>host</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>task</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipcMode(String ipcMode);

        /**
         * <p>
         * The amount (in MiB) of memory used by the task.
         * </p>
         * <p>
         * For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level
         * memory value. For tasks that are hosted on Fargate, you must use one of the <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size"
         * >specified values</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>, which
         * determines your range of supported values for the <code>Cpu</code> and <code>Memory</code> parameters.
         * </p>
         * 
         * @param memory
         *        The amount (in MiB) of memory used by the task. </p>
         *        <p>
         *        For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a
         *        container-level memory value. For tasks that are hosted on Fargate, you must use one of the <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size"
         *        >specified values</a> in the <i> <i>Amazon Elastic Container Service Developer Guide</i> </i>, which
         *        determines your range of supported values for the <code>Cpu</code> and <code>Memory</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The Docker networking mode to use for the containers in the task. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>awsvpc</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bridge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param networkMode
         *        The Docker networking mode to use for the containers in the task. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>awsvpc</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bridge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkMode(String networkMode);

        /**
         * <p>
         * The process namespace to use for the containers in the task. Valid values are <code>host</code> or
         * <code>task</code>.
         * </p>
         * 
         * @param pidMode
         *        The process namespace to use for the containers in the task. Valid values are <code>host</code> or
         *        <code>task</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pidMode(String pidMode);

        /**
         * <p>
         * The placement constraint objects to use for tasks.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraint objects to use for tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints);

        /**
         * <p>
         * The placement constraint objects to use for tasks.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraint objects to use for tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(AwsEcsTaskDefinitionPlacementConstraintsDetails... placementConstraints);

        /**
         * <p>
         * The placement constraint objects to use for tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #placementConstraints(List<AwsEcsTaskDefinitionPlacementConstraintsDetails>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails>)
         */
        Builder placementConstraints(Consumer<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder>... placementConstraints);

        /**
         * <p>
         * The configuration details for the App Mesh proxy.
         * </p>
         * 
         * @param proxyConfiguration
         *        The configuration details for the App Mesh proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration);

        /**
         * <p>
         * The configuration details for the App Mesh proxy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsTaskDefinitionProxyConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEcsTaskDefinitionProxyConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsTaskDefinitionProxyConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails)}.
         * 
         * @param proxyConfiguration
         *        a consumer that will call methods on {@link AwsEcsTaskDefinitionProxyConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails)
         */
        default Builder proxyConfiguration(Consumer<AwsEcsTaskDefinitionProxyConfigurationDetails.Builder> proxyConfiguration) {
            return proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails.builder().applyMutation(proxyConfiguration)
                    .build());
        }

        /**
         * <p>
         * The task launch types that the task definition was validated against.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch types that the task definition was validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilities(Collection<String> requiresCompatibilities);

        /**
         * <p>
         * The task launch types that the task definition was validated against.
         * </p>
         * 
         * @param requiresCompatibilities
         *        The task launch types that the task definition was validated against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresCompatibilities(String... requiresCompatibilities);

        /**
         * <p>
         * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web
         * Services API operations on your behalf.
         * </p>
         * 
         * @param taskRoleArn
         *        The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web
         *        Services API operations on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The data volume definitions for the task.
         * </p>
         * 
         * @param volumes
         *        The data volume definitions for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<AwsEcsTaskDefinitionVolumesDetails> volumes);

        /**
         * <p>
         * The data volume definitions for the task.
         * </p>
         * 
         * @param volumes
         *        The data volume definitions for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(AwsEcsTaskDefinitionVolumesDetails... volumes);

        /**
         * <p>
         * The data volume definitions for the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link #volumes(List<AwsEcsTaskDefinitionVolumesDetails>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<AwsEcsTaskDefinitionVolumesDetails>)
         */
        Builder volumes(Consumer<AwsEcsTaskDefinitionVolumesDetails.Builder>... volumes);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions = DefaultSdkAutoConstructList
                .getInstance();

        private String cpu;

        private String executionRoleArn;

        private String family;

        private List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators = DefaultSdkAutoConstructList
                .getInstance();

        private String ipcMode;

        private String memory;

        private String networkMode;

        private String pidMode;

        private List<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration;

        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();

        private String taskRoleArn;

        private List<AwsEcsTaskDefinitionVolumesDetails> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionDetails model) {
            containerDefinitions(model.containerDefinitions);
            cpu(model.cpu);
            executionRoleArn(model.executionRoleArn);
            family(model.family);
            inferenceAccelerators(model.inferenceAccelerators);
            ipcMode(model.ipcMode);
            memory(model.memory);
            networkMode(model.networkMode);
            pidMode(model.pidMode);
            placementConstraints(model.placementConstraints);
            proxyConfiguration(model.proxyConfiguration);
            requiresCompatibilities(model.requiresCompatibilities);
            taskRoleArn(model.taskRoleArn);
            volumes(model.volumes);
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> getContainerDefinitions() {
            List<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsListCopier
                    .copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = AwsEcsTaskDefinitionContainerDefinitionsListCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<AwsEcsTaskDefinitionContainerDefinitionsDetails> containerDefinitions) {
            this.containerDefinitions = AwsEcsTaskDefinitionContainerDefinitionsListCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(AwsEcsTaskDefinitionContainerDefinitionsDetails... containerDefinitions) {
            containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder>... containerDefinitions) {
            containerDefinitions(Stream.of(containerDefinitions)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getFamily() {
            return family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> getInferenceAccelerators() {
            List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> result = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier
                    .copyToBuilder(this.inferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAccelerators(
                Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier
                    .copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public final Builder inferenceAccelerators(
                Collection<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> inferenceAccelerators) {
            this.inferenceAccelerators = AwsEcsTaskDefinitionInferenceAcceleratorsListCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(AwsEcsTaskDefinitionInferenceAcceleratorsDetails... inferenceAccelerators) {
            inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(
                Consumer<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder>... inferenceAccelerators) {
            inferenceAccelerators(Stream.of(inferenceAccelerators)
                    .map(c -> AwsEcsTaskDefinitionInferenceAcceleratorsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIpcMode() {
            return ipcMode;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getNetworkMode() {
            return networkMode;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public final String getPidMode() {
            return pidMode;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        public final List<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> getPlacementConstraints() {
            List<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder> result = AwsEcsTaskDefinitionPlacementConstraintsListCopier
                    .copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(
                Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails.BuilderImpl> placementConstraints) {
            this.placementConstraints = AwsEcsTaskDefinitionPlacementConstraintsListCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<AwsEcsTaskDefinitionPlacementConstraintsDetails> placementConstraints) {
            this.placementConstraints = AwsEcsTaskDefinitionPlacementConstraintsListCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(AwsEcsTaskDefinitionPlacementConstraintsDetails... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(
                Consumer<AwsEcsTaskDefinitionPlacementConstraintsDetails.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints)
                    .map(c -> AwsEcsTaskDefinitionPlacementConstraintsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsTaskDefinitionProxyConfigurationDetails.Builder getProxyConfiguration() {
            return proxyConfiguration != null ? proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(AwsEcsTaskDefinitionProxyConfigurationDetails proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final Collection<String> getRequiresCompatibilities() {
            if (requiresCompatibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return requiresCompatibilities;
        }

        public final void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = NonEmptyStringListCopier.copy(requiresCompatibilities);
        }

        @Override
        public final Builder requiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = NonEmptyStringListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(String... requiresCompatibilities) {
            requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final List<AwsEcsTaskDefinitionVolumesDetails.Builder> getVolumes() {
            List<AwsEcsTaskDefinitionVolumesDetails.Builder> result = AwsEcsTaskDefinitionVolumesListCopier
                    .copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<AwsEcsTaskDefinitionVolumesDetails.BuilderImpl> volumes) {
            this.volumes = AwsEcsTaskDefinitionVolumesListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<AwsEcsTaskDefinitionVolumesDetails> volumes) {
            this.volumes = AwsEcsTaskDefinitionVolumesListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(AwsEcsTaskDefinitionVolumesDetails... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<AwsEcsTaskDefinitionVolumesDetails.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> AwsEcsTaskDefinitionVolumesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionDetails build() {
            return new AwsEcsTaskDefinitionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
