/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOrganizationConfigurationRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateOrganizationConfigurationRequest.Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(UpdateOrganizationConfigurationRequest::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnable").build()).build();

    private static final SdkField<String> AUTO_ENABLE_STANDARDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEnableStandards")
            .getter(getter(UpdateOrganizationConfigurationRequest::autoEnableStandardsAsString))
            .setter(setter(Builder::autoEnableStandards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableStandards").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD,
            AUTO_ENABLE_STANDARDS_FIELD));

    private final Boolean autoEnable;

    private final String autoEnableStandards;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.autoEnableStandards = builder.autoEnableStandards;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * By default, this is <code>false</code>, and new accounts are not added automatically.
     * </p>
     * <p>
     * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *         <p>
     *         By default, this is <code>false</code>, and new accounts are not added automatically.
     *         </p>
     *         <p>
     *         To automatically enable Security Hub for new accounts, set this to <code>true</code>.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableStandards} will return {@link AutoEnableStandards#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableStandardsAsString}.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *         >default standards</a> for new member accounts in the organization.</p>
     *         <p>
     *         By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *         enabled with default Security Hub standards.
     *         </p>
     *         <p>
     *         To opt out of enabling default standards for new member accounts, set this parameter equal to
     *         <code>NONE</code>.
     * @see AutoEnableStandards
     */
    public final AutoEnableStandards autoEnableStandards() {
        return AutoEnableStandards.fromValue(autoEnableStandards);
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html">default
     * standards</a> for new member accounts in the organization.
     * </p>
     * <p>
     * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically enabled
     * with default Security Hub standards.
     * </p>
     * <p>
     * To opt out of enabling default standards for new member accounts, set this parameter equal to <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableStandards} will return {@link AutoEnableStandards#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableStandardsAsString}.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub <a
     *         href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
     *         >default standards</a> for new member accounts in the organization.</p>
     *         <p>
     *         By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
     *         enabled with default Security Hub standards.
     *         </p>
     *         <p>
     *         To opt out of enabling default standards for new member accounts, set this parameter equal to
     *         <code>NONE</code>.
     * @see AutoEnableStandards
     */
    public final String autoEnableStandardsAsString() {
        return autoEnableStandards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableStandardsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest) obj;
        return Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(autoEnableStandardsAsString(), other.autoEnableStandardsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOrganizationConfigurationRequest").add("AutoEnable", autoEnable())
                .add("AutoEnableStandards", autoEnableStandardsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "AutoEnableStandards":
            return Optional.ofNullable(clazz.cast(autoEnableStandardsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        /**
         * <p>
         * Whether to automatically enable Security Hub for new accounts in the organization.
         * </p>
         * <p>
         * By default, this is <code>false</code>, and new accounts are not added automatically.
         * </p>
         * <p>
         * To automatically enable Security Hub for new accounts, set this to <code>true</code>.
         * </p>
         * 
         * @param autoEnable
         *        Whether to automatically enable Security Hub for new accounts in the organization.</p>
         *        <p>
         *        By default, this is <code>false</code>, and new accounts are not added automatically.
         *        </p>
         *        <p>
         *        To automatically enable Security Hub for new accounts, set this to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Whether to automatically enable Security Hub <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
         * >default standards</a> for new member accounts in the organization.
         * </p>
         * <p>
         * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
         * enabled with default Security Hub standards.
         * </p>
         * <p>
         * To opt out of enabling default standards for new member accounts, set this parameter equal to
         * <code>NONE</code>.
         * </p>
         * 
         * @param autoEnableStandards
         *        Whether to automatically enable Security Hub <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
         *        >default standards</a> for new member accounts in the organization.</p>
         *        <p>
         *        By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
         *        enabled with default Security Hub standards.
         *        </p>
         *        <p>
         *        To opt out of enabling default standards for new member accounts, set this parameter equal to
         *        <code>NONE</code>.
         * @see AutoEnableStandards
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableStandards
         */
        Builder autoEnableStandards(String autoEnableStandards);

        /**
         * <p>
         * Whether to automatically enable Security Hub <a
         * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
         * >default standards</a> for new member accounts in the organization.
         * </p>
         * <p>
         * By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
         * enabled with default Security Hub standards.
         * </p>
         * <p>
         * To opt out of enabling default standards for new member accounts, set this parameter equal to
         * <code>NONE</code>.
         * </p>
         * 
         * @param autoEnableStandards
         *        Whether to automatically enable Security Hub <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html"
         *        >default standards</a> for new member accounts in the organization.</p>
         *        <p>
         *        By default, this parameter is equal to <code>DEFAULT</code>, and new member accounts are automatically
         *        enabled with default Security Hub standards.
         *        </p>
         *        <p>
         *        To opt out of enabling default standards for new member accounts, set this parameter equal to
         *        <code>NONE</code>.
         * @see AutoEnableStandards
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableStandards
         */
        Builder autoEnableStandards(AutoEnableStandards autoEnableStandards);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private Boolean autoEnable;

        private String autoEnableStandards;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            autoEnable(model.autoEnable);
            autoEnableStandards(model.autoEnableStandards);
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final String getAutoEnableStandards() {
            return autoEnableStandards;
        }

        public final void setAutoEnableStandards(String autoEnableStandards) {
            this.autoEnableStandards = autoEnableStandards;
        }

        @Override
        public final Builder autoEnableStandards(String autoEnableStandards) {
            this.autoEnableStandards = autoEnableStandards;
            return this;
        }

        @Override
        public final Builder autoEnableStandards(AutoEnableStandards autoEnableStandards) {
            this.autoEnableStandards(autoEnableStandards == null ? null : autoEnableStandards.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
