/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a version 2 stage for Amazon API Gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayV2StageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayV2StageDetails.Builder, AwsApiGatewayV2StageDetails> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCertificateId").getter(getter(AwsApiGatewayV2StageDetails::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateId").build())
            .build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(AwsApiGatewayV2StageDetails::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsApiGatewayV2StageDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AwsApiGatewayV2RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField
            .<AwsApiGatewayV2RouteSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultRouteSettings")
            .getter(getter(AwsApiGatewayV2StageDetails::defaultRouteSettings)).setter(setter(Builder::defaultRouteSettings))
            .constructor(AwsApiGatewayV2RouteSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteSettings").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(AwsApiGatewayV2StageDetails::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedDate").getter(getter(AwsApiGatewayV2StageDetails::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<AwsApiGatewayV2RouteSettings> ROUTE_SETTINGS_FIELD = SdkField
            .<AwsApiGatewayV2RouteSettings> builder(MarshallingType.SDK_POJO).memberName("RouteSettings")
            .getter(getter(AwsApiGatewayV2StageDetails::routeSettings)).setter(setter(Builder::routeSettings))
            .constructor(AwsApiGatewayV2RouteSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSettings").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(AwsApiGatewayV2StageDetails::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StageVariables")
            .getter(getter(AwsApiGatewayV2StageDetails::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AwsApiGatewayAccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AwsApiGatewayAccessLogSettings> builder(MarshallingType.SDK_POJO).memberName("AccessLogSettings")
            .getter(getter(AwsApiGatewayV2StageDetails::accessLogSettings)).setter(setter(Builder::accessLogSettings))
            .constructor(AwsApiGatewayAccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogSettings").build()).build();

    private static final SdkField<Boolean> AUTO_DEPLOY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeploy").getter(getter(AwsApiGatewayV2StageDetails::autoDeploy)).setter(setter(Builder::autoDeploy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeploy").build()).build();

    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastDeploymentStatusMessage")
            .getter(getter(AwsApiGatewayV2StageDetails::lastDeploymentStatusMessage))
            .setter(setter(Builder::lastDeploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentStatusMessage")
                    .build()).build();

    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApiGatewayManaged").getter(getter(AwsApiGatewayV2StageDetails::apiGatewayManaged))
            .setter(setter(Builder::apiGatewayManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayManaged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD,
            CREATED_DATE_FIELD, DESCRIPTION_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD, LAST_UPDATED_DATE_FIELD,
            ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD, ACCESS_LOG_SETTINGS_FIELD, AUTO_DEPLOY_FIELD,
            LAST_DEPLOYMENT_STATUS_MESSAGE_FIELD, API_GATEWAY_MANAGED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientCertificateId;

    private final String createdDate;

    private final String description;

    private final AwsApiGatewayV2RouteSettings defaultRouteSettings;

    private final String deploymentId;

    private final String lastUpdatedDate;

    private final AwsApiGatewayV2RouteSettings routeSettings;

    private final String stageName;

    private final Map<String, String> stageVariables;

    private final AwsApiGatewayAccessLogSettings accessLogSettings;

    private final Boolean autoDeploy;

    private final String lastDeploymentStatusMessage;

    private final Boolean apiGatewayManaged;

    private AwsApiGatewayV2StageDetails(BuilderImpl builder) {
        this.clientCertificateId = builder.clientCertificateId;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
        this.accessLogSettings = builder.accessLogSettings;
        this.autoDeploy = builder.autoDeploy;
        this.lastDeploymentStatusMessage = builder.lastDeploymentStatusMessage;
        this.apiGatewayManaged = builder.apiGatewayManaged;
    }

    /**
     * <p>
     * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
     * </p>
     * 
     * @return The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * Indicates when the stage was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the stage was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the stage.
     * </p>
     * 
     * @return The description of the stage.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Default route settings for the stage.
     * </p>
     * 
     * @return Default route settings for the stage.
     */
    public final AwsApiGatewayV2RouteSettings defaultRouteSettings() {
        return defaultRouteSettings;
    }

    /**
     * <p>
     * The identifier of the deployment that the stage is associated with.
     * </p>
     * 
     * @return The identifier of the deployment that the stage is associated with.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Indicates when the stage was most recently updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the stage was most recently updated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The route settings for the stage.
     * </p>
     * 
     * @return The route settings for the stage.
     */
    public final AwsApiGatewayV2RouteSettings routeSettings() {
        return routeSettings;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StageVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStageVariables() {
        return stageVariables != null && !(stageVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for the stage.
     * </p>
     * <p>
     * Variable names can have alphanumeric and underscore characters.
     * </p>
     * <p>
     * Variable values can contain the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Uppercase and lowercase letters
     * </p>
     * </li>
     * <li>
     * <p>
     * Numbers
     * </p>
     * </li>
     * <li>
     * <p>
     * Special characters -._~:/?#&amp;=,
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStageVariables} method.
     * </p>
     * 
     * @return A map that defines the stage variables for the stage.</p>
     *         <p>
     *         Variable names can have alphanumeric and underscore characters.
     *         </p>
     *         <p>
     *         Variable values can contain the following characters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Uppercase and lowercase letters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Numbers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Special characters -._~:/?#&amp;=,
     *         </p>
     *         </li>
     */
    public final Map<String, String> stageVariables() {
        return stageVariables;
    }

    /**
     * <p>
     * Information about settings for logging access for the stage.
     * </p>
     * 
     * @return Information about settings for logging access for the stage.
     */
    public final AwsApiGatewayAccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * Indicates whether updates to an API automatically trigger a new deployment.
     * </p>
     * 
     * @return Indicates whether updates to an API automatically trigger a new deployment.
     */
    public final Boolean autoDeploy() {
        return autoDeploy;
    }

    /**
     * <p>
     * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
     * </p>
     * 
     * @return The status of the last deployment of a stage. Supported only if the stage has automatic deployment
     *         enabled.
     */
    public final String lastDeploymentStatusMessage() {
        return lastDeploymentStatusMessage;
    }

    /**
     * <p>
     * Indicates whether the stage is managed by API Gateway.
     * </p>
     * 
     * @return Indicates whether the stage is managed by API Gateway.
     */
    public final Boolean apiGatewayManaged() {
        return apiGatewayManaged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(routeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageVariables() ? stageVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeploy());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayManaged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayV2StageDetails)) {
            return false;
        }
        AwsApiGatewayV2StageDetails other = (AwsApiGatewayV2StageDetails) obj;
        return Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultRouteSettings(), other.defaultRouteSettings())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(routeSettings(), other.routeSettings()) && Objects.equals(stageName(), other.stageName())
                && hasStageVariables() == other.hasStageVariables() && Objects.equals(stageVariables(), other.stageVariables())
                && Objects.equals(accessLogSettings(), other.accessLogSettings())
                && Objects.equals(autoDeploy(), other.autoDeploy())
                && Objects.equals(lastDeploymentStatusMessage(), other.lastDeploymentStatusMessage())
                && Objects.equals(apiGatewayManaged(), other.apiGatewayManaged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayV2StageDetails").add("ClientCertificateId", clientCertificateId())
                .add("CreatedDate", createdDate()).add("Description", description())
                .add("DefaultRouteSettings", defaultRouteSettings()).add("DeploymentId", deploymentId())
                .add("LastUpdatedDate", lastUpdatedDate()).add("RouteSettings", routeSettings()).add("StageName", stageName())
                .add("StageVariables", hasStageVariables() ? stageVariables() : null)
                .add("AccessLogSettings", accessLogSettings()).add("AutoDeploy", autoDeploy())
                .add("LastDeploymentStatusMessage", lastDeploymentStatusMessage()).add("ApiGatewayManaged", apiGatewayManaged())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultRouteSettings":
            return Optional.ofNullable(clazz.cast(defaultRouteSettings()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "RouteSettings":
            return Optional.ofNullable(clazz.cast(routeSettings()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "StageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        case "AccessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "AutoDeploy":
            return Optional.ofNullable(clazz.cast(autoDeploy()));
        case "LastDeploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(lastDeploymentStatusMessage()));
        case "ApiGatewayManaged":
            return Optional.ofNullable(clazz.cast(apiGatewayManaged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayV2StageDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayV2StageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayV2StageDetails> {
        /**
         * <p>
         * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * Indicates when the stage was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdDate
         *        Indicates when the stage was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The description of the stage.
         * </p>
         * 
         * @param description
         *        The description of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Default route settings for the stage.
         * </p>
         * 
         * @param defaultRouteSettings
         *        Default route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteSettings(AwsApiGatewayV2RouteSettings defaultRouteSettings);

        /**
         * <p>
         * Default route settings for the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayV2RouteSettings.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayV2RouteSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayV2RouteSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultRouteSettings(AwsApiGatewayV2RouteSettings)}.
         * 
         * @param defaultRouteSettings
         *        a consumer that will call methods on {@link AwsApiGatewayV2RouteSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRouteSettings(AwsApiGatewayV2RouteSettings)
         */
        default Builder defaultRouteSettings(Consumer<AwsApiGatewayV2RouteSettings.Builder> defaultRouteSettings) {
            return defaultRouteSettings(AwsApiGatewayV2RouteSettings.builder().applyMutation(defaultRouteSettings).build());
        }

        /**
         * <p>
         * The identifier of the deployment that the stage is associated with.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the deployment that the stage is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Indicates when the stage was most recently updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastUpdatedDate
         *        Indicates when the stage was most recently updated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(String lastUpdatedDate);

        /**
         * <p>
         * The route settings for the stage.
         * </p>
         * 
         * @param routeSettings
         *        The route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSettings(AwsApiGatewayV2RouteSettings routeSettings);

        /**
         * <p>
         * The route settings for the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayV2RouteSettings.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayV2RouteSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayV2RouteSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #routeSettings(AwsApiGatewayV2RouteSettings)}.
         * 
         * @param routeSettings
         *        a consumer that will call methods on {@link AwsApiGatewayV2RouteSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeSettings(AwsApiGatewayV2RouteSettings)
         */
        default Builder routeSettings(Consumer<AwsApiGatewayV2RouteSettings.Builder> routeSettings) {
            return routeSettings(AwsApiGatewayV2RouteSettings.builder().applyMutation(routeSettings).build());
        }

        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A map that defines the stage variables for the stage.
         * </p>
         * <p>
         * Variable names can have alphanumeric and underscore characters.
         * </p>
         * <p>
         * Variable values can contain the following characters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Uppercase and lowercase letters
         * </p>
         * </li>
         * <li>
         * <p>
         * Numbers
         * </p>
         * </li>
         * <li>
         * <p>
         * Special characters -._~:/?#&amp;=,
         * </p>
         * </li>
         * </ul>
         * 
         * @param stageVariables
         *        A map that defines the stage variables for the stage.</p>
         *        <p>
         *        Variable names can have alphanumeric and underscore characters.
         *        </p>
         *        <p>
         *        Variable values can contain the following characters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Uppercase and lowercase letters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Numbers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Special characters -._~:/?#&amp;=,
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        /**
         * <p>
         * Information about settings for logging access for the stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Information about settings for logging access for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings);

        /**
         * <p>
         * Information about settings for logging access for the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsApiGatewayAccessLogSettings.Builder}
         * avoiding the need to create one manually via {@link AwsApiGatewayAccessLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsApiGatewayAccessLogSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #accessLogSettings(AwsApiGatewayAccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AwsApiGatewayAccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AwsApiGatewayAccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AwsApiGatewayAccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AwsApiGatewayAccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * Indicates whether updates to an API automatically trigger a new deployment.
         * </p>
         * 
         * @param autoDeploy
         *        Indicates whether updates to an API automatically trigger a new deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeploy(Boolean autoDeploy);

        /**
         * <p>
         * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
         * </p>
         * 
         * @param lastDeploymentStatusMessage
         *        The status of the last deployment of a stage. Supported only if the stage has automatic deployment
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentStatusMessage(String lastDeploymentStatusMessage);

        /**
         * <p>
         * Indicates whether the stage is managed by API Gateway.
         * </p>
         * 
         * @param apiGatewayManaged
         *        Indicates whether the stage is managed by API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayManaged(Boolean apiGatewayManaged);
    }

    static final class BuilderImpl implements Builder {
        private String clientCertificateId;

        private String createdDate;

        private String description;

        private AwsApiGatewayV2RouteSettings defaultRouteSettings;

        private String deploymentId;

        private String lastUpdatedDate;

        private AwsApiGatewayV2RouteSettings routeSettings;

        private String stageName;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private AwsApiGatewayAccessLogSettings accessLogSettings;

        private Boolean autoDeploy;

        private String lastDeploymentStatusMessage;

        private Boolean apiGatewayManaged;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayV2StageDetails model) {
            clientCertificateId(model.clientCertificateId);
            createdDate(model.createdDate);
            description(model.description);
            defaultRouteSettings(model.defaultRouteSettings);
            deploymentId(model.deploymentId);
            lastUpdatedDate(model.lastUpdatedDate);
            routeSettings(model.routeSettings);
            stageName(model.stageName);
            stageVariables(model.stageVariables);
            accessLogSettings(model.accessLogSettings);
            autoDeploy(model.autoDeploy);
            lastDeploymentStatusMessage(model.lastDeploymentStatusMessage);
            apiGatewayManaged(model.apiGatewayManaged);
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AwsApiGatewayV2RouteSettings.Builder getDefaultRouteSettings() {
            return defaultRouteSettings != null ? defaultRouteSettings.toBuilder() : null;
        }

        public final void setDefaultRouteSettings(AwsApiGatewayV2RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        @Override
        public final Builder defaultRouteSettings(AwsApiGatewayV2RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final AwsApiGatewayV2RouteSettings.Builder getRouteSettings() {
            return routeSettings != null ? routeSettings.toBuilder() : null;
        }

        public final void setRouteSettings(AwsApiGatewayV2RouteSettings.BuilderImpl routeSettings) {
            this.routeSettings = routeSettings != null ? routeSettings.build() : null;
        }

        @Override
        public final Builder routeSettings(AwsApiGatewayV2RouteSettings routeSettings) {
            this.routeSettings = routeSettings;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = FieldMapCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = FieldMapCopier.copy(stageVariables);
            return this;
        }

        public final AwsApiGatewayAccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AwsApiGatewayAccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final Boolean getAutoDeploy() {
            return autoDeploy;
        }

        public final void setAutoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
        }

        @Override
        public final Builder autoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        public final String getLastDeploymentStatusMessage() {
            return lastDeploymentStatusMessage;
        }

        public final void setLastDeploymentStatusMessage(String lastDeploymentStatusMessage) {
            this.lastDeploymentStatusMessage = lastDeploymentStatusMessage;
        }

        @Override
        public final Builder lastDeploymentStatusMessage(String lastDeploymentStatusMessage) {
            this.lastDeploymentStatusMessage = lastDeploymentStatusMessage;
            return this;
        }

        public final Boolean getApiGatewayManaged() {
            return apiGatewayManaged;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        @Override
        public AwsApiGatewayV2StageDetails build() {
            return new AwsApiGatewayV2StageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
