/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a launch configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingLaunchConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAutoScalingLaunchConfigurationDetails.Builder, AwsAutoScalingLaunchConfigurationDetails> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClassicLinkVpcId").getter(getter(AwsAutoScalingLaunchConfigurationDetails::classicLinkVpcId))
            .setter(setter(Builder::classicLinkVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVpcId").build()).build();

    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClassicLinkVpcSecurityGroups")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::classicLinkVpcSecurityGroups))
            .setter(setter(Builder::classicLinkVpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVpcSecurityGroups")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(AwsAutoScalingLaunchConfigurationDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(AwsAutoScalingLaunchConfigurationDetails::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamInstanceProfile").getter(getter(AwsAutoScalingLaunchConfigurationDetails::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(AwsAutoScalingLaunchConfigurationDetails::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails> INSTANCE_MONITORING_FIELD = SdkField
            .<AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMonitoring").getter(getter(AwsAutoScalingLaunchConfigurationDetails::instanceMonitoring))
            .setter(setter(Builder::instanceMonitoring))
            .constructor(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AwsAutoScalingLaunchConfigurationDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KernelId").getter(getter(AwsAutoScalingLaunchConfigurationDetails::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(AwsAutoScalingLaunchConfigurationDetails::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementTenancy").getter(getter(AwsAutoScalingLaunchConfigurationDetails::placementTenancy))
            .setter(setter(Builder::placementTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId").getter(getter(AwsAutoScalingLaunchConfigurationDetails::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpotPrice").getter(getter(AwsAutoScalingLaunchConfigurationDetails::spotPrice))
            .setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserData").getter(getter(AwsAutoScalingLaunchConfigurationDetails::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()).build();

    private static final SdkField<AwsAutoScalingLaunchConfigurationMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<AwsAutoScalingLaunchConfigurationMetadataOptions> builder(MarshallingType.SDK_POJO).memberName("MetadataOptions")
            .getter(getter(AwsAutoScalingLaunchConfigurationDetails::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(AwsAutoScalingLaunchConfigurationMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, CLASSIC_LINK_VPC_ID_FIELD,
            CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, CREATED_TIME_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD,
            IMAGE_ID_FIELD, INSTANCE_MONITORING_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD,
            LAUNCH_CONFIGURATION_NAME_FIELD, PLACEMENT_TENANCY_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUPS_FIELD, SPOT_PRICE_FIELD,
            USER_DATA_FIELD, METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean associatePublicIpAddress;

    private final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings;

    private final String classicLinkVpcId;

    private final List<String> classicLinkVpcSecurityGroups;

    private final String createdTime;

    private final Boolean ebsOptimized;

    private final String iamInstanceProfile;

    private final String imageId;

    private final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final String launchConfigurationName;

    private final String placementTenancy;

    private final String ramdiskId;

    private final List<String> securityGroups;

    private final String spotPrice;

    private final String userData;

    private final AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions;

    private AwsAutoScalingLaunchConfigurationDetails(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.classicLinkVpcId = builder.classicLinkVpcId;
        this.classicLinkVpcSecurityGroups = builder.classicLinkVpcSecurityGroups;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.placementTenancy = builder.placementTenancy;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroups = builder.securityGroups;
        this.spotPrice = builder.spotPrice;
        this.userData = builder.userData;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's
     * instances.
     * </p>
     * 
     * @return For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's
     *         instances.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the block devices for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Specifies the block devices for the instance.
     */
    public final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
     * </p>
     * 
     * @return The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
     */
    public final String classicLinkVpcId() {
        return classicLinkVpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClassicLinkVpcSecurityGroups property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClassicLinkVpcSecurityGroups() {
        return classicLinkVpcSecurityGroups != null && !(classicLinkVpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassicLinkVpcSecurityGroups} method.
     * </p>
     * 
     * @return The identifiers of one or more security groups for the VPC that is specified in
     *         <code>ClassicLinkVPCId</code>.
     */
    public final List<String> classicLinkVpcSecurityGroups() {
        return classicLinkVpcSecurityGroups;
    }

    /**
     * <p>
     * The creation date and time for the launch configuration.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The creation date and time for the launch configuration.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Whether the launch configuration is optimized for Amazon EBS I/O.
     * </p>
     * 
     * @return Whether the launch configuration is optimized for Amazon EBS I/O.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The name or the ARN of the instance profile associated with the IAM role for the instance. The instance profile
     * contains the IAM role.
     * </p>
     * 
     * @return The name or the ARN of the instance profile associated with the IAM role for the instance. The instance
     *         profile contains the IAM role.
     */
    public final String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
     * </p>
     * 
     * @return The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Indicates the type of monitoring for instances in the group.
     * </p>
     * 
     * @return Indicates the type of monitoring for instances in the group.
     */
    public final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The instance type for the instances.
     * </p>
     * 
     * @return The instance type for the instances.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The identifier of the kernel associated with the AMI.
     * </p>
     * 
     * @return The identifier of the kernel associated with the AMI.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant
     * hardware and can only be launched into a VPC.
     * </p>
     * 
     * @return The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated,
     *         single-tenant hardware and can only be launched into a VPC.
     */
    public final String placementTenancy() {
        return placementTenancy;
    }

    /**
     * <p>
     * The identifier of the RAM disk associated with the AMI.
     * </p>
     * 
     * @return The identifier of the RAM disk associated with the AMI.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups to assign to the instances in the Auto Scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups to assign to the instances in the Auto Scaling group.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
     * </p>
     * 
     * @return The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
     */
    public final String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The user data to make available to the launched EC2 instances. Must be base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the launched EC2 instances. Must be base64-encoded text.
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The metadata options for the instances.
     * </p>
     * 
     * @return The metadata options for the instances.
     */
    public final AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasClassicLinkVpcSecurityGroups() ? classicLinkVpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(placementTenancy());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationDetails)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationDetails other = (AwsAutoScalingLaunchConfigurationDetails) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(classicLinkVpcId(), other.classicLinkVpcId())
                && hasClassicLinkVpcSecurityGroups() == other.hasClassicLinkVpcSecurityGroups()
                && Objects.equals(classicLinkVpcSecurityGroups(), other.classicLinkVpcSecurityGroups())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceMonitoring(), other.instanceMonitoring())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(placementTenancy(), other.placementTenancy()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(spotPrice(), other.spotPrice()) && Objects.equals(userData(), other.userData())
                && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingLaunchConfigurationDetails")
                .add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("ClassicLinkVpcId", classicLinkVpcId())
                .add("ClassicLinkVpcSecurityGroups", hasClassicLinkVpcSecurityGroups() ? classicLinkVpcSecurityGroups() : null)
                .add("CreatedTime", createdTime()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceMonitoring", instanceMonitoring()).add("InstanceType", instanceType()).add("KernelId", kernelId())
                .add("KeyName", keyName()).add("LaunchConfigurationName", launchConfigurationName())
                .add("PlacementTenancy", placementTenancy()).add("RamdiskId", ramdiskId())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SpotPrice", spotPrice())
                .add("UserData", userData()).add("MetadataOptions", metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "ClassicLinkVpcId":
            return Optional.ofNullable(clazz.cast(classicLinkVpcId()));
        case "ClassicLinkVpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(classicLinkVpcSecurityGroups()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceMonitoring":
            return Optional.ofNullable(clazz.cast(instanceMonitoring()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "PlacementTenancy":
            return Optional.ofNullable(clazz.cast(placementTenancy()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationDetails> {
        /**
         * <p>
         * For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's
         * instances.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the
         *        group's instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Specifies the block devices for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Specifies the block devices for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings);

        /**
         * <p>
         * Specifies the block devices for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Specifies the block devices for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails... blockDeviceMappings);

        /**
         * <p>
         * Specifies the block devices for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>)
         */
        Builder blockDeviceMappings(
                Consumer<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
         * </p>
         * 
         * @param classicLinkVpcId
         *        The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVpcId(String classicLinkVpcId);

        /**
         * <p>
         * The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>
         * .
         * </p>
         * 
         * @param classicLinkVpcSecurityGroups
         *        The identifiers of one or more security groups for the VPC that is specified in
         *        <code>ClassicLinkVPCId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVpcSecurityGroups(Collection<String> classicLinkVpcSecurityGroups);

        /**
         * <p>
         * The identifiers of one or more security groups for the VPC that is specified in <code>ClassicLinkVPCId</code>
         * .
         * </p>
         * 
         * @param classicLinkVpcSecurityGroups
         *        The identifiers of one or more security groups for the VPC that is specified in
         *        <code>ClassicLinkVPCId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVpcSecurityGroups(String... classicLinkVpcSecurityGroups);

        /**
         * <p>
         * The creation date and time for the launch configuration.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdTime
         *        The creation date and time for the launch configuration.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * Whether the launch configuration is optimized for Amazon EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Whether the launch configuration is optimized for Amazon EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The name or the ARN of the instance profile associated with the IAM role for the instance. The instance
         * profile contains the IAM role.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or the ARN of the instance profile associated with the IAM role for the instance. The
         *        instance profile contains the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
         * </p>
         * 
         * @param imageId
         *        The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Indicates the type of monitoring for instances in the group.
         * </p>
         * 
         * @param instanceMonitoring
         *        Indicates the type of monitoring for instances in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring);

        /**
         * <p>
         * Indicates the type of monitoring for instances in the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder} avoiding the need to create one
         * manually via {@link AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)}.
         * 
         * @param instanceMonitoring
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)
         */
        default Builder instanceMonitoring(
                Consumer<AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder> instanceMonitoring) {
            return instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.builder()
                    .applyMutation(instanceMonitoring).build());
        }

        /**
         * <p>
         * The instance type for the instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The identifier of the kernel associated with the AMI.
         * </p>
         * 
         * @param kernelId
         *        The identifier of the kernel associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant
         * hardware and can only be launched into a VPC.
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated,
         *        single-tenant hardware and can only be launched into a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);

        /**
         * <p>
         * The identifier of the RAM disk associated with the AMI.
         * </p>
         * 
         * @param ramdiskId
         *        The identifier of the RAM disk associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The security groups to assign to the instances in the Auto Scaling group.
         * </p>
         * 
         * @param securityGroups
         *        The security groups to assign to the instances in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security groups to assign to the instances in the Auto Scaling group.
         * </p>
         * 
         * @param securityGroups
         *        The security groups to assign to the instances in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
         * </p>
         * 
         * @param spotPrice
         *        The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The user data to make available to the launched EC2 instances. Must be base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the launched EC2 instances. Must be base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The metadata options for the instances.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions);

        /**
         * <p>
         * The metadata options for the instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingLaunchConfigurationMetadataOptions.Builder} avoiding the need to create one manually via
         * {@link AwsAutoScalingLaunchConfigurationMetadataOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAutoScalingLaunchConfigurationMetadataOptions.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link AwsAutoScalingLaunchConfigurationMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions)
         */
        default Builder metadataOptions(Consumer<AwsAutoScalingLaunchConfigurationMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions.builder().applyMutation(metadataOptions)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings = DefaultSdkAutoConstructList
                .getInstance();

        private String classicLinkVpcId;

        private List<String> classicLinkVpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String createdTime;

        private Boolean ebsOptimized;

        private String iamInstanceProfile;

        private String imageId;

        private AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private String launchConfigurationName;

        private String placementTenancy;

        private String ramdiskId;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String spotPrice;

        private String userData;

        private AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationDetails model) {
            associatePublicIpAddress(model.associatePublicIpAddress);
            blockDeviceMappings(model.blockDeviceMappings);
            classicLinkVpcId(model.classicLinkVpcId);
            classicLinkVpcSecurityGroups(model.classicLinkVpcSecurityGroups);
            createdTime(model.createdTime);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceMonitoring(model.instanceMonitoring);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            launchConfigurationName(model.launchConfigurationName);
            placementTenancy(model.placementTenancy);
            ramdiskId(model.ramdiskId);
            securityGroups(model.securityGroups);
            spotPrice(model.spotPrice);
            userData(model.userData);
            metadataOptions(model.metadataOptions);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> getBlockDeviceMappings() {
            List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> result = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(
                Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier
                    .copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(
                Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings) {
            this.blockDeviceMappings = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(
                AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(
                Consumer<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClassicLinkVpcId() {
            return classicLinkVpcId;
        }

        public final void setClassicLinkVpcId(String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
        }

        @Override
        public final Builder classicLinkVpcId(String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
            return this;
        }

        public final Collection<String> getClassicLinkVpcSecurityGroups() {
            if (classicLinkVpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return classicLinkVpcSecurityGroups;
        }

        public final void setClassicLinkVpcSecurityGroups(Collection<String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = NonEmptyStringListCopier.copy(classicLinkVpcSecurityGroups);
        }

        @Override
        public final Builder classicLinkVpcSecurityGroups(Collection<String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = NonEmptyStringListCopier.copy(classicLinkVpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVpcSecurityGroups(String... classicLinkVpcSecurityGroups) {
            classicLinkVpcSecurityGroups(Arrays.asList(classicLinkVpcSecurityGroups));
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder getInstanceMonitoring() {
            return instanceMonitoring != null ? instanceMonitoring.toBuilder() : null;
        }

        public final void setInstanceMonitoring(
                AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        @Override
        public final Builder instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        @Override
        public AwsAutoScalingLaunchConfigurationDetails build() {
            return new AwsAutoScalingLaunchConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
