/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the versioning state of an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketVersioningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketBucketVersioningConfiguration.Builder, AwsS3BucketBucketVersioningConfiguration> {
    private static final SdkField<Boolean> IS_MFA_DELETE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsMfaDeleteEnabled").getter(getter(AwsS3BucketBucketVersioningConfiguration::isMfaDeleteEnabled))
            .setter(setter(Builder::isMfaDeleteEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMfaDeleteEnabled").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsS3BucketBucketVersioningConfiguration::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_MFA_DELETE_ENABLED_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isMfaDeleteEnabled;

    private final String status;

    private AwsS3BucketBucketVersioningConfiguration(BuilderImpl builder) {
        this.isMfaDeleteEnabled = builder.isMfaDeleteEnabled;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies whether MFA delete is currently enabled in the S3 bucket versioning configuration. If the S3 bucket was
     * never configured with MFA delete, then this attribute is not included.
     * </p>
     * 
     * @return Specifies whether MFA delete is currently enabled in the S3 bucket versioning configuration. If the S3
     *         bucket was never configured with MFA delete, then this attribute is not included.
     */
    public final Boolean isMfaDeleteEnabled() {
        return isMfaDeleteEnabled;
    }

    /**
     * <p>
     * The versioning status of the S3 bucket. Valid values are <code>Enabled</code> or <code>Suspended</code>.
     * </p>
     * 
     * @return The versioning status of the S3 bucket. Valid values are <code>Enabled</code> or <code>Suspended</code>.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isMfaDeleteEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketVersioningConfiguration)) {
            return false;
        }
        AwsS3BucketBucketVersioningConfiguration other = (AwsS3BucketBucketVersioningConfiguration) obj;
        return Objects.equals(isMfaDeleteEnabled(), other.isMfaDeleteEnabled()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketVersioningConfiguration").add("IsMfaDeleteEnabled", isMfaDeleteEnabled())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsMfaDeleteEnabled":
            return Optional.ofNullable(clazz.cast(isMfaDeleteEnabled()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketBucketVersioningConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketBucketVersioningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketBucketVersioningConfiguration> {
        /**
         * <p>
         * Specifies whether MFA delete is currently enabled in the S3 bucket versioning configuration. If the S3 bucket
         * was never configured with MFA delete, then this attribute is not included.
         * </p>
         * 
         * @param isMfaDeleteEnabled
         *        Specifies whether MFA delete is currently enabled in the S3 bucket versioning configuration. If the S3
         *        bucket was never configured with MFA delete, then this attribute is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMfaDeleteEnabled(Boolean isMfaDeleteEnabled);

        /**
         * <p>
         * The versioning status of the S3 bucket. Valid values are <code>Enabled</code> or <code>Suspended</code>.
         * </p>
         * 
         * @param status
         *        The versioning status of the S3 bucket. Valid values are <code>Enabled</code> or
         *        <code>Suspended</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isMfaDeleteEnabled;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketVersioningConfiguration model) {
            isMfaDeleteEnabled(model.isMfaDeleteEnabled);
            status(model.status);
        }

        public final Boolean getIsMfaDeleteEnabled() {
            return isMfaDeleteEnabled;
        }

        public final void setIsMfaDeleteEnabled(Boolean isMfaDeleteEnabled) {
            this.isMfaDeleteEnabled = isMfaDeleteEnabled;
        }

        @Override
        public final Builder isMfaDeleteEnabled(Boolean isMfaDeleteEnabled) {
            this.isMfaDeleteEnabled = isMfaDeleteEnabled;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsS3BucketBucketVersioningConfiguration build() {
            return new AwsS3BucketBucketVersioningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
