/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default server-side encryption to apply to new objects in the bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketServerSideEncryptionByDefault implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketServerSideEncryptionByDefault.Builder, AwsS3BucketServerSideEncryptionByDefault> {
    private static final SdkField<String> SSE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSEAlgorithm").getter(getter(AwsS3BucketServerSideEncryptionByDefault::sseAlgorithm))
            .setter(setter(Builder::sseAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAlgorithm").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSMasterKeyID").getter(getter(AwsS3BucketServerSideEncryptionByDefault::kmsMasterKeyID))
            .setter(setter(Builder::kmsMasterKeyID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSE_ALGORITHM_FIELD,
            KMS_MASTER_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sseAlgorithm;

    private final String kmsMasterKeyID;

    private AwsS3BucketServerSideEncryptionByDefault(BuilderImpl builder) {
        this.sseAlgorithm = builder.sseAlgorithm;
        this.kmsMasterKeyID = builder.kmsMasterKeyID;
    }

    /**
     * <p>
     * Server-side encryption algorithm to use for the default encryption. Valid values are <code>aws: kms</code> or
     * <code>AES256</code>.
     * </p>
     * 
     * @return Server-side encryption algorithm to use for the default encryption. Valid values are
     *         <code>aws: kms</code> or <code>AES256</code>.
     */
    public final String sseAlgorithm() {
        return sseAlgorithm;
    }

    /**
     * <p>
     * KMS key ID to use for the default encryption.
     * </p>
     * 
     * @return KMS key ID to use for the default encryption.
     */
    public final String kmsMasterKeyID() {
        return kmsMasterKeyID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sseAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketServerSideEncryptionByDefault)) {
            return false;
        }
        AwsS3BucketServerSideEncryptionByDefault other = (AwsS3BucketServerSideEncryptionByDefault) obj;
        return Objects.equals(sseAlgorithm(), other.sseAlgorithm()) && Objects.equals(kmsMasterKeyID(), other.kmsMasterKeyID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketServerSideEncryptionByDefault").add("SSEAlgorithm", sseAlgorithm())
                .add("KMSMasterKeyID", kmsMasterKeyID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SSEAlgorithm":
            return Optional.ofNullable(clazz.cast(sseAlgorithm()));
        case "KMSMasterKeyID":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketServerSideEncryptionByDefault, T> g) {
        return obj -> g.apply((AwsS3BucketServerSideEncryptionByDefault) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketServerSideEncryptionByDefault> {
        /**
         * <p>
         * Server-side encryption algorithm to use for the default encryption. Valid values are <code>aws: kms</code> or
         * <code>AES256</code>.
         * </p>
         * 
         * @param sseAlgorithm
         *        Server-side encryption algorithm to use for the default encryption. Valid values are
         *        <code>aws: kms</code> or <code>AES256</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseAlgorithm(String sseAlgorithm);

        /**
         * <p>
         * KMS key ID to use for the default encryption.
         * </p>
         * 
         * @param kmsMasterKeyID
         *        KMS key ID to use for the default encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyID(String kmsMasterKeyID);
    }

    static final class BuilderImpl implements Builder {
        private String sseAlgorithm;

        private String kmsMasterKeyID;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketServerSideEncryptionByDefault model) {
            sseAlgorithm(model.sseAlgorithm);
            kmsMasterKeyID(model.kmsMasterKeyID);
        }

        public final String getSseAlgorithm() {
            return sseAlgorithm;
        }

        public final void setSseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
        }

        @Override
        public final Builder sseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
            return this;
        }

        public final String getKmsMasterKeyID() {
            return kmsMasterKeyID;
        }

        public final void setKmsMasterKeyID(String kmsMasterKeyID) {
            this.kmsMasterKeyID = kmsMasterKeyID;
        }

        @Override
        public final Builder kmsMasterKeyID(String kmsMasterKeyID) {
            this.kmsMasterKeyID = kmsMasterKeyID;
            return this;
        }

        @Override
        public AwsS3BucketServerSideEncryptionByDefault build() {
            return new AwsS3BucketServerSideEncryptionByDefault(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
