/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container details related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDetails.Builder, ContainerDetails> {
    private static final SdkField<String> CONTAINER_RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerRuntime").getter(getter(ContainerDetails::containerRuntime))
            .setter(setter(Builder::containerRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerRuntime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContainerDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(ContainerDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(ContainerDetails::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchedAt").getter(getter(ContainerDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final SdkField<List<VolumeMount>> VOLUME_MOUNTS_FIELD = SdkField
            .<List<VolumeMount>> builder(MarshallingType.LIST)
            .memberName("VolumeMounts")
            .getter(getter(ContainerDetails::volumeMounts))
            .setter(setter(Builder::volumeMounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeMounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeMount> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeMount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Privileged").getter(getter(ContainerDetails::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_RUNTIME_FIELD,
            NAME_FIELD, IMAGE_ID_FIELD, IMAGE_NAME_FIELD, LAUNCHED_AT_FIELD, VOLUME_MOUNTS_FIELD, PRIVILEGED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerRuntime;

    private final String name;

    private final String imageId;

    private final String imageName;

    private final String launchedAt;

    private final List<VolumeMount> volumeMounts;

    private final Boolean privileged;

    private ContainerDetails(BuilderImpl builder) {
        this.containerRuntime = builder.containerRuntime;
        this.name = builder.name;
        this.imageId = builder.imageId;
        this.imageName = builder.imageName;
        this.launchedAt = builder.launchedAt;
        this.volumeMounts = builder.volumeMounts;
        this.privileged = builder.privileged;
    }

    /**
     * <p>
     * The runtime of the container.
     * </p>
     * 
     * @return The runtime of the container.
     */
    public final String containerRuntime() {
        return containerRuntime;
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * 
     * @return The name of the container related to a finding.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the container image related to a finding.
     * </p>
     * 
     * @return The identifier of the container image related to a finding.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the container image related to a finding.
     * </p>
     * 
     * @return The name of the container image related to a finding.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * Indicates when the container started.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the container started.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String launchedAt() {
        return launchedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeMounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeMounts() {
        return volumeMounts != null && !(volumeMounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the mounting of a volume in a container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeMounts} method.
     * </p>
     * 
     * @return Provides information about the mounting of a volume in a container.
     */
    public final List<VolumeMount> volumeMounts() {
        return volumeMounts;
    }

    /**
     * <p>
     * When this parameter is <code>true</code>, the container is given elevated privileges on the host container
     * instance (similar to the root user).
     * </p>
     * 
     * @return When this parameter is <code>true</code>, the container is given elevated privileges on the host
     *         container instance (similar to the root user).
     */
    public final Boolean privileged() {
        return privileged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeMounts() ? volumeMounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetails)) {
            return false;
        }
        ContainerDetails other = (ContainerDetails) obj;
        return Objects.equals(containerRuntime(), other.containerRuntime()) && Objects.equals(name(), other.name())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(imageName(), other.imageName())
                && Objects.equals(launchedAt(), other.launchedAt()) && hasVolumeMounts() == other.hasVolumeMounts()
                && Objects.equals(volumeMounts(), other.volumeMounts()) && Objects.equals(privileged(), other.privileged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerDetails").add("ContainerRuntime", containerRuntime()).add("Name", name())
                .add("ImageId", imageId()).add("ImageName", imageName()).add("LaunchedAt", launchedAt())
                .add("VolumeMounts", hasVolumeMounts() ? volumeMounts() : null).add("Privileged", privileged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerRuntime":
            return Optional.ofNullable(clazz.cast(containerRuntime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        case "VolumeMounts":
            return Optional.ofNullable(clazz.cast(volumeMounts()));
        case "Privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDetails, T> g) {
        return obj -> g.apply((ContainerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDetails> {
        /**
         * <p>
         * The runtime of the container.
         * </p>
         * 
         * @param containerRuntime
         *        The runtime of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRuntime(String containerRuntime);

        /**
         * <p>
         * The name of the container related to a finding.
         * </p>
         * 
         * @param name
         *        The name of the container related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the container image related to a finding.
         * </p>
         * 
         * @param imageId
         *        The identifier of the container image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the container image related to a finding.
         * </p>
         * 
         * @param imageName
         *        The name of the container image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * Indicates when the container started.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param launchedAt
         *        Indicates when the container started.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(String launchedAt);

        /**
         * <p>
         * Provides information about the mounting of a volume in a container.
         * </p>
         * 
         * @param volumeMounts
         *        Provides information about the mounting of a volume in a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeMounts(Collection<VolumeMount> volumeMounts);

        /**
         * <p>
         * Provides information about the mounting of a volume in a container.
         * </p>
         * 
         * @param volumeMounts
         *        Provides information about the mounting of a volume in a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeMounts(VolumeMount... volumeMounts);

        /**
         * <p>
         * Provides information about the mounting of a volume in a container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.VolumeMount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityhub.model.VolumeMount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.VolumeMount.Builder#build()} is called immediately
         * and its result is passed to {@link #volumeMounts(List<VolumeMount>)}.
         * 
         * @param volumeMounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.VolumeMount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeMounts(java.util.Collection<VolumeMount>)
         */
        Builder volumeMounts(Consumer<VolumeMount.Builder>... volumeMounts);

        /**
         * <p>
         * When this parameter is <code>true</code>, the container is given elevated privileges on the host container
         * instance (similar to the root user).
         * </p>
         * 
         * @param privileged
         *        When this parameter is <code>true</code>, the container is given elevated privileges on the host
         *        container instance (similar to the root user).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);
    }

    static final class BuilderImpl implements Builder {
        private String containerRuntime;

        private String name;

        private String imageId;

        private String imageName;

        private String launchedAt;

        private List<VolumeMount> volumeMounts = DefaultSdkAutoConstructList.getInstance();

        private Boolean privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetails model) {
            containerRuntime(model.containerRuntime);
            name(model.name);
            imageId(model.imageId);
            imageName(model.imageName);
            launchedAt(model.launchedAt);
            volumeMounts(model.volumeMounts);
            privileged(model.privileged);
        }

        public final String getContainerRuntime() {
            return containerRuntime;
        }

        public final void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        @Override
        public final Builder containerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getLaunchedAt() {
            return launchedAt;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final List<VolumeMount.Builder> getVolumeMounts() {
            List<VolumeMount.Builder> result = VolumeMountListCopier.copyToBuilder(this.volumeMounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeMounts(Collection<VolumeMount.BuilderImpl> volumeMounts) {
            this.volumeMounts = VolumeMountListCopier.copyFromBuilder(volumeMounts);
        }

        @Override
        public final Builder volumeMounts(Collection<VolumeMount> volumeMounts) {
            this.volumeMounts = VolumeMountListCopier.copy(volumeMounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(VolumeMount... volumeMounts) {
            volumeMounts(Arrays.asList(volumeMounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(Consumer<VolumeMount.Builder>... volumeMounts) {
            volumeMounts(Stream.of(volumeMounts).map(c -> VolumeMount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        @Override
        public ContainerDetails build() {
            return new ContainerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
