/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AccessDeniedException;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.CreateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.CreateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.CreateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.CreateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeHubRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeHubResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMembersRequest;
import software.amazon.awssdk.services.securityhub.model.GetMembersResponse;
import software.amazon.awssdk.services.securityhub.model.InternalException;
import software.amazon.awssdk.services.securityhub.model.InvalidAccessException;
import software.amazon.awssdk.services.securityhub.model.InvalidInputException;
import software.amazon.awssdk.services.securityhub.model.InviteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.InviteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.LimitExceededException;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListMembersRequest;
import software.amazon.awssdk.services.securityhub.model.ListMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityhub.model.ResourceConflictException;
import software.amazon.awssdk.services.securityhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityhub.model.SecurityHubException;
import software.amazon.awssdk.services.securityhub.model.TagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlResponse;
import software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable;

/**
 * Service client for accessing AWS SecurityHub. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Security Hub provides you with a comprehensive view of the security state of your Amazon Web Services environment and
 * resources. It also provides you with the readiness status of your environment based on controls from supported
 * security standards. Security Hub collects security data from Amazon Web Services accounts, services, and integrated
 * third-party products and helps you analyze security trends in your environment to identify the highest priority
 * security issues. For more information about Security Hub, see the <i>Security Hub<a
 * href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">User Guide</a> </i>.
 * </p>
 * <p>
 * When you use operations in the Security Hub API, the requests are executed only in the Amazon Web Services Region
 * that is currently active or in the specific Amazon Web Services Region that you specify in your request. Any
 * configuration or settings change that results from the operation is applied only to that Region. To make the same
 * change in other Regions, execute the same command for each Region to apply the change to.
 * </p>
 * <p>
 * For example, if your Region is set to <code>us-west-2</code>, when you use <code>CreateMembers</code> to add a member
 * account to Security Hub, the association of the member account with the administrator account is created only in the
 * <code>us-west-2</code> Region. Security Hub must be enabled for the member account in the same Region that the
 * invitation was sent from.
 * </p>
 * <p>
 * The following throttling limits apply to using Security Hub API operations.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>BatchEnableStandards</code> - <code>RateLimit</code> of 1 request per second, <code>BurstLimit</code> of 1
 * request per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetFindings</code> - <code>RateLimit</code> of 3 requests per second. <code>BurstLimit</code> of 6 requests per
 * second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateFindings</code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 5 requests
 * per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateStandardsControl</code> - <code>RateLimit</code> of 1 request per second, <code>BurstLimit</code> of 5
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * All other operations - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per
 * second.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityHubClient extends SdkClient {
    String SERVICE_NAME = "securityhub";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "securityhub";

    /**
     * Create a {@link SecurityHubClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityHubClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityHubClient}.
     */
    static SecurityHubClientBuilder builder() {
        return new DefaultSecurityHubClientBuilder();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) throws InternalException,
            InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAdministratorInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAdministratorInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptAdministratorInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            Consumer<AcceptAdministratorInvitationRequest.Builder> acceptAdministratorInvitationRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.builder()
                .applyMutation(acceptAdministratorInvitationRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws InternalException,
            InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInvitationRequest.Builder} to create a request.
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     */
    default AcceptInvitationResponse acceptInvitation(Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchDisableStandardsRequest
     * @return Result of the BatchDisableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableStandardsResponse batchDisableStandards(BatchDisableStandardsRequest batchDisableStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDisableStandardsRequest#builder()}
     * </p>
     *
     * @param batchDisableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisableStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDisableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableStandardsResponse batchDisableStandards(
            Consumer<BatchDisableStandardsRequest.Builder> batchDisableStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchDisableStandards(BatchDisableStandardsRequest.builder().applyMutation(batchDisableStandardsRequest).build());
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code>DescribeStandards</code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchEnableStandardsRequest
     * @return Result of the BatchEnableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableStandardsResponse batchEnableStandards(BatchEnableStandardsRequest batchEnableStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code>DescribeStandards</code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEnableStandardsRequest#builder()}
     * </p>
     *
     * @param batchEnableStandardsRequest
     *        A {@link Consumer} that will call methods on {@link BatchEnableStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchEnableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableStandardsResponse batchEnableStandards(
            Consumer<BatchEnableStandardsRequest.Builder> batchEnableStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchEnableStandards(BatchEnableStandardsRequest.builder().applyMutation(batchEnableStandardsRequest).build());
    }

    /**
     * <p>
     * Imports security findings generated from an integrated product into Security Hub. This action is requested by the
     * integrated product to import its findings into Security Hub.
     * </p>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     *
     * @param batchImportFindingsRequest
     * @return Result of the BatchImportFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportFindingsResponse batchImportFindings(BatchImportFindingsRequest batchImportFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports security findings generated from an integrated product into Security Hub. This action is requested by the
     * integrated product to import its findings into Security Hub.
     * </p>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchImportFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchImportFindingsRequest#builder()}
     * </p>
     *
     * @param batchImportFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchImportFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchImportFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportFindingsResponse batchImportFindings(
            Consumer<BatchImportFindingsRequest.Builder> batchImportFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchImportFindings(BatchImportFindingsRequest.builder().applyMutation(batchImportFindingsRequest).build());
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by
     * administrator accounts or member accounts. Administrator accounts can update findings for their account and their
     * member accounts. Member accounts can update findings for their account.
     * </p>
     * <p>
     * Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.
     * </p>
     * <p>
     * Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields
     * and objects.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. See <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchUpdateFindingsRequest
     * @return Result of the BatchUpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsResponse batchUpdateFindings(BatchUpdateFindingsRequest batchUpdateFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by
     * administrator accounts or member accounts. Administrator accounts can update findings for their account and their
     * member accounts. Member accounts can update findings for their account.
     * </p>
     * <p>
     * Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.
     * </p>
     * <p>
     * Administrator and member accounts can use <code>BatchUpdateFindings</code> to update the following finding fields
     * and objects.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. See <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateFindingsRequest#builder()}
     * </p>
     *
     * @param batchUpdateFindingsRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsResponse batchUpdateFindings(
            Consumer<BatchUpdateFindingsRequest.Builder> batchUpdateFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchUpdateFindings(BatchUpdateFindingsRequest.builder().applyMutation(batchUpdateFindingsRequest).build());
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     *
     * @param createActionTargetRequest
     * @return Result of the CreateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateActionTargetResponse createActionTarget(CreateActionTargetRequest createActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateActionTargetRequest#builder()}
     * </p>
     *
     * @param createActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateActionTargetResponse createActionTarget(Consumer<CreateActionTargetRequest.Builder> createActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createActionTarget(CreateActionTargetRequest.builder().applyMutation(createActionTargetRequest).build());
    }

    /**
     * <p>
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     * </p>
     * <p>
     * For more details about cross-Region replication, see <a
     * href="securityhub/latest/userguide/finding-aggregation.html">Configuring finding aggregation</a> in the
     * <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param createFindingAggregatorRequest
     * @return Result of the CreateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingAggregatorResponse createFindingAggregator(CreateFindingAggregatorRequest createFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     * </p>
     * <p>
     * For more details about cross-Region replication, see <a
     * href="securityhub/latest/userguide/finding-aggregation.html">Configuring finding aggregation</a> in the
     * <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param createFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link CreateFindingAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingAggregatorResponse createFindingAggregator(
            Consumer<CreateFindingAggregatorRequest.Builder> createFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return createFindingAggregator(CreateFindingAggregatorRequest.builder().applyMutation(createFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     *
     * @param createInsightRequest
     * @return Result of the CreateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInsightResponse createInsight(CreateInsightRequest createInsightRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInsightRequest#builder()}
     * </p>
     *
     * @param createInsightRequest
     *        A {@link Consumer} that will call methods on {@link CreateInsightRequest.Builder} to create a request.
     * @return Result of the CreateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInsightResponse createInsight(Consumer<CreateInsightRequest.Builder> createInsightRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createInsight(CreateInsightRequest.builder().applyMutation(createInsightRequest).build());
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following
     * cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new organization accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code>EnableSecurityHub</code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account
     * owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the organization account does not have Security Hub enabled, then Security Hub and the default standards are
     * automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management
     * account. The organization management account must enable Security Hub before the administrator account enables it
     * as a member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to
     * those accounts. It does not change their enabled standards or controls.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.
     * </p>
     *
     * @param createMembersRequest
     * @return Result of the CreateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following
     * cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new organization accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code>EnableSecurityHub</code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account
     * owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the organization account does not have Security Hub enabled, then Security Hub and the default standards are
     * automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management
     * account. The organization management account must enable Security Hub before the administrator account enables it
     * as a member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to
     * those accounts. It does not change their enabled standards or controls.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on {@link CreateMembersRequest.Builder} to create a request.
     * @return Result of the CreateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines invitations to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     *
     * @param deleteActionTargetRequest
     * @return Result of the DeleteActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteActionTargetResponse deleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteActionTargetRequest#builder()}
     * </p>
     *
     * @param deleteActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteActionTargetResponse deleteActionTarget(Consumer<DeleteActionTargetRequest.Builder> deleteActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return deleteActionTarget(DeleteActionTargetRequest.builder().applyMutation(deleteActionTargetRequest).build());
    }

    /**
     * <p>
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     * </p>
     * <p>
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still
     * visible from the aggregation Region. New findings and finding updates are not aggregated.
     * </p>
     *
     * @param deleteFindingAggregatorRequest
     * @return Result of the DeleteFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFindingAggregatorResponse deleteFindingAggregator(DeleteFindingAggregatorRequest deleteFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     * </p>
     * <p>
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still
     * visible from the aggregation Region. New findings and finding updates are not aggregated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param deleteFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFindingAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFindingAggregatorResponse deleteFindingAggregator(
            Consumer<DeleteFindingAggregatorRequest.Builder> deleteFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteFindingAggregator(DeleteFindingAggregatorRequest.builder().applyMutation(deleteFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     *
     * @param deleteInsightRequest
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(DeleteInsightRequest deleteInsightRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInsightRequest.Builder} to create a request.
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <p>
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not
     * receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInvitationsRequest.Builder} to create a request.
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited
     * manually.
     * </p>
     *
     * @param deleteMembersRequest
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMembersRequest.Builder} to create a request.
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return Result of the DescribeActionTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsResponse describeActionTargets(DescribeActionTargetsRequest describeActionTargetsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeActionTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsResponse describeActionTargets(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeActionTargets(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client
     *             .describeActionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsIterable describeActionTargetsPaginator(DescribeActionTargetsRequest describeActionTargetsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client
     *             .describeActionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsIterable describeActionTargetsPaginator(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeActionTargetsPaginator(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     *
     * @param describeHubRequest
     * @return Result of the DescribeHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(DescribeHubRequest describeHubRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHubRequest.Builder} to create a request.
     * @return Result of the DescribeHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security
     * Hub administrator account.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security
     * Hub administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     *
     * @param describeProductsRequest
     * @return Result of the DescribeProducts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsResponse describeProducts(DescribeProductsRequest describeProductsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return Result of the DescribeProducts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsResponse describeProducts(Consumer<DescribeProductsRequest.Builder> describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeProducts(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client
     *             .describeProductsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsIterable describeProductsPaginator(DescribeProductsRequest describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client
     *             .describeProductsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProductsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsIterable describeProductsPaginator(Consumer<DescribeProductsRequest.Builder> describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeProductsPaginator(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     *
     * @param describeStandardsRequest
     * @return Result of the DescribeStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsResponse describeStandards(DescribeStandardsRequest describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsRequest.Builder} to create a request.
     * @return Result of the DescribeStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsResponse describeStandards(Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandards(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client
     *             .describeStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsIterable describeStandardsPaginator(DescribeStandardsRequest describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client
     *             .describeStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsIterable describeStandardsPaginator(
            Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return describeStandardsPaginator(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return Result of the DescribeStandardsControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsResponse describeStandardsControls(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsControlsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeStandardsControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsResponse describeStandardsControls(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandardsControls(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client
     *             .describeStandardsControlsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsIterable describeStandardsControlsPaginator(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client
     *             .describeStandardsControlsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStandardsControlsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsIterable describeStandardsControlsPaginator(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandardsControlsPaginator(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     * @return Result of the DisableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableImportFindingsForProductResponse disableImportFindingsForProduct(
            DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, InvalidAccessException, LimitExceededException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link DisableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link DisableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return Result of the DisableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableImportFindingsForProductResponse disableImportFindingsForProduct(
            Consumer<DisableImportFindingsForProductRequest.Builder> disableImportFindingsForProductRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return disableImportFindingsForProduct(DisableImportFindingsForProductRequest.builder()
                .applyMutation(disableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see #disableSecurityHub(DisableSecurityHubRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub() throws InternalException, LimitExceededException,
            InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return disableSecurityHub(DisableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @param disableSecurityHubRequest
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you
     * must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated
     * member accounts.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSecurityHubRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSecurityHubRequest#builder()}
     * </p>
     *
     * @param disableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link DisableSecurityHubRequest.Builder} to create a
     *        request.
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub(Consumer<DisableSecurityHubRequest.Builder> disableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return disableSecurityHub(DisableSecurityHubRequest.builder().applyMutation(disableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     * @return Result of the EnableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableImportFindingsForProductResponse enableImportFindingsForProduct(
            EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceConflictException, LimitExceededException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link EnableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on {@link EnableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return Result of the EnableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableImportFindingsForProductResponse enableImportFindingsForProduct(
            Consumer<EnableImportFindingsForProductRequest.Builder> enableImportFindingsForProductRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceConflictException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return enableImportFindingsForProduct(EnableImportFindingsForProductRequest.builder()
                .applyMutation(enableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS Amazon Web Services Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see #enableSecurityHub(EnableSecurityHubRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub() throws InternalException, LimitExceededException,
            InvalidAccessException, ResourceConflictException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return enableSecurityHub(EnableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS Amazon Web Services Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param enableSecurityHubRequest
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CIS Amazon Web Services Foundations
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     * </p>
     * <p>
     * To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSecurityHubRequest.Builder} avoiding the need
     * to create one manually via {@link EnableSecurityHubRequest#builder()}
     * </p>
     *
     * @param enableSecurityHubRequest
     *        A {@link Consumer} that will call methods on {@link EnableSecurityHubRequest.Builder} to create a request.
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub(Consumer<EnableSecurityHubRequest.Builder> enableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return enableSecurityHub(EnableSecurityHubRequest.builder().applyMutation(enableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(GetAdministratorAccountRequest getAdministratorAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdministratorAccountRequest.Builder} to create a
     *        request.
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return Result of the GetEnabledStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsResponse getEnabledStandards(GetEnabledStandardsRequest getEnabledStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on {@link GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnabledStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsResponse getEnabledStandards(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getEnabledStandards(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client
     *             .getEnabledStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsIterable getEnabledStandardsPaginator(GetEnabledStandardsRequest getEnabledStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client
     *             .getEnabledStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on {@link GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsIterable getEnabledStandardsPaginator(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getEnabledStandardsPaginator(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current finding aggregation configuration.
     * </p>
     *
     * @param getFindingAggregatorRequest
     * @return Result of the GetFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingAggregatorResponse getFindingAggregator(GetFindingAggregatorRequest getFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current finding aggregation configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingAggregatorRequest.Builder} avoiding the
     * need to create one manually via {@link GetFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param getFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the GetFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingAggregatorResponse getFindingAggregator(
            Consumer<GetFindingAggregatorRequest.Builder> getFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingAggregator(GetFindingAggregatorRequest.builder().applyMutation(getFindingAggregatorRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     *
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see #getFindings(GetFindingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindings(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     *
     * @param getFindingsRequest
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see #getFindingsPaginator(GetFindingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingsPaginator(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @param getFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(GetFindingsRequest getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If finding aggregation is enabled, then when you call <code>GetFindings</code> from the aggregation Region, the
     * results include all of the matching findings from both the aggregation Region and the linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return getFindingsPaginator(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     *
     * @param getInsightResultsRequest
     * @return Result of the GetInsightResults operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightResultsResponse getInsightResults(GetInsightResultsRequest getInsightResultsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightResultsRequest#builder()}
     * </p>
     *
     * @param getInsightResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightResultsRequest.Builder} to create a request.
     * @return Result of the GetInsightResults operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightResultsResponse getInsightResults(Consumer<GetInsightResultsRequest.Builder> getInsightResultsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInsightResults(GetInsightResultsRequest.builder().applyMutation(getInsightResultsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     *
     * @param getInsightsRequest
     * @return Result of the GetInsights operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(GetInsightsRequest getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return Result of the GetInsights operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     *
     * @param getInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsIterable getInsightsPaginator(GetInsightsRequest getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsIterable getInsightsPaginator(Consumer<GetInsightsRequest.Builder> getInsightsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInsightsPaginator(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see #getInvitationsCount(GetInvitationsCountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount() throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not
     * including the currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see #getMasterAccount(GetMasterAccountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMasterAccountResponse getMasterAccount() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getMasterAccount(GetMasterAccountRequest.builder().build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetMasterAccountRequest.Builder} to create a request.
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMasterAccountResponse getMasterAccount(Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param getMembersRequest
     * @return Result of the GetMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on {@link GetMembersRequest.Builder} to create a request.
     * @return Result of the GetMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account
     * that the invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do
     * not receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to
     * create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated from the member account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return Result of the InviteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account
     * that the invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do
     * not receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to
     * create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated from the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on {@link InviteMembersRequest.Builder} to create a request.
     * @return Result of the InviteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see #listEnabledProductsForImport(ListEnabledProductsForImportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport() throws InternalException, LimitExceededException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see #listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator() throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on {@link ListEnabledProductsForImportRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding
     * aggregator. You can run this operation from any Region.
     * </p>
     *
     * @param listFindingAggregatorsRequest
     * @return Result of the ListFindingAggregators operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsResponse listFindingAggregators(ListFindingAggregatorsRequest listFindingAggregatorsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding
     * aggregator. You can run this operation from any Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingAggregatorsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingAggregatorsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFindingAggregators operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsResponse listFindingAggregators(
            Consumer<ListFindingAggregatorsRequest.Builder> listFindingAggregatorsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listFindingAggregators(ListFindingAggregatorsRequest.builder().applyMutation(listFindingAggregatorsRequest)
                .build());
    }

    /**
     * <p>
     * If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding
     * aggregator. You can run this operation from any Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client
     *             .listFindingAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingAggregatorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsIterable listFindingAggregatorsPaginator(
            ListFindingAggregatorsRequest listFindingAggregatorsRequest) throws InternalException, LimitExceededException,
            InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If finding aggregation is enabled, then <code>ListFindingAggregators</code> returns the ARN of the finding
     * aggregator. You can run this operation from any Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client
     *             .listFindingAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingAggregatorsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingAggregatorsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsIterable listFindingAggregatorsPaginator(
            Consumer<ListFindingAggregatorsRequest.Builder> listFindingAggregatorsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listFindingAggregatorsPaginator(ListFindingAggregatorsRequest.builder()
                .applyMutation(listFindingAggregatorsRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     *
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see #listInvitations(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     *
     * @param listInvitationsRequest
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see #listInvitationsPaginator(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator() throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     * </p>
     * <p>
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the
     * integration with Organizations do not receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see #listMembers(ListMembersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listMembers(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see #listMembersPaginator(ListMembersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listMembersPaginator(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     *
     * @param updateActionTargetRequest
     * @return Result of the UpdateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActionTargetResponse updateActionTarget(UpdateActionTargetRequest updateActionTargetRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateActionTargetRequest#builder()}
     * </p>
     *
     * @param updateActionTargetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActionTargetResponse updateActionTarget(Consumer<UpdateActionTargetRequest.Builder> updateActionTargetRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return updateActionTarget(UpdateActionTargetRequest.builder().applyMutation(updateActionTargetRequest).build());
    }

    /**
     * <p>
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or
     * excluded Regions. You cannot use <code>UpdateFindingAggregator</code> to change the aggregation Region.
     * </p>
     * <p>
     * You must run <code>UpdateFindingAggregator</code> from the current aggregation Region.
     * </p>
     *
     * @param updateFindingAggregatorRequest
     * @return Result of the UpdateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingAggregatorResponse updateFindingAggregator(UpdateFindingAggregatorRequest updateFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or
     * excluded Regions. You cannot use <code>UpdateFindingAggregator</code> to change the aggregation Region.
     * </p>
     * <p>
     * You must run <code>UpdateFindingAggregator</code> from the current aggregation Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param updateFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingAggregatorResponse updateFindingAggregator(
            Consumer<UpdateFindingAggregatorRequest.Builder> updateFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateFindingAggregator(UpdateFindingAggregatorRequest.builder().applyMutation(updateFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use
     * <code>BatchUpdateFindings</code>.
     * </p>
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     *
     * @param updateFindingsRequest
     * @return Result of the UpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFindingsResponse updateFindings(UpdateFindingsRequest updateFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use
     * <code>BatchUpdateFindings</code>.
     * </p>
     * <p>
     * Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the
     * filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFindingsRequest#builder()}
     * </p>
     *
     * @param updateFindingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingsRequest.Builder} to create a request.
     * @return Result of the UpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFindingsResponse updateFindings(Consumer<UpdateFindingsRequest.Builder> updateFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateFindings(UpdateFindingsRequest.builder().applyMutation(updateFindingsRequest).build());
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     *
     * @param updateInsightRequest
     * @return Result of the UpdateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInsightResponse updateInsight(UpdateInsightRequest updateInsightRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInsightRequest#builder()}
     * </p>
     *
     * @param updateInsightRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInsightRequest.Builder} to create a request.
     * @return Result of the UpdateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInsightResponse updateInsight(Consumer<UpdateInsightRequest.Builder> updateInsightRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateInsight(UpdateInsightRequest.builder().applyMutation(updateInsightRequest).build());
    }

    /**
     * <p>
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator
     * account.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     * @return Result of the UpdateSecurityHubConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityHubConfigurationResponse updateSecurityHubConfiguration(
            UpdateSecurityHubConfigurationRequest updateSecurityHubConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityHubConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSecurityHubConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSecurityHubConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSecurityHubConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityHubConfigurationResponse updateSecurityHubConfiguration(
            Consumer<UpdateSecurityHubConfigurationRequest.Builder> updateSecurityHubConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest.builder()
                .applyMutation(updateSecurityHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     *
     * @param updateStandardsControlRequest
     * @return Result of the UpdateStandardsControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStandardsControlResponse updateStandardsControl(UpdateStandardsControlRequest updateStandardsControlRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStandardsControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStandardsControlRequest#builder()}
     * </p>
     *
     * @param updateStandardsControlRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStandardsControlRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateStandardsControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         There is an issue with the account used to make the request. Either Security Hub is not enabled for the
     *         account, or the account does not have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStandardsControlResponse updateStandardsControl(
            Consumer<UpdateStandardsControlRequest.Builder> updateStandardsControlRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return updateStandardsControl(UpdateStandardsControlRequest.builder().applyMutation(updateStandardsControlRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
