/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZoneName").getter(getter(AvailabilityZone::zoneName)).setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AvailabilityZone::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_NAME_FIELD,
            SUBNET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String zoneName;

    private final String subnetId;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The name of the Availability Zone.
     * </p>
     * 
     * @return The name of the Availability Zone.
     */
    public final String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The ID of the subnet. You can specify one subnet per Availability Zone.
     * </p>
     * 
     * @return The ID of the subnet. You can specify one subnet per Availability Zone.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(zoneName(), other.zoneName()) && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityZone").add("ZoneName", zoneName()).add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The ID of the subnet. You can specify one subnet per Availability Zone.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet. You can specify one subnet per Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private String zoneName;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            zoneName(model.zoneName);
            subnetId(model.subnetId);
        }

        public final String getZoneName() {
            return zoneName;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        @Transient
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
