/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Certificate Manager certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCertificateManagerCertificateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCertificateManagerCertificateDetails.Builder, AwsCertificateManagerCertificateDetails> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn")
            .getter(getter(AwsCertificateManagerCertificateDetails::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(AwsCertificateManagerCertificateDetails::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsCertificateManagerCertificateDetails::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<AwsCertificateManagerCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField
            .<List<AwsCertificateManagerCertificateDomainValidationOption>> builder(MarshallingType.LIST)
            .memberName("DomainValidationOptions")
            .getter(getter(AwsCertificateManagerCertificateDetails::domainValidationOptions))
            .setter(setter(Builder::domainValidationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCertificateManagerCertificateDomainValidationOption> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsCertificateManagerCertificateDomainValidationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsCertificateManagerCertificateExtendedKeyUsage>> EXTENDED_KEY_USAGES_FIELD = SdkField
            .<List<AwsCertificateManagerCertificateExtendedKeyUsage>> builder(MarshallingType.LIST)
            .memberName("ExtendedKeyUsages")
            .getter(getter(AwsCertificateManagerCertificateDetails::extendedKeyUsages))
            .setter(setter(Builder::extendedKeyUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCertificateManagerCertificateExtendedKeyUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCertificateManagerCertificateExtendedKeyUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AwsCertificateManagerCertificateDetails::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> IMPORTED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportedAt").getter(getter(AwsCertificateManagerCertificateDetails::importedAt))
            .setter(setter(Builder::importedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedAt").build()).build();

    private static final SdkField<List<String>> IN_USE_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InUseBy")
            .getter(getter(AwsCertificateManagerCertificateDetails::inUseBy))
            .setter(setter(Builder::inUseBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssuedAt").getter(getter(AwsCertificateManagerCertificateDetails::issuedAt))
            .setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(AwsCertificateManagerCertificateDetails::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyAlgorithm").getter(getter(AwsCertificateManagerCertificateDetails::keyAlgorithm))
            .setter(setter(Builder::keyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()).build();

    private static final SdkField<List<AwsCertificateManagerCertificateKeyUsage>> KEY_USAGES_FIELD = SdkField
            .<List<AwsCertificateManagerCertificateKeyUsage>> builder(MarshallingType.LIST)
            .memberName("KeyUsages")
            .getter(getter(AwsCertificateManagerCertificateDetails::keyUsages))
            .setter(setter(Builder::keyUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCertificateManagerCertificateKeyUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCertificateManagerCertificateKeyUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOT_AFTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotAfter").getter(getter(AwsCertificateManagerCertificateDetails::notAfter))
            .setter(setter(Builder::notAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").build()).build();

    private static final SdkField<String> NOT_BEFORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotBefore").getter(getter(AwsCertificateManagerCertificateDetails::notBefore))
            .setter(setter(Builder::notBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").build()).build();

    private static final SdkField<AwsCertificateManagerCertificateOptions> OPTIONS_FIELD = SdkField
            .<AwsCertificateManagerCertificateOptions> builder(MarshallingType.SDK_POJO).memberName("Options")
            .getter(getter(AwsCertificateManagerCertificateDetails::options)).setter(setter(Builder::options))
            .constructor(AwsCertificateManagerCertificateOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<String> RENEWAL_ELIGIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenewalEligibility").getter(getter(AwsCertificateManagerCertificateDetails::renewalEligibility))
            .setter(setter(Builder::renewalEligibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalEligibility").build())
            .build();

    private static final SdkField<AwsCertificateManagerCertificateRenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField
            .<AwsCertificateManagerCertificateRenewalSummary> builder(MarshallingType.SDK_POJO).memberName("RenewalSummary")
            .getter(getter(AwsCertificateManagerCertificateDetails::renewalSummary)).setter(setter(Builder::renewalSummary))
            .constructor(AwsCertificateManagerCertificateRenewalSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalSummary").build()).build();

    private static final SdkField<String> SERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Serial")
            .getter(getter(AwsCertificateManagerCertificateDetails::serial)).setter(setter(Builder::serial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()).build();

    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignatureAlgorithm").getter(getter(AwsCertificateManagerCertificateDetails::signatureAlgorithm))
            .setter(setter(Builder::signatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureAlgorithm").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsCertificateManagerCertificateDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(AwsCertificateManagerCertificateDetails::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubjectAlternativeNames")
            .getter(getter(AwsCertificateManagerCertificateDetails::subjectAlternativeNames))
            .setter(setter(Builder::subjectAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsCertificateManagerCertificateDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, CREATED_AT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD,
            EXTENDED_KEY_USAGES_FIELD, FAILURE_REASON_FIELD, IMPORTED_AT_FIELD, IN_USE_BY_FIELD, ISSUED_AT_FIELD, ISSUER_FIELD,
            KEY_ALGORITHM_FIELD, KEY_USAGES_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, OPTIONS_FIELD, RENEWAL_ELIGIBILITY_FIELD,
            RENEWAL_SUMMARY_FIELD, SERIAL_FIELD, SIGNATURE_ALGORITHM_FIELD, STATUS_FIELD, SUBJECT_FIELD,
            SUBJECT_ALTERNATIVE_NAMES_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateAuthorityArn;

    private final String createdAt;

    private final String domainName;

    private final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions;

    private final List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages;

    private final String failureReason;

    private final String importedAt;

    private final List<String> inUseBy;

    private final String issuedAt;

    private final String issuer;

    private final String keyAlgorithm;

    private final List<AwsCertificateManagerCertificateKeyUsage> keyUsages;

    private final String notAfter;

    private final String notBefore;

    private final AwsCertificateManagerCertificateOptions options;

    private final String renewalEligibility;

    private final AwsCertificateManagerCertificateRenewalSummary renewalSummary;

    private final String serial;

    private final String signatureAlgorithm;

    private final String status;

    private final String subject;

    private final List<String> subjectAlternativeNames;

    private final String type;

    private AwsCertificateManagerCertificateDetails(BuilderImpl builder) {
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.createdAt = builder.createdAt;
        this.domainName = builder.domainName;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.extendedKeyUsages = builder.extendedKeyUsages;
        this.failureReason = builder.failureReason;
        this.importedAt = builder.importedAt;
        this.inUseBy = builder.inUseBy;
        this.issuedAt = builder.issuedAt;
        this.issuer = builder.issuer;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyUsages = builder.keyUsages;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.options = builder.options;
        this.renewalEligibility = builder.renewalEligibility;
        this.renewalSummary = builder.renewalSummary;
        this.serial = builder.serial;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.status = builder.status;
        this.subject = builder.subject;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the private certificate authority (CA) that will be used to issue the certificate.
     * </p>
     * 
     * @return The ARN of the private certificate authority (CA) that will be used to issue the certificate.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * Indicates when the certificate was requested.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the certificate was requested.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
     * </p>
     * 
     * @return The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainValidationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainValidationOptions() {
        return domainValidationOptions != null && !(domainValidationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the initial validation of each domain name that occurs as a result of the
     * <code>RequestCertificate</code> request.
     * </p>
     * <p>
     * Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainValidationOptions} method.
     * </p>
     * 
     * @return Contains information about the initial validation of each domain name that occurs as a result of the
     *         <code>RequestCertificate</code> request.</p>
     *         <p>
     *         Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
     */
    public final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions() {
        return domainValidationOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtendedKeyUsages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtendedKeyUsages() {
        return extendedKeyUsages != null && !(extendedKeyUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the
     * certificate public key can be used and consists of a name and an object identifier (OID).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtendedKeyUsages} method.
     * </p>
     * 
     * @return Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for
     *         which the certificate public key can be used and consists of a name and an object identifier (OID).
     */
    public final List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages() {
        return extendedKeyUsages;
    }

    /**
     * <p>
     * For a failed certificate request, the reason for the failure.
     * </p>
     * <p>
     * Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
     * <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code> |
     * <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> |
     * <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> | <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> |
     * <code>PCA_RESOURCE_NOT_FOUND</code> | <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> |
     * <code>PCA_ACCESS_DENIED</code> | <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
     * </p>
     * 
     * @return For a failed certificate request, the reason for the failure.</p>
     *         <p>
     *         Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
     *         <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> |
     *         <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> |
     *         <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
     *         <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
     *         <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
     *         <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Indicates when the certificate was imported. Provided if the certificate type is <code>IMPORTED</code>.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the certificate was imported. Provided if the certificate type is <code>IMPORTED</code>
     *         .</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String importedAt() {
        return importedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the InUseBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInUseBy() {
        return inUseBy != null && !(inUseBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ARNs for the Amazon Web Services resources that use the certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInUseBy} method.
     * </p>
     * 
     * @return The list of ARNs for the Amazon Web Services resources that use the certificate.
     */
    public final List<String> inUseBy() {
        return inUseBy;
    }

    /**
     * <p>
     * Indicates when the certificate was issued. Provided if the certificate type is <code>AMAZON_ISSUED</code>.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the certificate was issued. Provided if the certificate type is <code>AMAZON_ISSUED</code>
     *         .</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String issuedAt() {
        return issuedAt;
    }

    /**
     * <p>
     * The name of the certificate authority that issued and signed the certificate.
     * </p>
     * 
     * @return The name of the certificate authority that issued and signed the certificate.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The algorithm that was used to generate the public-private key pair.
     * </p>
     * <p>
     * Valid values: <code>RSA_2048</code> | <code>RSA_1024</code> |<code> RSA_4096</code> | <code>EC_prime256v1</code>
     * | <code>EC_secp384r1</code> | <code>EC_secp521r1</code>
     * </p>
     * 
     * @return The algorithm that was used to generate the public-private key pair.</p>
     *         <p>
     *         Valid values: <code>RSA_2048</code> | <code>RSA_1024</code> |<code> RSA_4096</code> |
     *         <code>EC_prime256v1</code> | <code>EC_secp384r1</code> | <code>EC_secp521r1</code>
     */
    public final String keyAlgorithm() {
        return keyAlgorithm;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyUsages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeyUsages() {
        return keyUsages != null && !(keyUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key usage X.509 v3 extension objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyUsages} method.
     * </p>
     * 
     * @return A list of key usage X.509 v3 extension objects.
     */
    public final List<AwsCertificateManagerCertificateKeyUsage> keyUsages() {
        return keyUsages;
    }

    /**
     * <p>
     * The time after which the certificate becomes invalid.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The time after which the certificate becomes invalid.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The time before which the certificate is not valid.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The time before which the certificate is not valid.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String notBefore() {
        return notBefore;
    }

    /**
     * <p>
     * Provides a value that specifies whether to add the certificate to a transparency log.
     * </p>
     * 
     * @return Provides a value that specifies whether to add the certificate to a transparency log.
     */
    public final AwsCertificateManagerCertificateOptions options() {
        return options;
    }

    /**
     * <p>
     * Whether the certificate is eligible for renewal.
     * </p>
     * <p>
     * Valid values: <code>ELIGIBLE</code> | <code>INELIGIBLE</code>
     * </p>
     * 
     * @return Whether the certificate is eligible for renewal.</p>
     *         <p>
     *         Valid values: <code>ELIGIBLE</code> | <code>INELIGIBLE</code>
     */
    public final String renewalEligibility() {
        return renewalEligibility;
    }

    /**
     * <p>
     * Information about the status of the Certificate Manager managed renewal for the certificate. Provided only when
     * the certificate type is <code>AMAZON_ISSUED</code>.
     * </p>
     * 
     * @return Information about the status of the Certificate Manager managed renewal for the certificate. Provided
     *         only when the certificate type is <code>AMAZON_ISSUED</code>.
     */
    public final AwsCertificateManagerCertificateRenewalSummary renewalSummary() {
        return renewalSummary;
    }

    /**
     * <p>
     * The serial number of the certificate.
     * </p>
     * 
     * @return The serial number of the certificate.
     */
    public final String serial() {
        return serial;
    }

    /**
     * <p>
     * The algorithm that was used to sign the certificate.
     * </p>
     * 
     * @return The algorithm that was used to sign the certificate.
     */
    public final String signatureAlgorithm() {
        return signatureAlgorithm;
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * Valid values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> |
     * <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code>
     * </p>
     * 
     * @return The status of the certificate.</p>
     *         <p>
     *         Valid values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> |
     *         <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The name of the entity that is associated with the public key contained in the certificate.
     * </p>
     * 
     * @return The name of the entity that is associated with the public key contained in the certificate.
     */
    public final String subject() {
        return subject;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubjectAlternativeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubjectAlternativeNames() {
        return subjectAlternativeNames != null && !(subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more domain names (subject alternative names) included in the certificate. This list contains the domain
     * names that are bound to the public key that is contained in the certificate.
     * </p>
     * <p>
     * The subject alternative names include the canonical domain name (CN) of the certificate and additional domain
     * names that can be used to connect to the website.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubjectAlternativeNames} method.
     * </p>
     * 
     * @return One or more domain names (subject alternative names) included in the certificate. This list contains the
     *         domain names that are bound to the public key that is contained in the certificate.</p>
     *         <p>
     *         The subject alternative names include the canonical domain name (CN) of the certificate and additional
     *         domain names that can be used to connect to the website.
     */
    public final List<String> subjectAlternativeNames() {
        return subjectAlternativeNames;
    }

    /**
     * <p>
     * The source of the certificate. For certificates that Certificate Manager provides, <code>Type</code> is
     * <code>AMAZON_ISSUED</code>. For certificates that are imported with <code>ImportCertificate</code>,
     * <code>Type</code> is <code>IMPORTED</code>.
     * </p>
     * <p>
     * Valid values: <code>IMPORTED</code> | <code>AMAZON_ISSUED</code> | <code>PRIVATE</code>
     * </p>
     * 
     * @return The source of the certificate. For certificates that Certificate Manager provides, <code>Type</code> is
     *         <code>AMAZON_ISSUED</code>. For certificates that are imported with <code>ImportCertificate</code>,
     *         <code>Type</code> is <code>IMPORTED</code>.</p>
     *         <p>
     *         Valid values: <code>IMPORTED</code> | <code>AMAZON_ISSUED</code> | <code>PRIVATE</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainValidationOptions() ? domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendedKeyUsages() ? extendedKeyUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(importedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasInUseBy() ? inUseBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(keyAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyUsages() ? keyUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(renewalEligibility());
        hashCode = 31 * hashCode + Objects.hashCode(renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(serial());
        hashCode = 31 * hashCode + Objects.hashCode(signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjectAlternativeNames() ? subjectAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateDetails)) {
            return false;
        }
        AwsCertificateManagerCertificateDetails other = (AwsCertificateManagerCertificateDetails) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(domainName(), other.domainName())
                && hasDomainValidationOptions() == other.hasDomainValidationOptions()
                && Objects.equals(domainValidationOptions(), other.domainValidationOptions())
                && hasExtendedKeyUsages() == other.hasExtendedKeyUsages()
                && Objects.equals(extendedKeyUsages(), other.extendedKeyUsages())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(importedAt(), other.importedAt())
                && hasInUseBy() == other.hasInUseBy() && Objects.equals(inUseBy(), other.inUseBy())
                && Objects.equals(issuedAt(), other.issuedAt()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(keyAlgorithm(), other.keyAlgorithm()) && hasKeyUsages() == other.hasKeyUsages()
                && Objects.equals(keyUsages(), other.keyUsages()) && Objects.equals(notAfter(), other.notAfter())
                && Objects.equals(notBefore(), other.notBefore()) && Objects.equals(options(), other.options())
                && Objects.equals(renewalEligibility(), other.renewalEligibility())
                && Objects.equals(renewalSummary(), other.renewalSummary()) && Objects.equals(serial(), other.serial())
                && Objects.equals(signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(status(), other.status())
                && Objects.equals(subject(), other.subject())
                && hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames()
                && Objects.equals(subjectAlternativeNames(), other.subjectAlternativeNames())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCertificateManagerCertificateDetails")
                .add("CertificateAuthorityArn", certificateAuthorityArn()).add("CreatedAt", createdAt())
                .add("DomainName", domainName())
                .add("DomainValidationOptions", hasDomainValidationOptions() ? domainValidationOptions() : null)
                .add("ExtendedKeyUsages", hasExtendedKeyUsages() ? extendedKeyUsages() : null)
                .add("FailureReason", failureReason()).add("ImportedAt", importedAt())
                .add("InUseBy", hasInUseBy() ? inUseBy() : null).add("IssuedAt", issuedAt()).add("Issuer", issuer())
                .add("KeyAlgorithm", keyAlgorithm()).add("KeyUsages", hasKeyUsages() ? keyUsages() : null)
                .add("NotAfter", notAfter()).add("NotBefore", notBefore()).add("Options", options())
                .add("RenewalEligibility", renewalEligibility()).add("RenewalSummary", renewalSummary()).add("Serial", serial())
                .add("SignatureAlgorithm", signatureAlgorithm()).add("Status", status()).add("Subject", subject())
                .add("SubjectAlternativeNames", hasSubjectAlternativeNames() ? subjectAlternativeNames() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainValidationOptions":
            return Optional.ofNullable(clazz.cast(domainValidationOptions()));
        case "ExtendedKeyUsages":
            return Optional.ofNullable(clazz.cast(extendedKeyUsages()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ImportedAt":
            return Optional.ofNullable(clazz.cast(importedAt()));
        case "InUseBy":
            return Optional.ofNullable(clazz.cast(inUseBy()));
        case "IssuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "KeyAlgorithm":
            return Optional.ofNullable(clazz.cast(keyAlgorithm()));
        case "KeyUsages":
            return Optional.ofNullable(clazz.cast(keyUsages()));
        case "NotAfter":
            return Optional.ofNullable(clazz.cast(notAfter()));
        case "NotBefore":
            return Optional.ofNullable(clazz.cast(notBefore()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "RenewalEligibility":
            return Optional.ofNullable(clazz.cast(renewalEligibility()));
        case "RenewalSummary":
            return Optional.ofNullable(clazz.cast(renewalSummary()));
        case "Serial":
            return Optional.ofNullable(clazz.cast(serial()));
        case "SignatureAlgorithm":
            return Optional.ofNullable(clazz.cast(signatureAlgorithm()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "SubjectAlternativeNames":
            return Optional.ofNullable(clazz.cast(subjectAlternativeNames()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateDetails, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCertificateManagerCertificateDetails> {
        /**
         * <p>
         * The ARN of the private certificate authority (CA) that will be used to issue the certificate.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The ARN of the private certificate authority (CA) that will be used to issue the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * Indicates when the certificate was requested.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdAt
         *        Indicates when the certificate was requested.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
         * </p>
         * 
         * @param domainName
         *        The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Contains information about the initial validation of each domain name that occurs as a result of the
         * <code>RequestCertificate</code> request.
         * </p>
         * <p>
         * Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the initial validation of each domain name that occurs as a result of the
         *        <code>RequestCertificate</code> request.</p>
         *        <p>
         *        Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions);

        /**
         * <p>
         * Contains information about the initial validation of each domain name that occurs as a result of the
         * <code>RequestCertificate</code> request.
         * </p>
         * <p>
         * Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the initial validation of each domain name that occurs as a result of the
         *        <code>RequestCertificate</code> request.</p>
         *        <p>
         *        Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption... domainValidationOptions);

        /**
         * <p>
         * Contains information about the initial validation of each domain name that occurs as a result of the
         * <code>RequestCertificate</code> request.
         * </p>
         * <p>
         * Only provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsCertificateManagerCertificateDomainValidationOption>.Builder} avoiding the need to create one manually
         * via {@link List<AwsCertificateManagerCertificateDomainValidationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsCertificateManagerCertificateDomainValidationOption>.Builder#build()} is called immediately and its
         * result is passed to {@link
         * #domainValidationOptions(List<AwsCertificateManagerCertificateDomainValidationOption>)}.
         * 
         * @param domainValidationOptions
         *        a consumer that will call methods on {@link List
         *        <AwsCertificateManagerCertificateDomainValidationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationOptions(List<AwsCertificateManagerCertificateDomainValidationOption>)
         */
        Builder domainValidationOptions(
                Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder>... domainValidationOptions);

        /**
         * <p>
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which
         * the certificate public key can be used and consists of a name and an object identifier (OID).
         * </p>
         * 
         * @param extendedKeyUsages
         *        Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for
         *        which the certificate public key can be used and consists of a name and an object identifier (OID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsages(Collection<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages);

        /**
         * <p>
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which
         * the certificate public key can be used and consists of a name and an object identifier (OID).
         * </p>
         * 
         * @param extendedKeyUsages
         *        Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for
         *        which the certificate public key can be used and consists of a name and an object identifier (OID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedKeyUsages(AwsCertificateManagerCertificateExtendedKeyUsage... extendedKeyUsages);

        /**
         * <p>
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which
         * the certificate public key can be used and consists of a name and an object identifier (OID).
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsCertificateManagerCertificateExtendedKeyUsage>.Builder} avoiding the need to create one manually via
         * {@link List<AwsCertificateManagerCertificateExtendedKeyUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsCertificateManagerCertificateExtendedKeyUsage>.Builder#build()} is called immediately and its result is
         * passed to {@link #extendedKeyUsages(List<AwsCertificateManagerCertificateExtendedKeyUsage>)}.
         * 
         * @param extendedKeyUsages
         *        a consumer that will call methods on {@link List
         *        <AwsCertificateManagerCertificateExtendedKeyUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedKeyUsages(List<AwsCertificateManagerCertificateExtendedKeyUsage>)
         */
        Builder extendedKeyUsages(Consumer<AwsCertificateManagerCertificateExtendedKeyUsage.Builder>... extendedKeyUsages);

        /**
         * <p>
         * For a failed certificate request, the reason for the failure.
         * </p>
         * <p>
         * Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
         * <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code>
         * | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> |
         * <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
         * <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
         * <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
         * <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
         * </p>
         * 
         * @param failureReason
         *        For a failed certificate request, the reason for the failure.</p>
         *        <p>
         *        Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
         *        <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> |
         *        <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> |
         *        <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
         *        <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
         *        <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
         *        <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Indicates when the certificate was imported. Provided if the certificate type is <code>IMPORTED</code>.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param importedAt
         *        Indicates when the certificate was imported. Provided if the certificate type is <code>IMPORTED</code>
         *        .</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedAt(String importedAt);

        /**
         * <p>
         * The list of ARNs for the Amazon Web Services resources that use the certificate.
         * </p>
         * 
         * @param inUseBy
         *        The list of ARNs for the Amazon Web Services resources that use the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseBy(Collection<String> inUseBy);

        /**
         * <p>
         * The list of ARNs for the Amazon Web Services resources that use the certificate.
         * </p>
         * 
         * @param inUseBy
         *        The list of ARNs for the Amazon Web Services resources that use the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseBy(String... inUseBy);

        /**
         * <p>
         * Indicates when the certificate was issued. Provided if the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param issuedAt
         *        Indicates when the certificate was issued. Provided if the certificate type is
         *        <code>AMAZON_ISSUED</code>.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(String issuedAt);

        /**
         * <p>
         * The name of the certificate authority that issued and signed the certificate.
         * </p>
         * 
         * @param issuer
         *        The name of the certificate authority that issued and signed the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The algorithm that was used to generate the public-private key pair.
         * </p>
         * <p>
         * Valid values: <code>RSA_2048</code> | <code>RSA_1024</code> |<code> RSA_4096</code> |
         * <code>EC_prime256v1</code> | <code>EC_secp384r1</code> | <code>EC_secp521r1</code>
         * </p>
         * 
         * @param keyAlgorithm
         *        The algorithm that was used to generate the public-private key pair.</p>
         *        <p>
         *        Valid values: <code>RSA_2048</code> | <code>RSA_1024</code> |<code> RSA_4096</code> |
         *        <code>EC_prime256v1</code> | <code>EC_secp384r1</code> | <code>EC_secp521r1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAlgorithm(String keyAlgorithm);

        /**
         * <p>
         * A list of key usage X.509 v3 extension objects.
         * </p>
         * 
         * @param keyUsages
         *        A list of key usage X.509 v3 extension objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsages(Collection<AwsCertificateManagerCertificateKeyUsage> keyUsages);

        /**
         * <p>
         * A list of key usage X.509 v3 extension objects.
         * </p>
         * 
         * @param keyUsages
         *        A list of key usage X.509 v3 extension objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyUsages(AwsCertificateManagerCertificateKeyUsage... keyUsages);

        /**
         * <p>
         * A list of key usage X.509 v3 extension objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsCertificateManagerCertificateKeyUsage>.Builder} avoiding the need to create one manually via {@link List
         * <AwsCertificateManagerCertificateKeyUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsCertificateManagerCertificateKeyUsage>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #keyUsages(List<AwsCertificateManagerCertificateKeyUsage>)}.
         * 
         * @param keyUsages
         *        a consumer that will call methods on {@link List<AwsCertificateManagerCertificateKeyUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyUsages(List<AwsCertificateManagerCertificateKeyUsage>)
         */
        Builder keyUsages(Consumer<AwsCertificateManagerCertificateKeyUsage.Builder>... keyUsages);

        /**
         * <p>
         * The time after which the certificate becomes invalid.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param notAfter
         *        The time after which the certificate becomes invalid.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(String notAfter);

        /**
         * <p>
         * The time before which the certificate is not valid.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param notBefore
         *        The time before which the certificate is not valid.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(String notBefore);

        /**
         * <p>
         * Provides a value that specifies whether to add the certificate to a transparency log.
         * </p>
         * 
         * @param options
         *        Provides a value that specifies whether to add the certificate to a transparency log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(AwsCertificateManagerCertificateOptions options);

        /**
         * <p>
         * Provides a value that specifies whether to add the certificate to a transparency log.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCertificateManagerCertificateOptions.Builder}
         * avoiding the need to create one manually via {@link AwsCertificateManagerCertificateOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCertificateManagerCertificateOptions.Builder#build()} is
         * called immediately and its result is passed to {@link #options(AwsCertificateManagerCertificateOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link AwsCertificateManagerCertificateOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(AwsCertificateManagerCertificateOptions)
         */
        default Builder options(Consumer<AwsCertificateManagerCertificateOptions.Builder> options) {
            return options(AwsCertificateManagerCertificateOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * Whether the certificate is eligible for renewal.
         * </p>
         * <p>
         * Valid values: <code>ELIGIBLE</code> | <code>INELIGIBLE</code>
         * </p>
         * 
         * @param renewalEligibility
         *        Whether the certificate is eligible for renewal.</p>
         *        <p>
         *        Valid values: <code>ELIGIBLE</code> | <code>INELIGIBLE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalEligibility(String renewalEligibility);

        /**
         * <p>
         * Information about the status of the Certificate Manager managed renewal for the certificate. Provided only
         * when the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * 
         * @param renewalSummary
         *        Information about the status of the Certificate Manager managed renewal for the certificate. Provided
         *        only when the certificate type is <code>AMAZON_ISSUED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalSummary(AwsCertificateManagerCertificateRenewalSummary renewalSummary);

        /**
         * <p>
         * Information about the status of the Certificate Manager managed renewal for the certificate. Provided only
         * when the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsCertificateManagerCertificateRenewalSummary.Builder} avoiding the need to create one manually via
         * {@link AwsCertificateManagerCertificateRenewalSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCertificateManagerCertificateRenewalSummary.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #renewalSummary(AwsCertificateManagerCertificateRenewalSummary)}.
         * 
         * @param renewalSummary
         *        a consumer that will call methods on {@link AwsCertificateManagerCertificateRenewalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalSummary(AwsCertificateManagerCertificateRenewalSummary)
         */
        default Builder renewalSummary(Consumer<AwsCertificateManagerCertificateRenewalSummary.Builder> renewalSummary) {
            return renewalSummary(AwsCertificateManagerCertificateRenewalSummary.builder().applyMutation(renewalSummary).build());
        }

        /**
         * <p>
         * The serial number of the certificate.
         * </p>
         * 
         * @param serial
         *        The serial number of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serial(String serial);

        /**
         * <p>
         * The algorithm that was used to sign the certificate.
         * </p>
         * 
         * @param signatureAlgorithm
         *        The algorithm that was used to sign the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureAlgorithm(String signatureAlgorithm);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * <p>
         * Valid values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> |
         * <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code>
         * </p>
         * 
         * @param status
         *        The status of the certificate.</p>
         *        <p>
         *        Valid values: <code>PENDING_VALIDATION</code> | <code>ISSUED</code> | <code>INACTIVE</code> |
         *        <code>EXPIRED</code> | <code>VALIDATION_TIMED_OUT</code> | <code>REVOKED</code> | <code>FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The name of the entity that is associated with the public key contained in the certificate.
         * </p>
         * 
         * @param subject
         *        The name of the entity that is associated with the public key contained in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * One or more domain names (subject alternative names) included in the certificate. This list contains the
         * domain names that are bound to the public key that is contained in the certificate.
         * </p>
         * <p>
         * The subject alternative names include the canonical domain name (CN) of the certificate and additional domain
         * names that can be used to connect to the website.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        One or more domain names (subject alternative names) included in the certificate. This list contains
         *        the domain names that are bound to the public key that is contained in the certificate.</p>
         *        <p>
         *        The subject alternative names include the canonical domain name (CN) of the certificate and additional
         *        domain names that can be used to connect to the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames);

        /**
         * <p>
         * One or more domain names (subject alternative names) included in the certificate. This list contains the
         * domain names that are bound to the public key that is contained in the certificate.
         * </p>
         * <p>
         * The subject alternative names include the canonical domain name (CN) of the certificate and additional domain
         * names that can be used to connect to the website.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        One or more domain names (subject alternative names) included in the certificate. This list contains
         *        the domain names that are bound to the public key that is contained in the certificate.</p>
         *        <p>
         *        The subject alternative names include the canonical domain name (CN) of the certificate and additional
         *        domain names that can be used to connect to the website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(String... subjectAlternativeNames);

        /**
         * <p>
         * The source of the certificate. For certificates that Certificate Manager provides, <code>Type</code> is
         * <code>AMAZON_ISSUED</code>. For certificates that are imported with <code>ImportCertificate</code>,
         * <code>Type</code> is <code>IMPORTED</code>.
         * </p>
         * <p>
         * Valid values: <code>IMPORTED</code> | <code>AMAZON_ISSUED</code> | <code>PRIVATE</code>
         * </p>
         * 
         * @param type
         *        The source of the certificate. For certificates that Certificate Manager provides, <code>Type</code>
         *        is <code>AMAZON_ISSUED</code>. For certificates that are imported with <code>ImportCertificate</code>,
         *        <code>Type</code> is <code>IMPORTED</code>.</p>
         *        <p>
         *        Valid values: <code>IMPORTED</code> | <code>AMAZON_ISSUED</code> | <code>PRIVATE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private String createdAt;

        private String domainName;

        private List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages = DefaultSdkAutoConstructList
                .getInstance();

        private String failureReason;

        private String importedAt;

        private List<String> inUseBy = DefaultSdkAutoConstructList.getInstance();

        private String issuedAt;

        private String issuer;

        private String keyAlgorithm;

        private List<AwsCertificateManagerCertificateKeyUsage> keyUsages = DefaultSdkAutoConstructList.getInstance();

        private String notAfter;

        private String notBefore;

        private AwsCertificateManagerCertificateOptions options;

        private String renewalEligibility;

        private AwsCertificateManagerCertificateRenewalSummary renewalSummary;

        private String serial;

        private String signatureAlgorithm;

        private String status;

        private String subject;

        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateDetails model) {
            certificateAuthorityArn(model.certificateAuthorityArn);
            createdAt(model.createdAt);
            domainName(model.domainName);
            domainValidationOptions(model.domainValidationOptions);
            extendedKeyUsages(model.extendedKeyUsages);
            failureReason(model.failureReason);
            importedAt(model.importedAt);
            inUseBy(model.inUseBy);
            issuedAt(model.issuedAt);
            issuer(model.issuer);
            keyAlgorithm(model.keyAlgorithm);
            keyUsages(model.keyUsages);
            notAfter(model.notAfter);
            notBefore(model.notBefore);
            options(model.options);
            renewalEligibility(model.renewalEligibility);
            renewalSummary(model.renewalSummary);
            serial(model.serial);
            signatureAlgorithm(model.signatureAlgorithm);
            status(model.status);
            subject(model.subject);
            subjectAlternativeNames(model.subjectAlternativeNames);
            type(model.type);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        @Transient
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<AwsCertificateManagerCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            List<AwsCertificateManagerCertificateDomainValidationOption.Builder> result = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(
                Collection<AwsCertificateManagerCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copyFromBuilder(domainValidationOptions);
        }

        @Override
        @Transient
        public final Builder domainValidationOptions(
                Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copy(domainValidationOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(
                AwsCertificateManagerCertificateDomainValidationOption... domainValidationOptions) {
            domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(
                Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder>... domainValidationOptions) {
            domainValidationOptions(Stream.of(domainValidationOptions)
                    .map(c -> AwsCertificateManagerCertificateDomainValidationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> getExtendedKeyUsages() {
            List<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> result = AwsCertificateManagerCertificateExtendedKeyUsagesCopier
                    .copyToBuilder(this.extendedKeyUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtendedKeyUsages(
                Collection<AwsCertificateManagerCertificateExtendedKeyUsage.BuilderImpl> extendedKeyUsages) {
            this.extendedKeyUsages = AwsCertificateManagerCertificateExtendedKeyUsagesCopier.copyFromBuilder(extendedKeyUsages);
        }

        @Override
        @Transient
        public final Builder extendedKeyUsages(Collection<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = AwsCertificateManagerCertificateExtendedKeyUsagesCopier.copy(extendedKeyUsages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder extendedKeyUsages(AwsCertificateManagerCertificateExtendedKeyUsage... extendedKeyUsages) {
            extendedKeyUsages(Arrays.asList(extendedKeyUsages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder extendedKeyUsages(
                Consumer<AwsCertificateManagerCertificateExtendedKeyUsage.Builder>... extendedKeyUsages) {
            extendedKeyUsages(Stream.of(extendedKeyUsages)
                    .map(c -> AwsCertificateManagerCertificateExtendedKeyUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImportedAt() {
            return importedAt;
        }

        public final void setImportedAt(String importedAt) {
            this.importedAt = importedAt;
        }

        @Override
        @Transient
        public final Builder importedAt(String importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final Collection<String> getInUseBy() {
            if (inUseBy instanceof SdkAutoConstructList) {
                return null;
            }
            return inUseBy;
        }

        public final void setInUseBy(Collection<String> inUseBy) {
            this.inUseBy = StringListCopier.copy(inUseBy);
        }

        @Override
        @Transient
        public final Builder inUseBy(Collection<String> inUseBy) {
            this.inUseBy = StringListCopier.copy(inUseBy);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inUseBy(String... inUseBy) {
            inUseBy(Arrays.asList(inUseBy));
            return this;
        }

        public final String getIssuedAt() {
            return issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        @Transient
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        @Transient
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getKeyAlgorithm() {
            return keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        @Transient
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public final List<AwsCertificateManagerCertificateKeyUsage.Builder> getKeyUsages() {
            List<AwsCertificateManagerCertificateKeyUsage.Builder> result = AwsCertificateManagerCertificateKeyUsagesCopier
                    .copyToBuilder(this.keyUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyUsages(Collection<AwsCertificateManagerCertificateKeyUsage.BuilderImpl> keyUsages) {
            this.keyUsages = AwsCertificateManagerCertificateKeyUsagesCopier.copyFromBuilder(keyUsages);
        }

        @Override
        @Transient
        public final Builder keyUsages(Collection<AwsCertificateManagerCertificateKeyUsage> keyUsages) {
            this.keyUsages = AwsCertificateManagerCertificateKeyUsagesCopier.copy(keyUsages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keyUsages(AwsCertificateManagerCertificateKeyUsage... keyUsages) {
            keyUsages(Arrays.asList(keyUsages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keyUsages(Consumer<AwsCertificateManagerCertificateKeyUsage.Builder>... keyUsages) {
            keyUsages(Stream.of(keyUsages).map(c -> AwsCertificateManagerCertificateKeyUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNotAfter() {
            return notAfter;
        }

        public final void setNotAfter(String notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        @Transient
        public final Builder notAfter(String notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final String getNotBefore() {
            return notBefore;
        }

        public final void setNotBefore(String notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        @Transient
        public final Builder notBefore(String notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final AwsCertificateManagerCertificateOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(AwsCertificateManagerCertificateOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(AwsCertificateManagerCertificateOptions options) {
            this.options = options;
            return this;
        }

        public final String getRenewalEligibility() {
            return renewalEligibility;
        }

        public final void setRenewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
        }

        @Override
        @Transient
        public final Builder renewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
            return this;
        }

        public final AwsCertificateManagerCertificateRenewalSummary.Builder getRenewalSummary() {
            return renewalSummary != null ? renewalSummary.toBuilder() : null;
        }

        public final void setRenewalSummary(AwsCertificateManagerCertificateRenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder renewalSummary(AwsCertificateManagerCertificateRenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final String getSerial() {
            return serial;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        @Override
        @Transient
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final String getSignatureAlgorithm() {
            return signatureAlgorithm;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        @Transient
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        @Transient
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return subjectAlternativeNames;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
        }

        @Override
        @Transient
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subjectAlternativeNames(String... subjectAlternativeNames) {
            subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsCertificateManagerCertificateDetails build() {
            return new AwsCertificateManagerCertificateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
