/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an origin that is an S3 bucket that is not configured with static website hosting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginS3OriginConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginS3OriginConfig.Builder, AwsCloudFrontDistributionOriginS3OriginConfig> {
    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginAccessIdentity")
            .getter(getter(AwsCloudFrontDistributionOriginS3OriginConfig::originAccessIdentity))
            .setter(setter(Builder::originAccessIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String originAccessIdentity;

    private AwsCloudFrontDistributionOriginS3OriginConfig(BuilderImpl builder) {
        this.originAccessIdentity = builder.originAccessIdentity;
    }

    /**
     * <p>
     * The CloudFront origin access identity to associate with the origin.
     * </p>
     * 
     * @return The CloudFront origin access identity to associate with the origin.
     */
    public final String originAccessIdentity() {
        return originAccessIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originAccessIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginS3OriginConfig)) {
            return false;
        }
        AwsCloudFrontDistributionOriginS3OriginConfig other = (AwsCloudFrontDistributionOriginS3OriginConfig) obj;
        return Objects.equals(originAccessIdentity(), other.originAccessIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginS3OriginConfig")
                .add("OriginAccessIdentity", originAccessIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginAccessIdentity":
            return Optional.ofNullable(clazz.cast(originAccessIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginS3OriginConfig, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginS3OriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginS3OriginConfig> {
        /**
         * <p>
         * The CloudFront origin access identity to associate with the origin.
         * </p>
         * 
         * @param originAccessIdentity
         *        The CloudFront origin access identity to associate with the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessIdentity(String originAccessIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String originAccessIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginS3OriginConfig model) {
            originAccessIdentity(model.originAccessIdentity);
        }

        public final String getOriginAccessIdentity() {
            return originAccessIdentity;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        @Transient
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginS3OriginConfig build() {
            return new AwsCloudFrontDistributionOriginS3OriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
