/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The credentials for access to a private registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectEnvironmentRegistryCredential
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectEnvironmentRegistryCredential.Builder, AwsCodeBuildProjectEnvironmentRegistryCredential> {
    private static final SdkField<String> CREDENTIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Credential").getter(getter(AwsCodeBuildProjectEnvironmentRegistryCredential::credential))
            .setter(setter(Builder::credential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credential").build()).build();

    private static final SdkField<String> CREDENTIAL_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialProvider")
            .getter(getter(AwsCodeBuildProjectEnvironmentRegistryCredential::credentialProvider))
            .setter(setter(Builder::credentialProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_FIELD,
            CREDENTIAL_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String credential;

    private final String credentialProvider;

    private AwsCodeBuildProjectEnvironmentRegistryCredential(BuilderImpl builder) {
        this.credential = builder.credential;
        this.credentialProvider = builder.credentialProvider;
    }

    /**
     * <p>
     * The ARN or name of credentials created using Secrets Manager.
     * </p>
     * <note>
     * <p>
     * The credential can use the name of the credentials only if they exist in your current Amazon Web Services Region.
     * </p>
     * </note>
     * 
     * @return The ARN or name of credentials created using Secrets Manager.</p> <note>
     *         <p>
     *         The credential can use the name of the credentials only if they exist in your current Amazon Web Services
     *         Region.
     *         </p>
     */
    public final String credential() {
        return credential;
    }

    /**
     * <p>
     * The service that created the credentials to access a private Docker registry.
     * </p>
     * <p>
     * The valid value,<code> SECRETS_MANAGER</code>, is for Secrets Manager.
     * </p>
     * 
     * @return The service that created the credentials to access a private Docker registry.</p>
     *         <p>
     *         The valid value,<code> SECRETS_MANAGER</code>, is for Secrets Manager.
     */
    public final String credentialProvider() {
        return credentialProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credential());
        hashCode = 31 * hashCode + Objects.hashCode(credentialProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectEnvironmentRegistryCredential)) {
            return false;
        }
        AwsCodeBuildProjectEnvironmentRegistryCredential other = (AwsCodeBuildProjectEnvironmentRegistryCredential) obj;
        return Objects.equals(credential(), other.credential())
                && Objects.equals(credentialProvider(), other.credentialProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectEnvironmentRegistryCredential").add("Credential", credential())
                .add("CredentialProvider", credentialProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credential":
            return Optional.ofNullable(clazz.cast(credential()));
        case "CredentialProvider":
            return Optional.ofNullable(clazz.cast(credentialProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectEnvironmentRegistryCredential, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectEnvironmentRegistryCredential) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectEnvironmentRegistryCredential> {
        /**
         * <p>
         * The ARN or name of credentials created using Secrets Manager.
         * </p>
         * <note>
         * <p>
         * The credential can use the name of the credentials only if they exist in your current Amazon Web Services
         * Region.
         * </p>
         * </note>
         * 
         * @param credential
         *        The ARN or name of credentials created using Secrets Manager.</p> <note>
         *        <p>
         *        The credential can use the name of the credentials only if they exist in your current Amazon Web
         *        Services Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credential(String credential);

        /**
         * <p>
         * The service that created the credentials to access a private Docker registry.
         * </p>
         * <p>
         * The valid value,<code> SECRETS_MANAGER</code>, is for Secrets Manager.
         * </p>
         * 
         * @param credentialProvider
         *        The service that created the credentials to access a private Docker registry.</p>
         *        <p>
         *        The valid value,<code> SECRETS_MANAGER</code>, is for Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProvider(String credentialProvider);
    }

    static final class BuilderImpl implements Builder {
        private String credential;

        private String credentialProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectEnvironmentRegistryCredential model) {
            credential(model.credential);
            credentialProvider(model.credentialProvider);
        }

        public final String getCredential() {
            return credential;
        }

        public final void setCredential(String credential) {
            this.credential = credential;
        }

        @Override
        @Transient
        public final Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public final String getCredentialProvider() {
            return credentialProvider;
        }

        public final void setCredentialProvider(String credentialProvider) {
            this.credentialProvider = credentialProvider;
        }

        @Override
        @Transient
        public final Builder credentialProvider(String credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Override
        public AwsCodeBuildProjectEnvironmentRegistryCredential build() {
            return new AwsCodeBuildProjectEnvironmentRegistryCredential(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
