/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about CloudWatch Logs for the build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.Builder, AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            STATUS_FIELD, STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String status;

    private final String streamName;

    private AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.status = builder.status;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * The group name of the logs in CloudWatch Logs.
     * </p>
     * 
     * @return The group name of the logs in CloudWatch Logs.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The current status of the logs in CloudWatch Logs for a build project.
     * </p>
     * 
     * @return The current status of the logs in CloudWatch Logs for a build project.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The prefix of the stream name of the CloudWatch Logs.
     * </p>
     * 
     * @return The prefix of the stream name of the CloudWatch Logs.
     */
    public final String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails)) {
            return false;
        }
        AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails other = (AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(status(), other.status())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails").add("GroupName", groupName())
                .add("Status", status()).add("StreamName", streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails> {
        /**
         * <p>
         * The group name of the logs in CloudWatch Logs.
         * </p>
         * 
         * @param groupName
         *        The group name of the logs in CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The current status of the logs in CloudWatch Logs for a build project.
         * </p>
         * 
         * @param status
         *        The current status of the logs in CloudWatch Logs for a build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The prefix of the stream name of the CloudWatch Logs.
         * </p>
         * 
         * @param streamName
         *        The prefix of the stream name of the CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String status;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails model) {
            groupName(model.groupName);
            status(model.status);
            streamName(model.streamName);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        public AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails build() {
            return new AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
