/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an EC2 network access control list (ACL).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkAclDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkAclDetails.Builder, AwsEc2NetworkAclDetails> {
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(AwsEc2NetworkAclDetails::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclId").getter(getter(AwsEc2NetworkAclDetails::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(AwsEc2NetworkAclDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2NetworkAclDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<AwsEc2NetworkAclAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<AwsEc2NetworkAclAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(AwsEc2NetworkAclDetails::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2NetworkAclAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2NetworkAclAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2NetworkAclEntry>> ENTRIES_FIELD = SdkField
            .<List<AwsEc2NetworkAclEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(AwsEc2NetworkAclDetails::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2NetworkAclEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2NetworkAclEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DEFAULT_FIELD,
            NETWORK_ACL_ID_FIELD, OWNER_ID_FIELD, VPC_ID_FIELD, ASSOCIATIONS_FIELD, ENTRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isDefault;

    private final String networkAclId;

    private final String ownerId;

    private final String vpcId;

    private final List<AwsEc2NetworkAclAssociation> associations;

    private final List<AwsEc2NetworkAclEntry> entries;

    private AwsEc2NetworkAclDetails(BuilderImpl builder) {
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.ownerId = builder.ownerId;
        this.vpcId = builder.vpcId;
        this.associations = builder.associations;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * Whether this is the default network ACL for the VPC.
     * </p>
     * 
     * @return Whether this is the default network ACL for the VPC.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The identifier of the network ACL.
     * </p>
     * 
     * @return The identifier of the network ACL.
     */
    public final String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that owns the network ACL.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that owns the network ACL.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The identifier of the VPC for the network ACL.
     * </p>
     * 
     * @return The identifier of the VPC for the network ACL.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Associations between the network ACL and subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return Associations between the network ACL and subnets.
     */
    public final List<AwsEc2NetworkAclAssociation> associations() {
        return associations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of rules in the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return The set of rules in the network ACL.
     */
    public final List<AwsEc2NetworkAclEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkAclDetails)) {
            return false;
        }
        AwsEc2NetworkAclDetails other = (AwsEc2NetworkAclDetails) obj;
        return Objects.equals(isDefault(), other.isDefault()) && Objects.equals(networkAclId(), other.networkAclId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(vpcId(), other.vpcId())
                && hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2NetworkAclDetails").add("IsDefault", isDefault()).add("NetworkAclId", networkAclId())
                .add("OwnerId", ownerId()).add("VpcId", vpcId()).add("Associations", hasAssociations() ? associations() : null)
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkAclDetails, T> g) {
        return obj -> g.apply((AwsEc2NetworkAclDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkAclDetails> {
        /**
         * <p>
         * Whether this is the default network ACL for the VPC.
         * </p>
         * 
         * @param isDefault
         *        Whether this is the default network ACL for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The identifier of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The identifier of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The identifier of the Amazon Web Services account that owns the network ACL.
         * </p>
         * 
         * @param ownerId
         *        The identifier of the Amazon Web Services account that owns the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The identifier of the VPC for the network ACL.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC for the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Associations between the network ACL and subnets.
         * </p>
         * 
         * @param associations
         *        Associations between the network ACL and subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<AwsEc2NetworkAclAssociation> associations);

        /**
         * <p>
         * Associations between the network ACL and subnets.
         * </p>
         * 
         * @param associations
         *        Associations between the network ACL and subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(AwsEc2NetworkAclAssociation... associations);

        /**
         * <p>
         * Associations between the network ACL and subnets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2NetworkAclAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2NetworkAclAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2NetworkAclAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<AwsEc2NetworkAclAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link List<AwsEc2NetworkAclAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(List<AwsEc2NetworkAclAssociation>)
         */
        Builder associations(Consumer<AwsEc2NetworkAclAssociation.Builder>... associations);

        /**
         * <p>
         * The set of rules in the network ACL.
         * </p>
         * 
         * @param entries
         *        The set of rules in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<AwsEc2NetworkAclEntry> entries);

        /**
         * <p>
         * The set of rules in the network ACL.
         * </p>
         * 
         * @param entries
         *        The set of rules in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(AwsEc2NetworkAclEntry... entries);

        /**
         * <p>
         * The set of rules in the network ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2NetworkAclEntry>.Builder} avoiding
         * the need to create one manually via {@link List<AwsEc2NetworkAclEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2NetworkAclEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<AwsEc2NetworkAclEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<AwsEc2NetworkAclEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<AwsEc2NetworkAclEntry>)
         */
        Builder entries(Consumer<AwsEc2NetworkAclEntry.Builder>... entries);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isDefault;

        private String networkAclId;

        private String ownerId;

        private String vpcId;

        private List<AwsEc2NetworkAclAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEc2NetworkAclEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkAclDetails model) {
            isDefault(model.isDefault);
            networkAclId(model.networkAclId);
            ownerId(model.ownerId);
            vpcId(model.vpcId);
            associations(model.associations);
            entries(model.entries);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        @Transient
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        @Transient
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AwsEc2NetworkAclAssociation.Builder> getAssociations() {
            List<AwsEc2NetworkAclAssociation.Builder> result = AwsEc2NetworkAclAssociationListCopier
                    .copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<AwsEc2NetworkAclAssociation.BuilderImpl> associations) {
            this.associations = AwsEc2NetworkAclAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        @Transient
        public final Builder associations(Collection<AwsEc2NetworkAclAssociation> associations) {
            this.associations = AwsEc2NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associations(AwsEc2NetworkAclAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associations(Consumer<AwsEc2NetworkAclAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> AwsEc2NetworkAclAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEc2NetworkAclEntry.Builder> getEntries() {
            List<AwsEc2NetworkAclEntry.Builder> result = AwsEc2NetworkAclEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<AwsEc2NetworkAclEntry.BuilderImpl> entries) {
            this.entries = AwsEc2NetworkAclEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        @Transient
        public final Builder entries(Collection<AwsEc2NetworkAclEntry> entries) {
            this.entries = AwsEc2NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(AwsEc2NetworkAclEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(Consumer<AwsEc2NetworkAclEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> AwsEc2NetworkAclEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEc2NetworkAclDetails build() {
            return new AwsEc2NetworkAclDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
