/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the service configuration for a VPC endpoint service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpcEndpointServiceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpcEndpointServiceDetails.Builder, AwsEc2VpcEndpointServiceDetails> {
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired").getter(getter(AwsEc2VpcEndpointServiceDetails::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").build())
            .build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsEc2VpcEndpointServiceDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BaseEndpointDnsNames")
            .getter(getter(AwsEc2VpcEndpointServiceDetails::baseEndpointDnsNames))
            .setter(setter(Builder::baseEndpointDnsNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManagesVpcEndpoints").getter(getter(AwsEc2VpcEndpointServiceDetails::managesVpcEndpoints))
            .setter(setter(Builder::managesVpcEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints").build())
            .build();

    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatewayLoadBalancerArns")
            .getter(getter(AwsEc2VpcEndpointServiceDetails::gatewayLoadBalancerArns))
            .setter(setter(Builder::gatewayLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkLoadBalancerArns")
            .getter(getter(AwsEc2VpcEndpointServiceDetails::networkLoadBalancerArns))
            .setter(setter(Builder::networkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName").getter(getter(AwsEc2VpcEndpointServiceDetails::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(AwsEc2VpcEndpointServiceDetails::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(AwsEc2VpcEndpointServiceDetails::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceState").getter(getter(AwsEc2VpcEndpointServiceDetails::serviceState))
            .setter(setter(Builder::serviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState").build()).build();

    private static final SdkField<List<AwsEc2VpcEndpointServiceServiceTypeDetails>> SERVICE_TYPE_FIELD = SdkField
            .<List<AwsEc2VpcEndpointServiceServiceTypeDetails>> builder(MarshallingType.LIST)
            .memberName("ServiceType")
            .getter(getter(AwsEc2VpcEndpointServiceDetails::serviceType))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VpcEndpointServiceServiceTypeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VpcEndpointServiceServiceTypeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_REQUIRED_FIELD,
            AVAILABILITY_ZONES_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, MANAGES_VPC_ENDPOINTS_FIELD,
            GATEWAY_LOAD_BALANCER_ARNS_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, PRIVATE_DNS_NAME_FIELD, SERVICE_ID_FIELD,
            SERVICE_NAME_FIELD, SERVICE_STATE_FIELD, SERVICE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean acceptanceRequired;

    private final List<String> availabilityZones;

    private final List<String> baseEndpointDnsNames;

    private final Boolean managesVpcEndpoints;

    private final List<String> gatewayLoadBalancerArns;

    private final List<String> networkLoadBalancerArns;

    private final String privateDnsName;

    private final String serviceId;

    private final String serviceName;

    private final String serviceState;

    private final List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType;

    private AwsEc2VpcEndpointServiceDetails(BuilderImpl builder) {
        this.acceptanceRequired = builder.acceptanceRequired;
        this.availabilityZones = builder.availabilityZones;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.privateDnsName = builder.privateDnsName;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceState = builder.serviceState;
        this.serviceType = builder.serviceType;
    }

    /**
     * <p>
     * Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be
     * accepted.
     * </p>
     * 
     * @return Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first
     *         be accepted.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones where the service is available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones where the service is available.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaseEndpointDnsNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBaseEndpointDnsNames() {
        return baseEndpointDnsNames != null && !(baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS names for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaseEndpointDnsNames} method.
     * </p>
     * 
     * @return The DNS names for the service.
     */
    public final List<String> baseEndpointDnsNames() {
        return baseEndpointDnsNames;
    }

    /**
     * <p>
     * Whether the service manages its VPC endpoints.
     * </p>
     * 
     * @return Whether the service manages its VPC endpoints.
     */
    public final Boolean managesVpcEndpoints() {
        return managesVpcEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns != null && !(gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the Gateway Load Balancers for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayLoadBalancerArns} method.
     * </p>
     * 
     * @return The ARNs of the Gateway Load Balancers for the service.
     */
    public final List<String> gatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkLoadBalancerArns() {
        return networkLoadBalancerArns != null && !(networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the Network Load Balancers for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkLoadBalancerArns} method.
     * </p>
     * 
     * @return The ARNs of the Network Load Balancers for the service.
     */
    public final List<String> networkLoadBalancerArns() {
        return networkLoadBalancerArns;
    }

    /**
     * <p>
     * The private DNS name for the service.
     * </p>
     * 
     * @return The private DNS name for the service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The identifier of the service.
     * </p>
     * 
     * @return The identifier of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The current state of the service.
     * </p>
     * 
     * @return The current state of the service.
     */
    public final String serviceState() {
        return serviceState;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceType() {
        return serviceType != null && !(serviceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceType} method.
     * </p>
     * 
     * @return The types for the service.
     */
    public final List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType() {
        return serviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceState());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceType() ? serviceType() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcEndpointServiceDetails)) {
            return false;
        }
        AwsEc2VpcEndpointServiceDetails other = (AwsEc2VpcEndpointServiceDetails) obj;
        return Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames()
                && Objects.equals(baseEndpointDnsNames(), other.baseEndpointDnsNames())
                && Objects.equals(managesVpcEndpoints(), other.managesVpcEndpoints())
                && hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns()
                && Objects.equals(gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns())
                && hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns()
                && Objects.equals(networkLoadBalancerArns(), other.networkLoadBalancerArns())
                && Objects.equals(privateDnsName(), other.privateDnsName()) && Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceState(), other.serviceState())
                && hasServiceType() == other.hasServiceType() && Objects.equals(serviceType(), other.serviceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpcEndpointServiceDetails").add("AcceptanceRequired", acceptanceRequired())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("BaseEndpointDnsNames", hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null)
                .add("ManagesVpcEndpoints", managesVpcEndpoints())
                .add("GatewayLoadBalancerArns", hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null)
                .add("NetworkLoadBalancerArns", hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null)
                .add("PrivateDnsName", privateDnsName()).add("ServiceId", serviceId()).add("ServiceName", serviceName())
                .add("ServiceState", serviceState()).add("ServiceType", hasServiceType() ? serviceType() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "BaseEndpointDnsNames":
            return Optional.ofNullable(clazz.cast(baseEndpointDnsNames()));
        case "ManagesVpcEndpoints":
            return Optional.ofNullable(clazz.cast(managesVpcEndpoints()));
        case "GatewayLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(gatewayLoadBalancerArns()));
        case "NetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(networkLoadBalancerArns()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceState":
            return Optional.ofNullable(clazz.cast(serviceState()));
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcEndpointServiceDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcEndpointServiceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpcEndpointServiceDetails> {
        /**
         * <p>
         * Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be
         * accepted.
         * </p>
         * 
         * @param acceptanceRequired
         *        Whether requests from other Amazon Web Services accounts to create an endpoint to the service must
         *        first be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * The Availability Zones where the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones where the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones where the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones where the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(String... baseEndpointDnsNames);

        /**
         * <p>
         * Whether the service manages its VPC endpoints.
         * </p>
         * 
         * @param managesVpcEndpoints
         *        Whether the service manages its VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managesVpcEndpoints(Boolean managesVpcEndpoints);

        /**
         * <p>
         * The ARNs of the Gateway Load Balancers for the service.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The ARNs of the Gateway Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns);

        /**
         * <p>
         * The ARNs of the Gateway Load Balancers for the service.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The ARNs of the Gateway Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns);

        /**
         * <p>
         * The ARNs of the Network Load Balancers for the service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The ARNs of the Network Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns);

        /**
         * <p>
         * The ARNs of the Network Load Balancers for the service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The ARNs of the Network Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(String... networkLoadBalancerArns);

        /**
         * <p>
         * The private DNS name for the service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The identifier of the service.
         * </p>
         * 
         * @param serviceId
         *        The identifier of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param serviceName
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The current state of the service.
         * </p>
         * 
         * @param serviceState
         *        The current state of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceState(String serviceState);

        /**
         * <p>
         * The types for the service.
         * </p>
         * 
         * @param serviceType
         *        The types for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType);

        /**
         * <p>
         * The types for the service.
         * </p>
         * 
         * @param serviceType
         *        The types for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(AwsEc2VpcEndpointServiceServiceTypeDetails... serviceType);

        /**
         * <p>
         * The types for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEc2VpcEndpointServiceServiceTypeDetails>.Builder} avoiding the need to create one manually via
         * {@link List<AwsEc2VpcEndpointServiceServiceTypeDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2VpcEndpointServiceServiceTypeDetails>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #serviceType(List<AwsEc2VpcEndpointServiceServiceTypeDetails>)}.
         * 
         * @param serviceType
         *        a consumer that will call methods on {@link List<AwsEc2VpcEndpointServiceServiceTypeDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceType(List<AwsEc2VpcEndpointServiceServiceTypeDetails>)
         */
        Builder serviceType(Consumer<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder>... serviceType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean acceptanceRequired;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean managesVpcEndpoints;

        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private String privateDnsName;

        private String serviceId;

        private String serviceName;

        private String serviceState;

        private List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcEndpointServiceDetails model) {
            acceptanceRequired(model.acceptanceRequired);
            availabilityZones(model.availabilityZones);
            baseEndpointDnsNames(model.baseEndpointDnsNames);
            managesVpcEndpoints(model.managesVpcEndpoints);
            gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            networkLoadBalancerArns(model.networkLoadBalancerArns);
            privateDnsName(model.privateDnsName);
            serviceId(model.serviceId);
            serviceName(model.serviceName);
            serviceState(model.serviceState);
            serviceType(model.serviceType);
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        @Transient
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = NonEmptyStringListCopier.copy(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = NonEmptyStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return baseEndpointDnsNames;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = NonEmptyStringListCopier.copy(baseEndpointDnsNames);
        }

        @Override
        @Transient
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = NonEmptyStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String... baseEndpointDnsNames) {
            baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final Boolean getManagesVpcEndpoints() {
            return managesVpcEndpoints;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        @Override
        @Transient
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayLoadBalancerArns;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = NonEmptyStringListCopier.copy(gatewayLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = NonEmptyStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns) {
            gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return networkLoadBalancerArns;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = NonEmptyStringListCopier.copy(networkLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = NonEmptyStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String... networkLoadBalancerArns) {
            networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceState() {
            return serviceState;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        @Override
        @Transient
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        public final List<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> getServiceType() {
            List<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> result = AwsEc2VpcEndpointServiceServiceTypeListCopier
                    .copyToBuilder(this.serviceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails.BuilderImpl> serviceType) {
            this.serviceType = AwsEc2VpcEndpointServiceServiceTypeListCopier.copyFromBuilder(serviceType);
        }

        @Override
        @Transient
        public final Builder serviceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType) {
            this.serviceType = AwsEc2VpcEndpointServiceServiceTypeListCopier.copy(serviceType);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceType(AwsEc2VpcEndpointServiceServiceTypeDetails... serviceType) {
            serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceType(Consumer<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder>... serviceType) {
            serviceType(Stream.of(serviceType)
                    .map(c -> AwsEc2VpcEndpointServiceServiceTypeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEc2VpcEndpointServiceDetails build() {
            return new AwsEc2VpcEndpointServiceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
