/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon Elastic Container Registry repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrRepositoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrRepositoryDetails.Builder, AwsEcrRepositoryDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsEcrRepositoryDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<AwsEcrRepositoryImageScanningConfigurationDetails> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<AwsEcrRepositoryImageScanningConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImageScanningConfiguration")
            .getter(getter(AwsEcrRepositoryDetails::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(AwsEcrRepositoryImageScanningConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanningConfiguration").build())
            .build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageTagMutability").getter(getter(AwsEcrRepositoryDetails::imageTagMutability))
            .setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageTagMutability").build())
            .build();

    private static final SdkField<AwsEcrRepositoryLifecyclePolicyDetails> LIFECYCLE_POLICY_FIELD = SdkField
            .<AwsEcrRepositoryLifecyclePolicyDetails> builder(MarshallingType.SDK_POJO).memberName("LifecyclePolicy")
            .getter(getter(AwsEcrRepositoryDetails::lifecyclePolicy)).setter(setter(Builder::lifecyclePolicy))
            .constructor(AwsEcrRepositoryLifecyclePolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicy").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryName").getter(getter(AwsEcrRepositoryDetails::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryPolicyText").getter(getter(AwsEcrRepositoryDetails::repositoryPolicyText))
            .setter(setter(Builder::repositoryPolicyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryPolicyText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            IMAGE_SCANNING_CONFIGURATION_FIELD, IMAGE_TAG_MUTABILITY_FIELD, LIFECYCLE_POLICY_FIELD, REPOSITORY_NAME_FIELD,
            REPOSITORY_POLICY_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final AwsEcrRepositoryImageScanningConfigurationDetails imageScanningConfiguration;

    private final String imageTagMutability;

    private final AwsEcrRepositoryLifecyclePolicyDetails lifecyclePolicy;

    private final String repositoryName;

    private final String repositoryPolicyText;

    private AwsEcrRepositoryDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.imageTagMutability = builder.imageTagMutability;
        this.lifecyclePolicy = builder.lifecyclePolicy;
        this.repositoryName = builder.repositoryName;
        this.repositoryPolicyText = builder.repositoryPolicyText;
    }

    /**
     * <p>
     * The ARN of the repository.
     * </p>
     * 
     * @return The ARN of the repository.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The image scanning configuration for a repository.
     * </p>
     * 
     * @return The image scanning configuration for a repository.
     */
    public final AwsEcrRepositoryImageScanningConfigurationDetails imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    /**
     * <p>
     * The tag mutability setting for the repository.
     * </p>
     * 
     * @return The tag mutability setting for the repository.
     */
    public final String imageTagMutability() {
        return imageTagMutability;
    }

    /**
     * <p>
     * Information about the lifecycle policy for the repository.
     * </p>
     * 
     * @return Information about the lifecycle policy for the repository.
     */
    public final AwsEcrRepositoryLifecyclePolicyDetails lifecyclePolicy() {
        return lifecyclePolicy;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The text of the repository policy.
     * </p>
     * 
     * @return The text of the repository policy.
     */
    public final String repositoryPolicyText() {
        return repositoryPolicyText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutability());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryPolicyText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrRepositoryDetails)) {
            return false;
        }
        AwsEcrRepositoryDetails other = (AwsEcrRepositoryDetails) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration())
                && Objects.equals(imageTagMutability(), other.imageTagMutability())
                && Objects.equals(lifecyclePolicy(), other.lifecyclePolicy())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryPolicyText(), other.repositoryPolicyText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrRepositoryDetails").add("Arn", arn())
                .add("ImageScanningConfiguration", imageScanningConfiguration()).add("ImageTagMutability", imageTagMutability())
                .add("LifecyclePolicy", lifecyclePolicy()).add("RepositoryName", repositoryName())
                .add("RepositoryPolicyText", repositoryPolicyText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ImageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        case "ImageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutability()));
        case "LifecyclePolicy":
            return Optional.ofNullable(clazz.cast(lifecyclePolicy()));
        case "RepositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "RepositoryPolicyText":
            return Optional.ofNullable(clazz.cast(repositoryPolicyText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrRepositoryDetails, T> g) {
        return obj -> g.apply((AwsEcrRepositoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrRepositoryDetails> {
        /**
         * <p>
         * The ARN of the repository.
         * </p>
         * 
         * @param arn
         *        The ARN of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The image scanning configuration for a repository.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        The image scanning configuration for a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(AwsEcrRepositoryImageScanningConfigurationDetails imageScanningConfiguration);

        /**
         * <p>
         * The image scanning configuration for a repository.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcrRepositoryImageScanningConfigurationDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEcrRepositoryImageScanningConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcrRepositoryImageScanningConfigurationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #imageScanningConfiguration(AwsEcrRepositoryImageScanningConfigurationDetails)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link AwsEcrRepositoryImageScanningConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(AwsEcrRepositoryImageScanningConfigurationDetails)
         */
        default Builder imageScanningConfiguration(
                Consumer<AwsEcrRepositoryImageScanningConfigurationDetails.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(AwsEcrRepositoryImageScanningConfigurationDetails.builder()
                    .applyMutation(imageScanningConfiguration).build());
        }

        /**
         * <p>
         * The tag mutability setting for the repository.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * Information about the lifecycle policy for the repository.
         * </p>
         * 
         * @param lifecyclePolicy
         *        Information about the lifecycle policy for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails lifecyclePolicy);

        /**
         * <p>
         * Information about the lifecycle policy for the repository.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEcrRepositoryLifecyclePolicyDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcrRepositoryLifecyclePolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEcrRepositoryLifecyclePolicyDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails)}.
         * 
         * @param lifecyclePolicy
         *        a consumer that will call methods on {@link AwsEcrRepositoryLifecyclePolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails)
         */
        default Builder lifecyclePolicy(Consumer<AwsEcrRepositoryLifecyclePolicyDetails.Builder> lifecyclePolicy) {
            return lifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails.builder().applyMutation(lifecyclePolicy).build());
        }

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The text of the repository policy.
         * </p>
         * 
         * @param repositoryPolicyText
         *        The text of the repository policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryPolicyText(String repositoryPolicyText);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private AwsEcrRepositoryImageScanningConfigurationDetails imageScanningConfiguration;

        private String imageTagMutability;

        private AwsEcrRepositoryLifecyclePolicyDetails lifecyclePolicy;

        private String repositoryName;

        private String repositoryPolicyText;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrRepositoryDetails model) {
            arn(model.arn);
            imageScanningConfiguration(model.imageScanningConfiguration);
            imageTagMutability(model.imageTagMutability);
            lifecyclePolicy(model.lifecyclePolicy);
            repositoryName(model.repositoryName);
            repositoryPolicyText(model.repositoryPolicyText);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AwsEcrRepositoryImageScanningConfigurationDetails.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(
                AwsEcrRepositoryImageScanningConfigurationDetails.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder imageScanningConfiguration(
                AwsEcrRepositoryImageScanningConfigurationDetails imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final String getImageTagMutability() {
            return imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        @Transient
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        public final AwsEcrRepositoryLifecyclePolicyDetails.Builder getLifecyclePolicy() {
            return lifecyclePolicy != null ? lifecyclePolicy.toBuilder() : null;
        }

        public final void setLifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails.BuilderImpl lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy != null ? lifecyclePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder lifecyclePolicy(AwsEcrRepositoryLifecyclePolicyDetails lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryPolicyText() {
            return repositoryPolicyText;
        }

        public final void setRepositoryPolicyText(String repositoryPolicyText) {
            this.repositoryPolicyText = repositoryPolicyText;
        }

        @Override
        @Transient
        public final Builder repositoryPolicyText(String repositoryPolicyText) {
            this.repositoryPolicyText = repositoryPolicyText;
            return this;
        }

        @Override
        public AwsEcrRepositoryDetails build() {
            return new AwsEcrRepositoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
