/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * provides details about an ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsClusterDetails.Builder, AwsEcsClusterDetails> {
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CapacityProviders")
            .getter(getter(AwsEcsClusterDetails::capacityProviders))
            .setter(setter(Builder::capacityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsClusterClusterSettingsDetails>> CLUSTER_SETTINGS_FIELD = SdkField
            .<List<AwsEcsClusterClusterSettingsDetails>> builder(MarshallingType.LIST)
            .memberName("ClusterSettings")
            .getter(getter(AwsEcsClusterDetails::clusterSettings))
            .setter(setter(Builder::clusterSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsClusterClusterSettingsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsClusterClusterSettingsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEcsClusterConfigurationDetails> CONFIGURATION_FIELD = SdkField
            .<AwsEcsClusterConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(AwsEcsClusterDetails::configuration)).setter(setter(Builder::configuration))
            .constructor(AwsEcsClusterConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>> builder(MarshallingType.LIST)
            .memberName("DefaultCapacityProviderStrategy")
            .getter(getter(AwsEcsClusterDetails::defaultCapacityProviderStrategy))
            .setter(setter(Builder::defaultCapacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCapacityProviderStrategy")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsClusterDefaultCapacityProviderStrategyDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsClusterDefaultCapacityProviderStrategyDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD,
            CLUSTER_SETTINGS_FIELD, CONFIGURATION_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> capacityProviders;

    private final List<AwsEcsClusterClusterSettingsDetails> clusterSettings;

    private final AwsEcsClusterConfigurationDetails configuration;

    private final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy;

    private AwsEcsClusterDetails(BuilderImpl builder) {
        this.capacityProviders = builder.capacityProviders;
        this.clusterSettings = builder.clusterSettings;
        this.configuration = builder.configuration;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityProviders() {
        return capacityProviders != null && !(capacityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The short name of one or more capacity providers to associate with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviders} method.
     * </p>
     * 
     * @return The short name of one or more capacity providers to associate with the cluster.
     */
    public final List<String> capacityProviders() {
        return capacityProviders;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterSettings() {
        return clusterSettings != null && !(clusterSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch Container
     * Insights for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSettings} method.
     * </p>
     * 
     * @return The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
     *         Container Insights for the cluster.
     */
    public final List<AwsEcsClusterClusterSettingsDetails> clusterSettings() {
        return clusterSettings;
    }

    /**
     * <p>
     * The run command configuration for the cluster.
     * </p>
     * 
     * @return The run command configuration for the cluster.
     */
    public final AwsEcsClusterConfigurationDetails configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultCapacityProviderStrategy
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDefaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy != null && !(defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when
     * services or tasks are run without a specified launch type or capacity provider strategy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultCapacityProviderStrategy}
     * method.
     * </p>
     * 
     * @return The default capacity provider strategy for the cluster. The default capacity provider strategy is used
     *         when services or tasks are run without a specified launch type or capacity provider strategy.
     */
    public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviders() ? capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterSettings() ? clusterSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterDetails)) {
            return false;
        }
        AwsEcsClusterDetails other = (AwsEcsClusterDetails) obj;
        return hasCapacityProviders() == other.hasCapacityProviders()
                && Objects.equals(capacityProviders(), other.capacityProviders())
                && hasClusterSettings() == other.hasClusterSettings()
                && Objects.equals(clusterSettings(), other.clusterSettings())
                && Objects.equals(configuration(), other.configuration())
                && hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy()
                && Objects.equals(defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsEcsClusterDetails")
                .add("CapacityProviders", hasCapacityProviders() ? capacityProviders() : null)
                .add("ClusterSettings", hasClusterSettings() ? clusterSettings() : null)
                .add("Configuration", configuration())
                .add("DefaultCapacityProviderStrategy",
                        hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviders":
            return Optional.ofNullable(clazz.cast(capacityProviders()));
        case "ClusterSettings":
            return Optional.ofNullable(clazz.cast(clusterSettings()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "DefaultCapacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(defaultCapacityProviderStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsClusterDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsClusterDetails> {
        /**
         * <p>
         * The short name of one or more capacity providers to associate with the cluster.
         * </p>
         * 
         * @param capacityProviders
         *        The short name of one or more capacity providers to associate with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(Collection<String> capacityProviders);

        /**
         * <p>
         * The short name of one or more capacity providers to associate with the cluster.
         * </p>
         * 
         * @param capacityProviders
         *        The short name of one or more capacity providers to associate with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(String... capacityProviders);

        /**
         * <p>
         * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
         * Container Insights for the cluster.
         * </p>
         * 
         * @param clusterSettings
         *        The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
         *        Container Insights for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> clusterSettings);

        /**
         * <p>
         * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
         * Container Insights for the cluster.
         * </p>
         * 
         * @param clusterSettings
         *        The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
         *        Container Insights for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSettings(AwsEcsClusterClusterSettingsDetails... clusterSettings);

        /**
         * <p>
         * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch
         * Container Insights for the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsClusterClusterSettingsDetails>.Builder} avoiding the need to create one manually via {@link List
         * <AwsEcsClusterClusterSettingsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEcsClusterClusterSettingsDetails>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #clusterSettings(List<AwsEcsClusterClusterSettingsDetails>)}.
         * 
         * @param clusterSettings
         *        a consumer that will call methods on {@link List<AwsEcsClusterClusterSettingsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSettings(List<AwsEcsClusterClusterSettingsDetails>)
         */
        Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder>... clusterSettings);

        /**
         * <p>
         * The run command configuration for the cluster.
         * </p>
         * 
         * @param configuration
         *        The run command configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AwsEcsClusterConfigurationDetails configuration);

        /**
         * <p>
         * The run command configuration for the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEcsClusterConfigurationDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcsClusterConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEcsClusterConfigurationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(AwsEcsClusterConfigurationDetails)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AwsEcsClusterConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AwsEcsClusterConfigurationDetails)
         */
        default Builder configuration(Consumer<AwsEcsClusterConfigurationDetails.Builder> configuration) {
            return configuration(AwsEcsClusterConfigurationDetails.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when
         * services or tasks are run without a specified launch type or capacity provider strategy.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The default capacity provider strategy for the cluster. The default capacity provider strategy is used
         *        when services or tasks are run without a specified launch type or capacity provider strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(
                Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy);

        /**
         * <p>
         * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when
         * services or tasks are run without a specified launch type or capacity provider strategy.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The default capacity provider strategy for the cluster. The default capacity provider strategy is used
         *        when services or tasks are run without a specified launch type or capacity provider strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(
                AwsEcsClusterDefaultCapacityProviderStrategyDetails... defaultCapacityProviderStrategy);

        /**
         * <p>
         * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when
         * services or tasks are run without a specified launch type or capacity provider strategy.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsClusterDefaultCapacityProviderStrategyDetails>.Builder} avoiding the need to create one manually via
         * {@link List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsClusterDefaultCapacityProviderStrategyDetails>.Builder#build()} is called immediately and its result
         * is passed to {@link
         * #defaultCapacityProviderStrategy(List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>)}.
         * 
         * @param defaultCapacityProviderStrategy
         *        a consumer that will call methods on {@link List
         *        <AwsEcsClusterDefaultCapacityProviderStrategyDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCapacityProviderStrategy(List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>)
         */
        Builder defaultCapacityProviderStrategy(
                Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder>... defaultCapacityProviderStrategy);
    }

    static final class BuilderImpl implements Builder {
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEcsClusterClusterSettingsDetails> clusterSettings = DefaultSdkAutoConstructList.getInstance();

        private AwsEcsClusterConfigurationDetails configuration;

        private List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterDetails model) {
            capacityProviders(model.capacityProviders);
            clusterSettings(model.clusterSettings);
            configuration(model.configuration);
            defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
        }

        public final Collection<String> getCapacityProviders() {
            if (capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
        }

        @Override
        @Transient
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder capacityProviders(String... capacityProviders) {
            capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final List<AwsEcsClusterClusterSettingsDetails.Builder> getClusterSettings() {
            List<AwsEcsClusterClusterSettingsDetails.Builder> result = AwsEcsClusterClusterSettingsListCopier
                    .copyToBuilder(this.clusterSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSettings(Collection<AwsEcsClusterClusterSettingsDetails.BuilderImpl> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copyFromBuilder(clusterSettings);
        }

        @Override
        @Transient
        public final Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copy(clusterSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSettings(AwsEcsClusterClusterSettingsDetails... clusterSettings) {
            clusterSettings(Arrays.asList(clusterSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder>... clusterSettings) {
            clusterSettings(Stream.of(clusterSettings)
                    .map(c -> AwsEcsClusterClusterSettingsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsClusterConfigurationDetails.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AwsEcsClusterConfigurationDetails.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(AwsEcsClusterConfigurationDetails configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> getDefaultCapacityProviderStrategy() {
            List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> result = AwsEcsClusterDefaultCapacityProviderStrategyListCopier
                    .copyToBuilder(this.defaultCapacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultCapacityProviderStrategy(
                Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier
                    .copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        @Transient
        public final Builder defaultCapacityProviderStrategy(
                Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier
                    .copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(
                AwsEcsClusterDefaultCapacityProviderStrategyDetails... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(
                Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder>... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy)
                    .map(c -> AwsEcsClusterDefaultCapacityProviderStrategyDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEcsClusterDetails build() {
            return new AwsEcsClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
