/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder, AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> {
    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignPublicIp")
            .getter(getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::assignPublicIp))
            .setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignPublicIp").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_PUBLIC_IP_FIELD,
            SECURITY_GROUPS_FIELD, SUBNETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assignPublicIp;

    private final List<String> securityGroups;

    private final List<String> subnets;

    private AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(BuilderImpl builder) {
        this.assignPublicIp = builder.assignPublicIp;
        this.securityGroups = builder.securityGroups;
        this.subnets = builder.subnets;
    }

    /**
     * <p>
     * Whether the task's elastic network interface receives a public IP address. The default value is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     * </p>
     * 
     * @return Whether the task's elastic network interface receives a public IP address. The default value is
     *         <code>DISABLED</code>.</p>
     *         <p>
     *         Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     */
    public final String assignPublicIp() {
        return assignPublicIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups associated with the task or service.
     * </p>
     * <p>
     * You can provide up to five security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The IDs of the security groups associated with the task or service.</p>
     *         <p>
     *         You can provide up to five security groups.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets associated with the task or service.
     * </p>
     * <p>
     * You can provide up to 16 subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the subnets associated with the task or service.</p>
     *         <p>
     *         You can provide up to 16 subnets.
     */
    public final List<String> subnets() {
        return subnets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)) {
            return false;
        }
        AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails other = (AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) obj;
        return Objects.equals(assignPublicIp(), other.assignPublicIp()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails")
                .add("AssignPublicIp", assignPublicIp()).add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("Subnets", hasSubnets() ? subnets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIp()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> {
        /**
         * <p>
         * Whether the task's elastic network interface receives a public IP address. The default value is
         * <code>DISABLED</code>.
         * </p>
         * <p>
         * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * </p>
         * 
         * @param assignPublicIp
         *        Whether the task's elastic network interface receives a public IP address. The default value is
         *        <code>DISABLED</code>.</p>
         *        <p>
         *        Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignPublicIp(String assignPublicIp);

        /**
         * <p>
         * The IDs of the security groups associated with the task or service.
         * </p>
         * <p>
         * You can provide up to five security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups associated with the task or service.</p>
         *        <p>
         *        You can provide up to five security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the security groups associated with the task or service.
         * </p>
         * <p>
         * You can provide up to five security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the security groups associated with the task or service.</p>
         *        <p>
         *        You can provide up to five security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The IDs of the subnets associated with the task or service.
         * </p>
         * <p>
         * You can provide up to 16 subnets.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets associated with the task or service.</p>
         *        <p>
         *        You can provide up to 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets associated with the task or service.
         * </p>
         * <p>
         * You can provide up to 16 subnets.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets associated with the task or service.</p>
         *        <p>
         *        You can provide up to 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);
    }

    static final class BuilderImpl implements Builder {
        private String assignPublicIp;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails model) {
            assignPublicIp(model.assignPublicIp);
            securityGroups(model.securityGroups);
            subnets(model.subnets);
        }

        public final String getAssignPublicIp() {
            return assignPublicIp;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        @Transient
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = NonEmptyStringListCopier.copy(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = NonEmptyStringListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        public AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails build() {
            return new AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
