/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceNetworkConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceNetworkConfigurationDetails.Builder, AwsEcsServiceNetworkConfigurationDetails> {
    private static final SdkField<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> AWS_VPC_CONFIGURATION_FIELD = SdkField
            .<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AwsVpcConfiguration").getter(getter(AwsEcsServiceNetworkConfigurationDetails::awsVpcConfiguration))
            .setter(setter(Builder::awsVpcConfiguration))
            .constructor(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVpcConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails awsVpcConfiguration;

    private AwsEcsServiceNetworkConfigurationDetails(BuilderImpl builder) {
        this.awsVpcConfiguration = builder.awsVpcConfiguration;
    }

    /**
     * <p>
     * The VPC subnet and security group configuration.
     * </p>
     * 
     * @return The VPC subnet and security group configuration.
     */
    public final AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails awsVpcConfiguration() {
        return awsVpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsVpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceNetworkConfigurationDetails)) {
            return false;
        }
        AwsEcsServiceNetworkConfigurationDetails other = (AwsEcsServiceNetworkConfigurationDetails) obj;
        return Objects.equals(awsVpcConfiguration(), other.awsVpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceNetworkConfigurationDetails").add("AwsVpcConfiguration", awsVpcConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsVpcConfiguration":
            return Optional.ofNullable(clazz.cast(awsVpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceNetworkConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceNetworkConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceNetworkConfigurationDetails> {
        /**
         * <p>
         * The VPC subnet and security group configuration.
         * </p>
         * 
         * @param awsVpcConfiguration
         *        The VPC subnet and security group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsVpcConfiguration(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails awsVpcConfiguration);

        /**
         * <p>
         * The VPC subnet and security group configuration.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #awsVpcConfiguration(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)}.
         * 
         * @param awsVpcConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsVpcConfiguration(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)
         */
        default Builder awsVpcConfiguration(
                Consumer<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder> awsVpcConfiguration) {
            return awsVpcConfiguration(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.builder()
                    .applyMutation(awsVpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails awsVpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceNetworkConfigurationDetails model) {
            awsVpcConfiguration(model.awsVpcConfiguration);
        }

        public final AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.Builder getAwsVpcConfiguration() {
            return awsVpcConfiguration != null ? awsVpcConfiguration.toBuilder() : null;
        }

        public final void setAwsVpcConfiguration(
                AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.BuilderImpl awsVpcConfiguration) {
            this.awsVpcConfiguration = awsVpcConfiguration != null ? awsVpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder awsVpcConfiguration(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails awsVpcConfiguration) {
            this.awsVpcConfiguration = awsVpcConfiguration;
            return this;
        }

        @Override
        public AwsEcsServiceNetworkConfigurationDetails build() {
            return new AwsEcsServiceNetworkConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
