/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container definition that describes a container in the task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsDetails> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Command")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Cpu")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>> DEPENDS_ON_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>> builder(MarshallingType.LIST)
            .memberName("DependsOn")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_NETWORKING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableNetworking").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::disableNetworking))
            .setter(setter(Builder::disableNetworking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableNetworking").build()).build();

    private static final SdkField<List<String>> DNS_SEARCH_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsSearchDomains")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::dnsSearchDomains))
            .setter(setter(Builder::dnsSearchDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSearchDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsServers")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::dnsServers))
            .setter(setter(Builder::dnsServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> DOCKER_LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DockerLabels")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::dockerLabels))
            .setter(setter(Builder::dockerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DockerLabels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> DOCKER_SECURITY_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DockerSecurityOptions")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::dockerSecurityOptions))
            .setter(setter(Builder::dockerSecurityOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DockerSecurityOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntryPoint")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::entryPoint))
            .setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryPoint").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>> ENVIRONMENT_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>> builder(MarshallingType.LIST)
            .memberName("Environment")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>> ENVIRONMENT_FILES_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>> builder(MarshallingType.LIST)
            .memberName("EnvironmentFiles")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::environmentFiles))
            .setter(setter(Builder::environmentFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Essential").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::essential))
            .setter(setter(Builder::essential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Essential").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>> EXTRA_HOSTS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>> builder(MarshallingType.LIST)
            .memberName("ExtraHosts")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::extraHosts))
            .setter(setter(Builder::extraHosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraHosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails> FIRELENS_CONFIGURATION_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("FirelensConfiguration")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::firelensConfiguration))
            .setter(setter(Builder::firelensConfiguration))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirelensConfiguration").build())
            .build();

    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails> HEALTH_CHECK_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails> builder(MarshallingType.SDK_POJO)
            .memberName("HealthCheck").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::healthCheck))
            .setter(setter(Builder::healthCheck))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::hostname))
            .setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Image")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Interactive").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::interactive))
            .setter(setter(Builder::interactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactive").build()).build();

    private static final SdkField<List<String>> LINKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Links")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails> LINUX_PARAMETERS_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LinuxParameters").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::linuxParameters))
            .setter(setter(Builder::linuxParameters))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxParameters").build()).build();

    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails> LOG_CONFIGURATION_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LogConfiguration").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::logConfiguration))
            .setter(setter(Builder::logConfiguration))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Memory").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::memory))
            .setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()).build();

    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryReservation").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::memoryReservation))
            .setter(setter(Builder::memoryReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryReservation").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>> MOUNT_POINTS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>> builder(MarshallingType.LIST)
            .memberName("MountPoints")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::mountPoints))
            .setter(setter(Builder::mountPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>> PORT_MAPPINGS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>> builder(MarshallingType.LIST)
            .memberName("PortMappings")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::portMappings))
            .setter(setter(Builder::portMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Privileged").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::privileged))
            .setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()).build();

    private static final SdkField<Boolean> PSEUDO_TERMINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PseudoTerminal").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::pseudoTerminal))
            .setter(setter(Builder::pseudoTerminal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PseudoTerminal").build()).build();

    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadonlyRootFilesystem")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::readonlyRootFilesystem))
            .setter(setter(Builder::readonlyRootFilesystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadonlyRootFilesystem").build())
            .build();

    private static final SdkField<AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails> REPOSITORY_CREDENTIALS_FIELD = SdkField
            .<AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("RepositoryCredentials")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::repositoryCredentials))
            .setter(setter(Builder::repositoryCredentials))
            .constructor(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryCredentials").build())
            .build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>> RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>> builder(MarshallingType.LIST)
            .memberName("ResourceRequirements")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::resourceRequirements))
            .setter(setter(Builder::resourceRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>> SECRETS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>> builder(MarshallingType.LIST)
            .memberName("Secrets")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::secrets))
            .setter(setter(Builder::secrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secrets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> START_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartTimeout").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::startTimeout))
            .setter(setter(Builder::startTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeout").build()).build();

    private static final SdkField<Integer> STOP_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StopTimeout").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::stopTimeout))
            .setter(setter(Builder::stopTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTimeout").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>> SYSTEM_CONTROLS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>> builder(MarshallingType.LIST)
            .memberName("SystemControls")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::systemControls))
            .setter(setter(Builder::systemControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>> ULIMITS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>> builder(MarshallingType.LIST)
            .memberName("Ulimits")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::ulimits))
            .setter(setter(Builder::ulimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ulimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>> VOLUMES_FROM_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>> builder(MarshallingType.LIST)
            .memberName("VolumesFrom")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::volumesFrom))
            .setter(setter(Builder::volumesFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumesFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkingDirectory").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDetails::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, CPU_FIELD,
            DEPENDS_ON_FIELD, DISABLE_NETWORKING_FIELD, DNS_SEARCH_DOMAINS_FIELD, DNS_SERVERS_FIELD, DOCKER_LABELS_FIELD,
            DOCKER_SECURITY_OPTIONS_FIELD, ENTRY_POINT_FIELD, ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, ESSENTIAL_FIELD,
            EXTRA_HOSTS_FIELD, FIRELENS_CONFIGURATION_FIELD, HEALTH_CHECK_FIELD, HOSTNAME_FIELD, IMAGE_FIELD, INTERACTIVE_FIELD,
            LINKS_FIELD, LINUX_PARAMETERS_FIELD, LOG_CONFIGURATION_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD,
            MOUNT_POINTS_FIELD, NAME_FIELD, PORT_MAPPINGS_FIELD, PRIVILEGED_FIELD, PSEUDO_TERMINAL_FIELD,
            READONLY_ROOT_FILESYSTEM_FIELD, REPOSITORY_CREDENTIALS_FIELD, RESOURCE_REQUIREMENTS_FIELD, SECRETS_FIELD,
            START_TIMEOUT_FIELD, STOP_TIMEOUT_FIELD, SYSTEM_CONTROLS_FIELD, ULIMITS_FIELD, USER_FIELD, VOLUMES_FROM_FIELD,
            WORKING_DIRECTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> command;

    private final Integer cpu;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> dependsOn;

    private final Boolean disableNetworking;

    private final List<String> dnsSearchDomains;

    private final List<String> dnsServers;

    private final Map<String, String> dockerLabels;

    private final List<String> dockerSecurityOptions;

    private final List<String> entryPoint;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> environment;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> environmentFiles;

    private final Boolean essential;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> extraHosts;

    private final AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails firelensConfiguration;

    private final AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails healthCheck;

    private final String hostname;

    private final String image;

    private final Boolean interactive;

    private final List<String> links;

    private final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails linuxParameters;

    private final AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails logConfiguration;

    private final Integer memory;

    private final Integer memoryReservation;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> mountPoints;

    private final String name;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> portMappings;

    private final Boolean privileged;

    private final Boolean pseudoTerminal;

    private final Boolean readonlyRootFilesystem;

    private final AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails repositoryCredentials;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> resourceRequirements;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> secrets;

    private final Integer startTimeout;

    private final Integer stopTimeout;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> systemControls;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> ulimits;

    private final String user;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> volumesFrom;

    private final String workingDirectory;

    private AwsEcsTaskDefinitionContainerDefinitionsDetails(BuilderImpl builder) {
        this.command = builder.command;
        this.cpu = builder.cpu;
        this.dependsOn = builder.dependsOn;
        this.disableNetworking = builder.disableNetworking;
        this.dnsSearchDomains = builder.dnsSearchDomains;
        this.dnsServers = builder.dnsServers;
        this.dockerLabels = builder.dockerLabels;
        this.dockerSecurityOptions = builder.dockerSecurityOptions;
        this.entryPoint = builder.entryPoint;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.essential = builder.essential;
        this.extraHosts = builder.extraHosts;
        this.firelensConfiguration = builder.firelensConfiguration;
        this.healthCheck = builder.healthCheck;
        this.hostname = builder.hostname;
        this.image = builder.image;
        this.interactive = builder.interactive;
        this.links = builder.links;
        this.linuxParameters = builder.linuxParameters;
        this.logConfiguration = builder.logConfiguration;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.mountPoints = builder.mountPoints;
        this.name = builder.name;
        this.portMappings = builder.portMappings;
        this.privileged = builder.privileged;
        this.pseudoTerminal = builder.pseudoTerminal;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.resourceRequirements = builder.resourceRequirements;
        this.secrets = builder.secrets;
        this.startTimeout = builder.startTimeout;
        this.stopTimeout = builder.stopTimeout;
        this.systemControls = builder.systemControls;
        this.ulimits = builder.ulimits;
        this.user = builder.user;
        this.volumesFrom = builder.volumesFrom;
        this.workingDirectory = builder.workingDirectory;
    }

    /**
     * For responses, this returns true if the service returned a value for the Command property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command that is passed to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommand} method.
     * </p>
     * 
     * @return The command that is passed to the container.
     */
    public final List<String> command() {
        return command;
    }

    /**
     * <p>
     * The number of CPU units reserved for the container.
     * </p>
     * 
     * @return The number of CPU units reserved for the container.
     */
    public final Integer cpu() {
        return cpu;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependsOn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dependencies that are defined for container startup and shutdown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependsOn} method.
     * </p>
     * 
     * @return The dependencies that are defined for container startup and shutdown.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * Whether to disable networking within the container.
     * </p>
     * 
     * @return Whether to disable networking within the container.
     */
    public final Boolean disableNetworking() {
        return disableNetworking;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsSearchDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDnsSearchDomains() {
        return dnsSearchDomains != null && !(dnsSearchDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS search domains that are presented to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsSearchDomains} method.
     * </p>
     * 
     * @return A list of DNS search domains that are presented to the container.
     */
    public final List<String> dnsSearchDomains() {
        return dnsSearchDomains;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsServers() {
        return dnsServers != null && !(dnsServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS servers that are presented to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsServers} method.
     * </p>
     * 
     * @return A list of DNS servers that are presented to the container.
     */
    public final List<String> dnsServers() {
        return dnsServers;
    }

    /**
     * For responses, this returns true if the service returned a value for the DockerLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDockerLabels() {
        return dockerLabels != null && !(dockerLabels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of labels to add to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDockerLabels} method.
     * </p>
     * 
     * @return A key-value map of labels to add to the container.
     */
    public final Map<String, String> dockerLabels() {
        return dockerLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the DockerSecurityOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDockerSecurityOptions() {
        return dockerSecurityOptions != null && !(dockerSecurityOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDockerSecurityOptions} method.
     * </p>
     * 
     * @return A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
     */
    public final List<String> dockerSecurityOptions() {
        return dockerSecurityOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntryPoint property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntryPoint() {
        return entryPoint != null && !(entryPoint instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entry point that is passed to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntryPoint} method.
     * </p>
     * 
     * @return The entry point that is passed to the container.
     */
    public final List<String> entryPoint() {
        return entryPoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to pass to a container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to pass to a container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> environment() {
        return environment;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentFiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentFiles() {
        return environmentFiles != null && !(environmentFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of files containing the environment variables to pass to a container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentFiles} method.
     * </p>
     * 
     * @return A list of files containing the environment variables to pass to a container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> environmentFiles() {
        return environmentFiles;
    }

    /**
     * <p>
     * Whether the container is essential. All tasks must have at least one essential container.
     * </p>
     * 
     * @return Whether the container is essential. All tasks must have at least one essential container.
     */
    public final Boolean essential() {
        return essential;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtraHosts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExtraHosts() {
        return extraHosts != null && !(extraHosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtraHosts} method.
     * </p>
     * 
     * @return A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> extraHosts() {
        return extraHosts;
    }

    /**
     * <p>
     * The FireLens configuration for the container. Specifies and configures a log router for container logs.
     * </p>
     * 
     * @return The FireLens configuration for the container. Specifies and configures a log router for container logs.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails firelensConfiguration() {
        return firelensConfiguration;
    }

    /**
     * <p>
     * The container health check command and associated configuration parameters for the container.
     * </p>
     * 
     * @return The container health check command and associated configuration parameters for the container.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails healthCheck() {
        return healthCheck;
    }

    /**
     * <p>
     * The hostname to use for the container.
     * </p>
     * 
     * @return The hostname to use for the container.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The image used to start the container.
     * </p>
     * 
     * @return The image used to start the container.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * If set to true, then containerized applications can be deployed that require <code>stdin</code> or a
     * <code>tty</code> to be allocated.
     * </p>
     * 
     * @return If set to true, then containerized applications can be deployed that require <code>stdin</code> or a
     *         <code>tty</code> to be allocated.
     */
    public final Boolean interactive() {
        return interactive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Links property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>. Allows
     * containers to communicate with each other without the need for port mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinks} method.
     * </p>
     * 
     * @return A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>. Allows
     *         containers to communicate with each other without the need for port mappings.
     */
    public final List<String> links() {
        return links;
    }

    /**
     * <p>
     * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     * </p>
     * 
     * @return Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails linuxParameters() {
        return linuxParameters;
    }

    /**
     * <p>
     * The log configuration specification for the container.
     * </p>
     * 
     * @return The log configuration specification for the container.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory
     * specified here, the container is shut down. The total amount of memory reserved for all containers within a task
     * must be lower than the task memory value, if one is specified.
     * </p>
     * 
     * @return The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory
     *         specified here, the container is shut down. The total amount of memory reserved for all containers within
     *         a task must be lower than the task memory value, if one is specified.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The soft limit (in MiB) of memory to reserve for the container.
     * </p>
     * 
     * @return The soft limit (in MiB) of memory to reserve for the container.
     */
    public final Integer memoryReservation() {
        return memoryReservation;
    }

    /**
     * For responses, this returns true if the service returned a value for the MountPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMountPoints() {
        return mountPoints != null && !(mountPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mount points for the data volumes in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMountPoints} method.
     * </p>
     * 
     * @return The mount points for the data volumes in the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> mountPoints() {
        return mountPoints;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPortMappings() {
        return portMappings != null && !(portMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of port mappings for the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortMappings} method.
     * </p>
     * 
     * @return The list of port mappings for the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> portMappings() {
        return portMappings;
    }

    /**
     * <p>
     * Whether the container is given elevated privileges on the host container instance. The elevated privileges are
     * similar to the root user.
     * </p>
     * 
     * @return Whether the container is given elevated privileges on the host container instance. The elevated
     *         privileges are similar to the root user.
     */
    public final Boolean privileged() {
        return privileged;
    }

    /**
     * <p>
     * Whether to allocate a TTY to the container.
     * </p>
     * 
     * @return Whether to allocate a TTY to the container.
     */
    public final Boolean pseudoTerminal() {
        return pseudoTerminal;
    }

    /**
     * <p>
     * Whether the container is given read-only access to its root file system.
     * </p>
     * 
     * @return Whether the container is given read-only access to its root file system.
     */
    public final Boolean readonlyRootFilesystem() {
        return readonlyRootFilesystem;
    }

    /**
     * <p>
     * The private repository authentication credentials to use.
     * </p>
     * 
     * @return The private repository authentication credentials to use.
     */
    public final AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails repositoryCredentials() {
        return repositoryCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRequirements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceRequirements() {
        return resourceRequirements != null && !(resourceRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRequirements} method.
     * </p>
     * 
     * @return The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> resourceRequirements() {
        return resourceRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Secrets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSecrets() {
        return secrets != null && !(secrets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secrets to pass to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecrets} method.
     * </p>
     * 
     * @return The secrets to pass to the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> secrets() {
        return secrets;
    }

    /**
     * <p>
     * The number of seconds to wait before giving up on resolving dependencies for a container.
     * </p>
     * 
     * @return The number of seconds to wait before giving up on resolving dependencies for a container.
     */
    public final Integer startTimeout() {
        return startTimeout;
    }

    /**
     * <p>
     * The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.
     * </p>
     * 
     * @return The number of seconds to wait before the container is stopped if it doesn't shut down normally on its
     *         own.
     */
    public final Integer stopTimeout() {
        return stopTimeout;
    }

    /**
     * For responses, this returns true if the service returned a value for the SystemControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSystemControls() {
        return systemControls != null && !(systemControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of namespaced kernel parameters to set in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystemControls} method.
     * </p>
     * 
     * @return A list of namespaced kernel parameters to set in the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> systemControls() {
        return systemControls;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ulimits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUlimits() {
        return ulimits != null && !(ulimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ulimits to set in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUlimits} method.
     * </p>
     * 
     * @return A list of ulimits to set in the container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> ulimits() {
        return ulimits;
    }

    /**
     * <p>
     * The user to use inside the container.
     * </p>
     * <p>
     * The value can use one of the following formats.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code> <i>user</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>user</i> </code>:<code> <i>group</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>uid</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>uid</i> </code>:<code> <i>gid</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>user</i> </code>:<code> <i>gid</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>uid</i> </code>:<code> <i>group</i> </code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The user to use inside the container.</p>
     *         <p>
     *         The value can use one of the following formats.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code> <i>user</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>user</i> </code>:<code> <i>group</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>uid</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>uid</i> </code>:<code> <i>gid</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>user</i> </code>:<code> <i>gid</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>uid</i> </code>:<code> <i>group</i> </code>
     *         </p>
     *         </li>
     */
    public final String user() {
        return user;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumesFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumesFrom() {
        return volumesFrom != null && !(volumesFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data volumes to mount from another container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumesFrom} method.
     * </p>
     * 
     * @return Data volumes to mount from another container.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> volumesFrom() {
        return volumesFrom;
    }

    /**
     * <p>
     * The working directory in which to run commands inside the container.
     * </p>
     * 
     * @return The working directory in which to run commands inside the container.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependsOn() ? dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableNetworking());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsSearchDomains() ? dnsSearchDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsServers() ? dnsServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDockerLabels() ? dockerLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDockerSecurityOptions() ? dockerSecurityOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntryPoint() ? entryPoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentFiles() ? environmentFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(essential());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtraHosts() ? extraHosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firelensConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(interactive());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(hasMountPoints() ? mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortMappings() ? portMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        hashCode = 31 * hashCode + Objects.hashCode(pseudoTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRequirements() ? resourceRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecrets() ? secrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(stopTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(hasSystemControls() ? systemControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUlimits() ? ulimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumesFrom() ? volumesFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsDetails) obj;
        return hasCommand() == other.hasCommand() && Objects.equals(command(), other.command())
                && Objects.equals(cpu(), other.cpu()) && hasDependsOn() == other.hasDependsOn()
                && Objects.equals(dependsOn(), other.dependsOn())
                && Objects.equals(disableNetworking(), other.disableNetworking())
                && hasDnsSearchDomains() == other.hasDnsSearchDomains()
                && Objects.equals(dnsSearchDomains(), other.dnsSearchDomains()) && hasDnsServers() == other.hasDnsServers()
                && Objects.equals(dnsServers(), other.dnsServers()) && hasDockerLabels() == other.hasDockerLabels()
                && Objects.equals(dockerLabels(), other.dockerLabels())
                && hasDockerSecurityOptions() == other.hasDockerSecurityOptions()
                && Objects.equals(dockerSecurityOptions(), other.dockerSecurityOptions())
                && hasEntryPoint() == other.hasEntryPoint() && Objects.equals(entryPoint(), other.entryPoint())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && hasEnvironmentFiles() == other.hasEnvironmentFiles()
                && Objects.equals(environmentFiles(), other.environmentFiles()) && Objects.equals(essential(), other.essential())
                && hasExtraHosts() == other.hasExtraHosts() && Objects.equals(extraHosts(), other.extraHosts())
                && Objects.equals(firelensConfiguration(), other.firelensConfiguration())
                && Objects.equals(healthCheck(), other.healthCheck()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(image(), other.image()) && Objects.equals(interactive(), other.interactive())
                && hasLinks() == other.hasLinks() && Objects.equals(links(), other.links())
                && Objects.equals(linuxParameters(), other.linuxParameters())
                && Objects.equals(logConfiguration(), other.logConfiguration()) && Objects.equals(memory(), other.memory())
                && Objects.equals(memoryReservation(), other.memoryReservation()) && hasMountPoints() == other.hasMountPoints()
                && Objects.equals(mountPoints(), other.mountPoints()) && Objects.equals(name(), other.name())
                && hasPortMappings() == other.hasPortMappings() && Objects.equals(portMappings(), other.portMappings())
                && Objects.equals(privileged(), other.privileged()) && Objects.equals(pseudoTerminal(), other.pseudoTerminal())
                && Objects.equals(readonlyRootFilesystem(), other.readonlyRootFilesystem())
                && Objects.equals(repositoryCredentials(), other.repositoryCredentials())
                && hasResourceRequirements() == other.hasResourceRequirements()
                && Objects.equals(resourceRequirements(), other.resourceRequirements()) && hasSecrets() == other.hasSecrets()
                && Objects.equals(secrets(), other.secrets()) && Objects.equals(startTimeout(), other.startTimeout())
                && Objects.equals(stopTimeout(), other.stopTimeout()) && hasSystemControls() == other.hasSystemControls()
                && Objects.equals(systemControls(), other.systemControls()) && hasUlimits() == other.hasUlimits()
                && Objects.equals(ulimits(), other.ulimits()) && Objects.equals(user(), other.user())
                && hasVolumesFrom() == other.hasVolumesFrom() && Objects.equals(volumesFrom(), other.volumesFrom())
                && Objects.equals(workingDirectory(), other.workingDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsDetails")
                .add("Command", hasCommand() ? command() : null).add("Cpu", cpu())
                .add("DependsOn", hasDependsOn() ? dependsOn() : null).add("DisableNetworking", disableNetworking())
                .add("DnsSearchDomains", hasDnsSearchDomains() ? dnsSearchDomains() : null)
                .add("DnsServers", hasDnsServers() ? dnsServers() : null)
                .add("DockerLabels", hasDockerLabels() ? dockerLabels() : null)
                .add("DockerSecurityOptions", hasDockerSecurityOptions() ? dockerSecurityOptions() : null)
                .add("EntryPoint", hasEntryPoint() ? entryPoint() : null)
                .add("Environment", hasEnvironment() ? environment() : null)
                .add("EnvironmentFiles", hasEnvironmentFiles() ? environmentFiles() : null).add("Essential", essential())
                .add("ExtraHosts", hasExtraHosts() ? extraHosts() : null).add("FirelensConfiguration", firelensConfiguration())
                .add("HealthCheck", healthCheck()).add("Hostname", hostname()).add("Image", image())
                .add("Interactive", interactive()).add("Links", hasLinks() ? links() : null)
                .add("LinuxParameters", linuxParameters()).add("LogConfiguration", logConfiguration()).add("Memory", memory())
                .add("MemoryReservation", memoryReservation()).add("MountPoints", hasMountPoints() ? mountPoints() : null)
                .add("Name", name()).add("PortMappings", hasPortMappings() ? portMappings() : null)
                .add("Privileged", privileged()).add("PseudoTerminal", pseudoTerminal())
                .add("ReadonlyRootFilesystem", readonlyRootFilesystem()).add("RepositoryCredentials", repositoryCredentials())
                .add("ResourceRequirements", hasResourceRequirements() ? resourceRequirements() : null)
                .add("Secrets", hasSecrets() ? secrets() : null).add("StartTimeout", startTimeout())
                .add("StopTimeout", stopTimeout()).add("SystemControls", hasSystemControls() ? systemControls() : null)
                .add("Ulimits", hasUlimits() ? ulimits() : null).add("User", user())
                .add("VolumesFrom", hasVolumesFrom() ? volumesFrom() : null).add("WorkingDirectory", workingDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "DependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "DisableNetworking":
            return Optional.ofNullable(clazz.cast(disableNetworking()));
        case "DnsSearchDomains":
            return Optional.ofNullable(clazz.cast(dnsSearchDomains()));
        case "DnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "DockerLabels":
            return Optional.ofNullable(clazz.cast(dockerLabels()));
        case "DockerSecurityOptions":
            return Optional.ofNullable(clazz.cast(dockerSecurityOptions()));
        case "EntryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "EnvironmentFiles":
            return Optional.ofNullable(clazz.cast(environmentFiles()));
        case "Essential":
            return Optional.ofNullable(clazz.cast(essential()));
        case "ExtraHosts":
            return Optional.ofNullable(clazz.cast(extraHosts()));
        case "FirelensConfiguration":
            return Optional.ofNullable(clazz.cast(firelensConfiguration()));
        case "HealthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Interactive":
            return Optional.ofNullable(clazz.cast(interactive()));
        case "Links":
            return Optional.ofNullable(clazz.cast(links()));
        case "LinuxParameters":
            return Optional.ofNullable(clazz.cast(linuxParameters()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "Memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "MemoryReservation":
            return Optional.ofNullable(clazz.cast(memoryReservation()));
        case "MountPoints":
            return Optional.ofNullable(clazz.cast(mountPoints()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PortMappings":
            return Optional.ofNullable(clazz.cast(portMappings()));
        case "Privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        case "PseudoTerminal":
            return Optional.ofNullable(clazz.cast(pseudoTerminal()));
        case "ReadonlyRootFilesystem":
            return Optional.ofNullable(clazz.cast(readonlyRootFilesystem()));
        case "RepositoryCredentials":
            return Optional.ofNullable(clazz.cast(repositoryCredentials()));
        case "ResourceRequirements":
            return Optional.ofNullable(clazz.cast(resourceRequirements()));
        case "Secrets":
            return Optional.ofNullable(clazz.cast(secrets()));
        case "StartTimeout":
            return Optional.ofNullable(clazz.cast(startTimeout()));
        case "StopTimeout":
            return Optional.ofNullable(clazz.cast(stopTimeout()));
        case "SystemControls":
            return Optional.ofNullable(clazz.cast(systemControls()));
        case "Ulimits":
            return Optional.ofNullable(clazz.cast(ulimits()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "VolumesFrom":
            return Optional.ofNullable(clazz.cast(volumesFrom()));
        case "WorkingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsDetails> {
        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The number of CPU units reserved for the container.
         * </p>
         * 
         * @param cpu
         *        The number of CPU units reserved for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);

        /**
         * <p>
         * The dependencies that are defined for container startup and shutdown.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies that are defined for container startup and shutdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> dependsOn);

        /**
         * <p>
         * The dependencies that are defined for container startup and shutdown.
         * </p>
         * 
         * @param dependsOn
         *        The dependencies that are defined for container startup and shutdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails... dependsOn);

        /**
         * <p>
         * The dependencies that are defined for container startup and shutdown.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>.Builder} avoiding the need to create one manually
         * via {@link List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #dependsOn(List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>)
         */
        Builder dependsOn(Consumer<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.Builder>... dependsOn);

        /**
         * <p>
         * Whether to disable networking within the container.
         * </p>
         * 
         * @param disableNetworking
         *        Whether to disable networking within the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableNetworking(Boolean disableNetworking);

        /**
         * <p>
         * A list of DNS search domains that are presented to the container.
         * </p>
         * 
         * @param dnsSearchDomains
         *        A list of DNS search domains that are presented to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSearchDomains(Collection<String> dnsSearchDomains);

        /**
         * <p>
         * A list of DNS search domains that are presented to the container.
         * </p>
         * 
         * @param dnsSearchDomains
         *        A list of DNS search domains that are presented to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSearchDomains(String... dnsSearchDomains);

        /**
         * <p>
         * A list of DNS servers that are presented to the container.
         * </p>
         * 
         * @param dnsServers
         *        A list of DNS servers that are presented to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(Collection<String> dnsServers);

        /**
         * <p>
         * A list of DNS servers that are presented to the container.
         * </p>
         * 
         * @param dnsServers
         *        A list of DNS servers that are presented to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(String... dnsServers);

        /**
         * <p>
         * A key-value map of labels to add to the container.
         * </p>
         * 
         * @param dockerLabels
         *        A key-value map of labels to add to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerLabels(Map<String, String> dockerLabels);

        /**
         * <p>
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * </p>
         * 
         * @param dockerSecurityOptions
         *        A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerSecurityOptions(Collection<String> dockerSecurityOptions);

        /**
         * <p>
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * </p>
         * 
         * @param dockerSecurityOptions
         *        A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerSecurityOptions(String... dockerSecurityOptions);

        /**
         * <p>
         * The entry point that is passed to the container.
         * </p>
         * 
         * @param entryPoint
         *        The entry point that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(Collection<String> entryPoint);

        /**
         * <p>
         * The entry point that is passed to the container.
         * </p>
         * 
         * @param entryPoint
         *        The entry point that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String... entryPoint);

        /**
         * <p>
         * The environment variables to pass to a container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> environment);

        /**
         * <p>
         * The environment variables to pass to a container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails... environment);

        /**
         * <p>
         * The environment variables to pass to a container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>)
         */
        Builder environment(Consumer<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.Builder>... environment);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails... environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link
         * #environmentFiles(List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>)}.
         * 
         * @param environmentFiles
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentFiles(List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>)
         */
        Builder environmentFiles(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.Builder>... environmentFiles);

        /**
         * <p>
         * Whether the container is essential. All tasks must have at least one essential container.
         * </p>
         * 
         * @param essential
         *        Whether the container is essential. All tasks must have at least one essential container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder essential(Boolean essential);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
         * </p>
         * 
         * @param extraHosts
         *        A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraHosts(Collection<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> extraHosts);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
         * </p>
         * 
         * @param extraHosts
         *        A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraHosts(AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails... extraHosts);

        /**
         * <p>
         * A list of hostnames and IP address mappings to append to the <b>/etc/hosts</b> file on the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>.Builder} avoiding the need to create one manually
         * via {@link List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #extraHosts(List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>)}.
         * 
         * @param extraHosts
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraHosts(List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>)
         */
        Builder extraHosts(Consumer<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.Builder>... extraHosts);

        /**
         * <p>
         * The FireLens configuration for the container. Specifies and configures a log router for container logs.
         * </p>
         * 
         * @param firelensConfiguration
         *        The FireLens configuration for the container. Specifies and configures a log router for container
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firelensConfiguration(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails firelensConfiguration);

        /**
         * <p>
         * The FireLens configuration for the container. Specifies and configures a log router for container logs.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #firelensConfiguration(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails)}.
         * 
         * @param firelensConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firelensConfiguration(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails)
         */
        default Builder firelensConfiguration(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder> firelensConfiguration) {
            return firelensConfiguration(AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.builder()
                    .applyMutation(firelensConfiguration).build());
        }

        /**
         * <p>
         * The container health check command and associated configuration parameters for the container.
         * </p>
         * 
         * @param healthCheck
         *        The container health check command and associated configuration parameters for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails healthCheck);

        /**
         * <p>
         * The container health check command and associated configuration parameters for the container.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #healthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails)
         */
        default Builder healthCheck(Consumer<AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder> healthCheck) {
            return healthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.builder().applyMutation(healthCheck)
                    .build());
        }

        /**
         * <p>
         * The hostname to use for the container.
         * </p>
         * 
         * @param hostname
         *        The hostname to use for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The image used to start the container.
         * </p>
         * 
         * @param image
         *        The image used to start the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * If set to true, then containerized applications can be deployed that require <code>stdin</code> or a
         * <code>tty</code> to be allocated.
         * </p>
         * 
         * @param interactive
         *        If set to true, then containerized applications can be deployed that require <code>stdin</code> or a
         *        <code>tty</code> to be allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactive(Boolean interactive);

        /**
         * <p>
         * A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>. Allows
         * containers to communicate with each other without the need for port mappings.
         * </p>
         * 
         * @param links
         *        A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>.
         *        Allows containers to communicate with each other without the need for port mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<String> links);

        /**
         * <p>
         * A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>. Allows
         * containers to communicate with each other without the need for port mappings.
         * </p>
         * 
         * @param links
         *        A list of links for the container in the form <code> <i>container_name</i>:<i>alias</i> </code>.
         *        Allows containers to communicate with each other without the need for port mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(String... links);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * </p>
         * 
         * @param linuxParameters
         *        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxParameters(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails linuxParameters);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder} avoiding the need to create
         * one manually via {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #linuxParameters(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)}.
         * 
         * @param linuxParameters
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linuxParameters(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails)
         */
        default Builder linuxParameters(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder> linuxParameters) {
            return linuxParameters(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.builder()
                    .applyMutation(linuxParameters).build());
        }

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * 
         * @param logConfiguration
         *        The log configuration specification for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails logConfiguration);

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder} avoiding the need to create
         * one manually via {@link AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #logConfiguration(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)
         */
        default Builder logConfiguration(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder> logConfiguration) {
            return logConfiguration(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.builder()
                    .applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory
         * specified here, the container is shut down. The total amount of memory reserved for all containers within a
         * task must be lower than the task memory value, if one is specified.
         * </p>
         * 
         * @param memory
         *        The amount (in MiB) of memory to present to the container. If the container attempts to exceed the
         *        memory specified here, the container is shut down. The total amount of memory reserved for all
         *        containers within a task must be lower than the task memory value, if one is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The soft limit (in MiB) of memory to reserve for the container.
         * </p>
         * 
         * @param memoryReservation
         *        The soft limit (in MiB) of memory to reserve for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryReservation(Integer memoryReservation);

        /**
         * <p>
         * The mount points for the data volumes in the container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for the data volumes in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(Collection<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> mountPoints);

        /**
         * <p>
         * The mount points for the data volumes in the container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for the data volumes in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails... mountPoints);

        /**
         * <p>
         * The mount points for the data volumes in the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #mountPoints(List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>)}.
         * 
         * @param mountPoints
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountPoints(List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>)
         */
        Builder mountPoints(Consumer<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.Builder>... mountPoints);

        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param name
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of port mappings for the container.
         * </p>
         * 
         * @param portMappings
         *        The list of port mappings for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(Collection<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> portMappings);

        /**
         * <p>
         * The list of port mappings for the container.
         * </p>
         * 
         * @param portMappings
         *        The list of port mappings for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails... portMappings);

        /**
         * <p>
         * The list of port mappings for the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #portMappings(List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>)}.
         * 
         * @param portMappings
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMappings(List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>)
         */
        Builder portMappings(Consumer<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.Builder>... portMappings);

        /**
         * <p>
         * Whether the container is given elevated privileges on the host container instance. The elevated privileges
         * are similar to the root user.
         * </p>
         * 
         * @param privileged
         *        Whether the container is given elevated privileges on the host container instance. The elevated
         *        privileges are similar to the root user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * Whether to allocate a TTY to the container.
         * </p>
         * 
         * @param pseudoTerminal
         *        Whether to allocate a TTY to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pseudoTerminal(Boolean pseudoTerminal);

        /**
         * <p>
         * Whether the container is given read-only access to its root file system.
         * </p>
         * 
         * @param readonlyRootFilesystem
         *        Whether the container is given read-only access to its root file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem);

        /**
         * <p>
         * The private repository authentication credentials to use.
         * </p>
         * 
         * @param repositoryCredentials
         *        The private repository authentication credentials to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCredentials(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails repositoryCredentials);

        /**
         * <p>
         * The private repository authentication credentials to use.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #repositoryCredentials(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)}.
         * 
         * @param repositoryCredentials
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryCredentials(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)
         */
        default Builder repositoryCredentials(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder> repositoryCredentials) {
            return repositoryCredentials(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.builder()
                    .applyMutation(repositoryCredentials).build());
        }

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails... resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>.Builder} avoiding the need to create
         * one manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link
         * #resourceRequirements(List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>)}.
         * 
         * @param resourceRequirements
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequirements(List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>)
         */
        Builder resourceRequirements(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.Builder>... resourceRequirements);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Collection<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> secrets);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * 
         * @param secrets
         *        The secrets to pass to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails... secrets);

        /**
         * <p>
         * The secrets to pass to the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>.Builder} avoiding the need to create one manually
         * via {@link List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #secrets(List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>)}.
         * 
         * @param secrets
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secrets(List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>)
         */
        Builder secrets(Consumer<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.Builder>... secrets);

        /**
         * <p>
         * The number of seconds to wait before giving up on resolving dependencies for a container.
         * </p>
         * 
         * @param startTimeout
         *        The number of seconds to wait before giving up on resolving dependencies for a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeout(Integer startTimeout);

        /**
         * <p>
         * The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.
         * </p>
         * 
         * @param stopTimeout
         *        The number of seconds to wait before the container is stopped if it doesn't shut down normally on its
         *        own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimeout(Integer stopTimeout);

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container.
         * </p>
         * 
         * @param systemControls
         *        A list of namespaced kernel parameters to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemControls(Collection<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> systemControls);

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container.
         * </p>
         * 
         * @param systemControls
         *        A list of namespaced kernel parameters to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemControls(AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails... systemControls);

        /**
         * <p>
         * A list of namespaced kernel parameters to set in the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link
         * #systemControls(List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>)}.
         * 
         * @param systemControls
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemControls(List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>)
         */
        Builder systemControls(Consumer<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.Builder>... systemControls);

        /**
         * <p>
         * A list of ulimits to set in the container.
         * </p>
         * 
         * @param ulimits
         *        A list of ulimits to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Collection<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> ulimits);

        /**
         * <p>
         * A list of ulimits to set in the container.
         * </p>
         * 
         * @param ulimits
         *        A list of ulimits to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails... ulimits);

        /**
         * <p>
         * A list of ulimits to set in the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>.Builder} avoiding the need to create one manually
         * via {@link List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #ulimits(List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>)}.
         * 
         * @param ulimits
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ulimits(List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>)
         */
        Builder ulimits(Consumer<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.Builder>... ulimits);

        /**
         * <p>
         * The user to use inside the container.
         * </p>
         * <p>
         * The value can use one of the following formats.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code> <i>user</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>user</i> </code>:<code> <i>group</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>uid</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>uid</i> </code>:<code> <i>gid</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>user</i> </code>:<code> <i>gid</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>uid</i> </code>:<code> <i>group</i> </code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param user
         *        The user to use inside the container.</p>
         *        <p>
         *        The value can use one of the following formats.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code> <i>user</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>user</i> </code>:<code> <i>group</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>uid</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>uid</i> </code>:<code> <i>gid</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>user</i> </code>:<code> <i>gid</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>uid</i> </code>:<code> <i>group</i> </code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * Data volumes to mount from another container.
         * </p>
         * 
         * @param volumesFrom
         *        Data volumes to mount from another container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesFrom(Collection<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> volumesFrom);

        /**
         * <p>
         * Data volumes to mount from another container.
         * </p>
         * 
         * @param volumesFrom
         *        Data volumes to mount from another container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesFrom(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails... volumesFrom);

        /**
         * <p>
         * Data volumes to mount from another container.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>.Builder} avoiding the need to create one
         * manually via {@link List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #volumesFrom(List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>)}.
         * 
         * @param volumesFrom
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumesFrom(List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>)
         */
        Builder volumesFrom(Consumer<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.Builder>... volumesFrom);

        /**
         * <p>
         * The working directory in which to run commands inside the container.
         * </p>
         * 
         * @param workingDirectory
         *        The working directory in which to run commands inside the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);
    }

    static final class BuilderImpl implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private Integer cpu;

        private List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> dependsOn = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean disableNetworking;

        private List<String> dnsSearchDomains = DefaultSdkAutoConstructList.getInstance();

        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> dockerLabels = DefaultSdkAutoConstructMap.getInstance();

        private List<String> dockerSecurityOptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> environment = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> environmentFiles = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean essential;

        private List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> extraHosts = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails firelensConfiguration;

        private AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails healthCheck;

        private String hostname;

        private String image;

        private Boolean interactive;

        private List<String> links = DefaultSdkAutoConstructList.getInstance();

        private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails linuxParameters;

        private AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails logConfiguration;

        private Integer memory;

        private Integer memoryReservation;

        private List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> mountPoints = DefaultSdkAutoConstructList
                .getInstance();

        private String name;

        private List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> portMappings = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean privileged;

        private Boolean pseudoTerminal;

        private Boolean readonlyRootFilesystem;

        private AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails repositoryCredentials;

        private List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> resourceRequirements = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> secrets = DefaultSdkAutoConstructList.getInstance();

        private Integer startTimeout;

        private Integer stopTimeout;

        private List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> systemControls = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> ulimits = DefaultSdkAutoConstructList.getInstance();

        private String user;

        private List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> volumesFrom = DefaultSdkAutoConstructList
                .getInstance();

        private String workingDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsDetails model) {
            command(model.command);
            cpu(model.cpu);
            dependsOn(model.dependsOn);
            disableNetworking(model.disableNetworking);
            dnsSearchDomains(model.dnsSearchDomains);
            dnsServers(model.dnsServers);
            dockerLabels(model.dockerLabels);
            dockerSecurityOptions(model.dockerSecurityOptions);
            entryPoint(model.entryPoint);
            environment(model.environment);
            environmentFiles(model.environmentFiles);
            essential(model.essential);
            extraHosts(model.extraHosts);
            firelensConfiguration(model.firelensConfiguration);
            healthCheck(model.healthCheck);
            hostname(model.hostname);
            image(model.image);
            interactive(model.interactive);
            links(model.links);
            linuxParameters(model.linuxParameters);
            logConfiguration(model.logConfiguration);
            memory(model.memory);
            memoryReservation(model.memoryReservation);
            mountPoints(model.mountPoints);
            name(model.name);
            portMappings(model.portMappings);
            privileged(model.privileged);
            pseudoTerminal(model.pseudoTerminal);
            readonlyRootFilesystem(model.readonlyRootFilesystem);
            repositoryCredentials(model.repositoryCredentials);
            resourceRequirements(model.resourceRequirements);
            secrets(model.secrets);
            startTimeout(model.startTimeout);
            stopTimeout(model.stopTimeout);
            systemControls(model.systemControls);
            ulimits(model.ulimits);
            user(model.user);
            volumesFrom(model.volumesFrom);
            workingDirectory(model.workingDirectory);
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = NonEmptyStringListCopier.copy(command);
        }

        @Override
        @Transient
        public final Builder command(Collection<String> command) {
            this.command = NonEmptyStringListCopier.copy(command);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final Integer getCpu() {
            return cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        @Transient
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.Builder> getDependsOn() {
            List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsDependsOnListCopier
                    .copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.BuilderImpl> dependsOn) {
            this.dependsOn = AwsEcsTaskDefinitionContainerDefinitionsDependsOnListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        @Transient
        public final Builder dependsOn(Collection<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> dependsOn) {
            this.dependsOn = AwsEcsTaskDefinitionContainerDefinitionsDependsOnListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dependsOn(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dependsOn(Consumer<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisableNetworking() {
            return disableNetworking;
        }

        public final void setDisableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
        }

        @Override
        @Transient
        public final Builder disableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        public final Collection<String> getDnsSearchDomains() {
            if (dnsSearchDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsSearchDomains;
        }

        public final void setDnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = NonEmptyStringListCopier.copy(dnsSearchDomains);
        }

        @Override
        @Transient
        public final Builder dnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = NonEmptyStringListCopier.copy(dnsSearchDomains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dnsSearchDomains(String... dnsSearchDomains) {
            dnsSearchDomains(Arrays.asList(dnsSearchDomains));
            return this;
        }

        public final Collection<String> getDnsServers() {
            if (dnsServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsServers;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = NonEmptyStringListCopier.copy(dnsServers);
        }

        @Override
        @Transient
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = NonEmptyStringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dnsServers(String... dnsServers) {
            dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final Map<String, String> getDockerLabels() {
            if (dockerLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return dockerLabels;
        }

        public final void setDockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = FieldMapCopier.copy(dockerLabels);
        }

        @Override
        @Transient
        public final Builder dockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = FieldMapCopier.copy(dockerLabels);
            return this;
        }

        public final Collection<String> getDockerSecurityOptions() {
            if (dockerSecurityOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return dockerSecurityOptions;
        }

        public final void setDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = NonEmptyStringListCopier.copy(dockerSecurityOptions);
        }

        @Override
        @Transient
        public final Builder dockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = NonEmptyStringListCopier.copy(dockerSecurityOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dockerSecurityOptions(String... dockerSecurityOptions) {
            dockerSecurityOptions(Arrays.asList(dockerSecurityOptions));
            return this;
        }

        public final Collection<String> getEntryPoint() {
            if (entryPoint instanceof SdkAutoConstructList) {
                return null;
            }
            return entryPoint;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = NonEmptyStringListCopier.copy(entryPoint);
        }

        @Override
        @Transient
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = NonEmptyStringListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entryPoint(String... entryPoint) {
            entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.Builder> getEnvironment() {
            List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentListCopier
                    .copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.BuilderImpl> environment) {
            this.environment = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentListCopier.copyFromBuilder(environment);
        }

        @Override
        @Transient
        public final Builder environment(Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails> environment) {
            this.environment = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentListCopier.copy(environment);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environment(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environment(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.Builder>... environment) {
            environment(Stream.of(environment)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.Builder> getEnvironmentFiles() {
            List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesListCopier
                    .copyToBuilder(this.environmentFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFiles(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.BuilderImpl> environmentFiles) {
            this.environmentFiles = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesListCopier
                    .copyFromBuilder(environmentFiles);
        }

        @Override
        @Transient
        public final Builder environmentFiles(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails> environmentFiles) {
            this.environmentFiles = AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesListCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentFiles(AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails... environmentFiles) {
            environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentFiles(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.Builder>... environmentFiles) {
            environmentFiles(Stream.of(environmentFiles)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEssential() {
            return essential;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        @Override
        @Transient
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.Builder> getExtraHosts() {
            List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsExtraHostsListCopier
                    .copyToBuilder(this.extraHosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtraHosts(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.BuilderImpl> extraHosts) {
            this.extraHosts = AwsEcsTaskDefinitionContainerDefinitionsExtraHostsListCopier.copyFromBuilder(extraHosts);
        }

        @Override
        @Transient
        public final Builder extraHosts(Collection<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails> extraHosts) {
            this.extraHosts = AwsEcsTaskDefinitionContainerDefinitionsExtraHostsListCopier.copy(extraHosts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder extraHosts(AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails... extraHosts) {
            extraHosts(Arrays.asList(extraHosts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder extraHosts(Consumer<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.Builder>... extraHosts) {
            extraHosts(Stream.of(extraHosts)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder getFirelensConfiguration() {
            return firelensConfiguration != null ? firelensConfiguration.toBuilder() : null;
        }

        public final void setFirelensConfiguration(
                AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.BuilderImpl firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration != null ? firelensConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder firelensConfiguration(
                AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration;
            return this;
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        @Transient
        public final Builder healthCheck(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        @Transient
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        @Transient
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Boolean getInteractive() {
            return interactive;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        @Override
        @Transient
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final Collection<String> getLinks() {
            if (links instanceof SdkAutoConstructList) {
                return null;
            }
            return links;
        }

        public final void setLinks(Collection<String> links) {
            this.links = NonEmptyStringListCopier.copy(links);
        }

        @Override
        @Transient
        public final Builder links(Collection<String> links) {
            this.links = NonEmptyStringListCopier.copy(links);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder links(String... links) {
            links(Arrays.asList(links));
            return this;
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder getLinuxParameters() {
            return linuxParameters != null ? linuxParameters.toBuilder() : null;
        }

        public final void setLinuxParameters(
                AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder linuxParameters(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(
                AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder logConfiguration(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        @Transient
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        @Transient
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.Builder> getMountPoints() {
            List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsMountPointsListCopier
                    .copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.BuilderImpl> mountPoints) {
            this.mountPoints = AwsEcsTaskDefinitionContainerDefinitionsMountPointsListCopier.copyFromBuilder(mountPoints);
        }

        @Override
        @Transient
        public final Builder mountPoints(Collection<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails> mountPoints) {
            this.mountPoints = AwsEcsTaskDefinitionContainerDefinitionsMountPointsListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mountPoints(AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mountPoints(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.Builder>... mountPoints) {
            mountPoints(Stream.of(mountPoints)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.Builder> getPortMappings() {
            List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsPortMappingsListCopier
                    .copyToBuilder(this.portMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortMappings(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.BuilderImpl> portMappings) {
            this.portMappings = AwsEcsTaskDefinitionContainerDefinitionsPortMappingsListCopier.copyFromBuilder(portMappings);
        }

        @Override
        @Transient
        public final Builder portMappings(Collection<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> portMappings) {
            this.portMappings = AwsEcsTaskDefinitionContainerDefinitionsPortMappingsListCopier.copy(portMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portMappings(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails... portMappings) {
            portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portMappings(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.Builder>... portMappings) {
            portMappings(Stream.of(portMappings)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        @Transient
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getPseudoTerminal() {
            return pseudoTerminal;
        }

        public final void setPseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
        }

        @Override
        @Transient
        public final Builder pseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
            return this;
        }

        public final Boolean getReadonlyRootFilesystem() {
            return readonlyRootFilesystem;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        @Override
        @Transient
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder getRepositoryCredentials() {
            return repositoryCredentials != null ? repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(
                AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        @Transient
        public final Builder repositoryCredentials(
                AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.Builder> getResourceRequirements() {
            List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsListCopier
                    .copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsListCopier
                    .copyFromBuilder(resourceRequirements);
        }

        @Override
        @Transient
        public final Builder resourceRequirements(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> resourceRequirements) {
            this.resourceRequirements = AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsListCopier
                    .copy(resourceRequirements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceRequirements(
                AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails... resourceRequirements) {
            resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceRequirements(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.Builder>... resourceRequirements) {
            resourceRequirements(Stream
                    .of(resourceRequirements)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.builder().applyMutation(c)
                            .build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.Builder> getSecrets() {
            List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsSecretsListCopier
                    .copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.BuilderImpl> secrets) {
            this.secrets = AwsEcsTaskDefinitionContainerDefinitionsSecretsListCopier.copyFromBuilder(secrets);
        }

        @Override
        @Transient
        public final Builder secrets(Collection<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails> secrets) {
            this.secrets = AwsEcsTaskDefinitionContainerDefinitionsSecretsListCopier.copy(secrets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secrets(AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails... secrets) {
            secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secrets(Consumer<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.Builder>... secrets) {
            secrets(Stream.of(secrets)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStartTimeout() {
            return startTimeout;
        }

        public final void setStartTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
        }

        @Override
        @Transient
        public final Builder startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public final Integer getStopTimeout() {
            return stopTimeout;
        }

        public final void setStopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
        }

        @Override
        @Transient
        public final Builder stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.Builder> getSystemControls() {
            List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsSystemControlsListCopier
                    .copyToBuilder(this.systemControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemControls(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.BuilderImpl> systemControls) {
            this.systemControls = AwsEcsTaskDefinitionContainerDefinitionsSystemControlsListCopier
                    .copyFromBuilder(systemControls);
        }

        @Override
        @Transient
        public final Builder systemControls(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails> systemControls) {
            this.systemControls = AwsEcsTaskDefinitionContainerDefinitionsSystemControlsListCopier.copy(systemControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder systemControls(AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails... systemControls) {
            systemControls(Arrays.asList(systemControls));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder systemControls(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.Builder>... systemControls) {
            systemControls(Stream.of(systemControls)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.Builder> getUlimits() {
            List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsUlimitsListCopier
                    .copyToBuilder(this.ulimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUlimits(Collection<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.BuilderImpl> ulimits) {
            this.ulimits = AwsEcsTaskDefinitionContainerDefinitionsUlimitsListCopier.copyFromBuilder(ulimits);
        }

        @Override
        @Transient
        public final Builder ulimits(Collection<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails> ulimits) {
            this.ulimits = AwsEcsTaskDefinitionContainerDefinitionsUlimitsListCopier.copy(ulimits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ulimits(AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails... ulimits) {
            ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ulimits(Consumer<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.Builder>... ulimits) {
            ulimits(Stream.of(ulimits)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        @Transient
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.Builder> getVolumesFrom() {
            List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsVolumesFromListCopier
                    .copyToBuilder(this.volumesFrom);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumesFrom(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.BuilderImpl> volumesFrom) {
            this.volumesFrom = AwsEcsTaskDefinitionContainerDefinitionsVolumesFromListCopier.copyFromBuilder(volumesFrom);
        }

        @Override
        @Transient
        public final Builder volumesFrom(Collection<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> volumesFrom) {
            this.volumesFrom = AwsEcsTaskDefinitionContainerDefinitionsVolumesFromListCopier.copy(volumesFrom);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder volumesFrom(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails... volumesFrom) {
            volumesFrom(Arrays.asList(volumesFrom));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder volumesFrom(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.Builder>... volumesFrom) {
            volumesFrom(Stream.of(volumesFrom)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
