/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A secret to pass to the log configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueFrom")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails::valueFrom))
            .setter(setter(Builder::valueFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FROM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String valueFrom;

    private AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.valueFrom = builder.valueFrom;
    }

    /**
     * <p>
     * The name of the secret.
     * </p>
     * 
     * @return The name of the secret.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The secret to expose to the container.
     * </p>
     * <p>
     * The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the Systems
     * Manager Parameter Store.
     * </p>
     * 
     * @return The secret to expose to the container.</p>
     *         <p>
     *         The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the
     *         Systems Manager Parameter Store.
     */
    public final String valueFrom() {
        return valueFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueFrom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(valueFrom(), other.valueFrom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails")
                .add("Name", name()).add("ValueFrom", valueFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueFrom":
            return Optional.ofNullable(clazz.cast(valueFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> {
        /**
         * <p>
         * The name of the secret.
         * </p>
         * 
         * @param name
         *        The name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The secret to expose to the container.
         * </p>
         * <p>
         * The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the
         * Systems Manager Parameter Store.
         * </p>
         * 
         * @param valueFrom
         *        The secret to expose to the container.</p>
         *        <p>
         *        The value is either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the
         *        Systems Manager Parameter Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueFrom(String valueFrom);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String valueFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails model) {
            name(model.name);
            valueFrom(model.valueFrom);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueFrom() {
            return valueFrom;
        }

        public final void setValueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
        }

        @Override
        @Transient
        public final Builder valueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
