/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration for an Amazon EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEksClusterLoggingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEksClusterLoggingDetails.Builder, AwsEksClusterLoggingDetails> {
    private static final SdkField<List<AwsEksClusterLoggingClusterLoggingDetails>> CLUSTER_LOGGING_FIELD = SdkField
            .<List<AwsEksClusterLoggingClusterLoggingDetails>> builder(MarshallingType.LIST)
            .memberName("ClusterLogging")
            .getter(getter(AwsEksClusterLoggingDetails::clusterLogging))
            .setter(setter(Builder::clusterLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterLogging").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEksClusterLoggingClusterLoggingDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEksClusterLoggingClusterLoggingDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_LOGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsEksClusterLoggingClusterLoggingDetails> clusterLogging;

    private AwsEksClusterLoggingDetails(BuilderImpl builder) {
        this.clusterLogging = builder.clusterLogging;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterLogging property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterLogging() {
        return clusterLogging != null && !(clusterLogging instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Cluster logging configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterLogging} method.
     * </p>
     * 
     * @return Cluster logging configurations.
     */
    public final List<AwsEksClusterLoggingClusterLoggingDetails> clusterLogging() {
        return clusterLogging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterLogging() ? clusterLogging() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEksClusterLoggingDetails)) {
            return false;
        }
        AwsEksClusterLoggingDetails other = (AwsEksClusterLoggingDetails) obj;
        return hasClusterLogging() == other.hasClusterLogging() && Objects.equals(clusterLogging(), other.clusterLogging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEksClusterLoggingDetails")
                .add("ClusterLogging", hasClusterLogging() ? clusterLogging() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterLogging":
            return Optional.ofNullable(clazz.cast(clusterLogging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEksClusterLoggingDetails, T> g) {
        return obj -> g.apply((AwsEksClusterLoggingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEksClusterLoggingDetails> {
        /**
         * <p>
         * Cluster logging configurations.
         * </p>
         * 
         * @param clusterLogging
         *        Cluster logging configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterLogging(Collection<AwsEksClusterLoggingClusterLoggingDetails> clusterLogging);

        /**
         * <p>
         * Cluster logging configurations.
         * </p>
         * 
         * @param clusterLogging
         *        Cluster logging configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterLogging(AwsEksClusterLoggingClusterLoggingDetails... clusterLogging);

        /**
         * <p>
         * Cluster logging configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEksClusterLoggingClusterLoggingDetails>.Builder} avoiding the need to create one manually via
         * {@link List<AwsEksClusterLoggingClusterLoggingDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEksClusterLoggingClusterLoggingDetails>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #clusterLogging(List<AwsEksClusterLoggingClusterLoggingDetails>)}.
         * 
         * @param clusterLogging
         *        a consumer that will call methods on {@link List<AwsEksClusterLoggingClusterLoggingDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterLogging(List<AwsEksClusterLoggingClusterLoggingDetails>)
         */
        Builder clusterLogging(Consumer<AwsEksClusterLoggingClusterLoggingDetails.Builder>... clusterLogging);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsEksClusterLoggingClusterLoggingDetails> clusterLogging = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEksClusterLoggingDetails model) {
            clusterLogging(model.clusterLogging);
        }

        public final List<AwsEksClusterLoggingClusterLoggingDetails.Builder> getClusterLogging() {
            List<AwsEksClusterLoggingClusterLoggingDetails.Builder> result = AwsEksClusterLoggingClusterLoggingListCopier
                    .copyToBuilder(this.clusterLogging);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterLogging(Collection<AwsEksClusterLoggingClusterLoggingDetails.BuilderImpl> clusterLogging) {
            this.clusterLogging = AwsEksClusterLoggingClusterLoggingListCopier.copyFromBuilder(clusterLogging);
        }

        @Override
        @Transient
        public final Builder clusterLogging(Collection<AwsEksClusterLoggingClusterLoggingDetails> clusterLogging) {
            this.clusterLogging = AwsEksClusterLoggingClusterLoggingListCopier.copy(clusterLogging);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterLogging(AwsEksClusterLoggingClusterLoggingDetails... clusterLogging) {
            clusterLogging(Arrays.asList(clusterLogging));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterLogging(Consumer<AwsEksClusterLoggingClusterLoggingDetails.Builder>... clusterLogging) {
            clusterLogging(Stream.of(clusterLogging)
                    .map(c -> AwsEksClusterLoggingClusterLoggingDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEksClusterLoggingDetails build() {
            return new AwsEksClusterLoggingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
