/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an IAM group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamGroupDetails.Builder, AwsIamGroupDetails> {
    private static final SdkField<List<AwsIamAttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AwsIamAttachedManagedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(AwsIamGroupDetails::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamAttachedManagedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamAttachedManagedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamGroupDetails::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(AwsIamGroupDetails::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AwsIamGroupDetails::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<List<AwsIamGroupPolicy>> GROUP_POLICY_LIST_FIELD = SdkField
            .<List<AwsIamGroupPolicy>> builder(MarshallingType.LIST)
            .memberName("GroupPolicyList")
            .getter(getter(AwsIamGroupDetails::groupPolicyList))
            .setter(setter(Builder::groupPolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupPolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamGroupPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamGroupPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamGroupDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTACHED_MANAGED_POLICIES_FIELD, CREATE_DATE_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD, GROUP_POLICY_LIST_FIELD,
            PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies;

    private final String createDate;

    private final String groupId;

    private final String groupName;

    private final List<AwsIamGroupPolicy> groupPolicyList;

    private final String path;

    private AwsIamGroupDetails(BuilderImpl builder) {
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.createDate = builder.createDate;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.groupPolicyList = builder.groupPolicyList;
        this.path = builder.path;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedManagedPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the managed policies that are attached to the IAM group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedManagedPolicies} method.
     * </p>
     * 
     * @return A list of the managed policies that are attached to the IAM group.
     */
    public final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * Indicates when the IAM group was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the IAM group was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier of the IAM group.
     * </p>
     * 
     * @return The identifier of the IAM group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the IAM group.
     * </p>
     * 
     * @return The name of the IAM group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupPolicyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupPolicyList() {
        return groupPolicyList != null && !(groupPolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of inline policies that are embedded in the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupPolicyList} method.
     * </p>
     * 
     * @return The list of inline policies that are embedded in the group.
     */
    public final List<AwsIamGroupPolicy> groupPolicyList() {
        return groupPolicyList;
    }

    /**
     * <p>
     * The path to the group.
     * </p>
     * 
     * @return The path to the group.
     */
    public final String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupPolicyList() ? groupPolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamGroupDetails)) {
            return false;
        }
        AwsIamGroupDetails other = (AwsIamGroupDetails) obj;
        return hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(groupName(), other.groupName()) && hasGroupPolicyList() == other.hasGroupPolicyList()
                && Objects.equals(groupPolicyList(), other.groupPolicyList()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamGroupDetails")
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("CreateDate", createDate()).add("GroupId", groupId()).add("GroupName", groupName())
                .add("GroupPolicyList", hasGroupPolicyList() ? groupPolicyList() : null).add("Path", path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupPolicyList":
            return Optional.ofNullable(clazz.cast(groupPolicyList()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamGroupDetails, T> g) {
        return obj -> g.apply((AwsIamGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamGroupDetails> {
        /**
         * <p>
         * A list of the managed policies that are attached to the IAM group.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies that are attached to the IAM group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies that are attached to the IAM group.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies that are attached to the IAM group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies that are attached to the IAM group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsIamAttachedManagedPolicy>.Builder}
         * avoiding the need to create one manually via {@link List<AwsIamAttachedManagedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsIamAttachedManagedPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachedManagedPolicies(List<AwsIamAttachedManagedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on {@link List<AwsIamAttachedManagedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(List<AwsIamAttachedManagedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * Indicates when the IAM group was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createDate
         *        Indicates when the IAM group was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The identifier of the IAM group.
         * </p>
         * 
         * @param groupId
         *        The identifier of the IAM group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the IAM group.
         * </p>
         * 
         * @param groupName
         *        The name of the IAM group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The list of inline policies that are embedded in the group.
         * </p>
         * 
         * @param groupPolicyList
         *        The list of inline policies that are embedded in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupPolicyList(Collection<AwsIamGroupPolicy> groupPolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the group.
         * </p>
         * 
         * @param groupPolicyList
         *        The list of inline policies that are embedded in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupPolicyList(AwsIamGroupPolicy... groupPolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsIamGroupPolicy>.Builder} avoiding the
         * need to create one manually via {@link List<AwsIamGroupPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsIamGroupPolicy>.Builder#build()} is called immediately
         * and its result is passed to {@link #groupPolicyList(List<AwsIamGroupPolicy>)}.
         * 
         * @param groupPolicyList
         *        a consumer that will call methods on {@link List<AwsIamGroupPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupPolicyList(List<AwsIamGroupPolicy>)
         */
        Builder groupPolicyList(Consumer<AwsIamGroupPolicy.Builder>... groupPolicyList);

        /**
         * <p>
         * The path to the group.
         * </p>
         * 
         * @param path
         *        The path to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsIamAttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private String createDate;

        private String groupId;

        private String groupName;

        private List<AwsIamGroupPolicy> groupPolicyList = DefaultSdkAutoConstructList.getInstance();

        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamGroupDetails model) {
            attachedManagedPolicies(model.attachedManagedPolicies);
            createDate(model.createDate);
            groupId(model.groupId);
            groupName(model.groupName);
            groupPolicyList(model.groupPolicyList);
            path(model.path);
        }

        public final List<AwsIamAttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            List<AwsIamAttachedManagedPolicy.Builder> result = AwsIamAttachedManagedPolicyListCopier
                    .copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        @Transient
        public final Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AwsIamAttachedManagedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<AwsIamGroupPolicy.Builder> getGroupPolicyList() {
            List<AwsIamGroupPolicy.Builder> result = AwsIamGroupPolicyListCopier.copyToBuilder(this.groupPolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupPolicyList(Collection<AwsIamGroupPolicy.BuilderImpl> groupPolicyList) {
            this.groupPolicyList = AwsIamGroupPolicyListCopier.copyFromBuilder(groupPolicyList);
        }

        @Override
        @Transient
        public final Builder groupPolicyList(Collection<AwsIamGroupPolicy> groupPolicyList) {
            this.groupPolicyList = AwsIamGroupPolicyListCopier.copy(groupPolicyList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupPolicyList(AwsIamGroupPolicy... groupPolicyList) {
            groupPolicyList(Arrays.asList(groupPolicyList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupPolicyList(Consumer<AwsIamGroupPolicy.Builder>... groupPolicyList) {
            groupPolicyList(Stream.of(groupPolicyList).map(c -> AwsIamGroupPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public AwsIamGroupDetails build() {
            return new AwsIamGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
