/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the configuration of an OpenSearch cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainClusterConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainClusterConfigDetails.Builder, AwsOpenSearchServiceDomainClusterConfigDetails> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<Boolean> WARM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WarmEnabled").getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::warmEnabled))
            .setter(setter(Builder::warmEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmEnabled").build()).build();

    private static final SdkField<Integer> WARM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmCount").getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::warmCount))
            .setter(setter(Builder::warmCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmCount").build()).build();

    private static final SdkField<Boolean> DEDICATED_MASTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedMasterEnabled")
            .getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::dedicatedMasterEnabled))
            .setter(setter(Builder::dedicatedMasterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterEnabled").build())
            .build();

    private static final SdkField<AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails> ZONE_AWARENESS_CONFIG_FIELD = SdkField
            .<AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ZoneAwarenessConfig")
            .getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::zoneAwarenessConfig))
            .setter(setter(Builder::zoneAwarenessConfig))
            .constructor(AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessConfig").build())
            .build();

    private static final SdkField<Integer> DEDICATED_MASTER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DedicatedMasterCount")
            .getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::dedicatedMasterCount))
            .setter(setter(Builder::dedicatedMasterCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterCount").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> WARM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarmType").getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::warmType))
            .setter(setter(Builder::warmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmType").build()).build();

    private static final SdkField<Boolean> ZONE_AWARENESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ZoneAwarenessEnabled")
            .getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::zoneAwarenessEnabled))
            .setter(setter(Builder::zoneAwarenessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessEnabled").build())
            .build();

    private static final SdkField<String> DEDICATED_MASTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedMasterType")
            .getter(getter(AwsOpenSearchServiceDomainClusterConfigDetails::dedicatedMasterType))
            .setter(setter(Builder::dedicatedMasterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            WARM_ENABLED_FIELD, WARM_COUNT_FIELD, DEDICATED_MASTER_ENABLED_FIELD, ZONE_AWARENESS_CONFIG_FIELD,
            DEDICATED_MASTER_COUNT_FIELD, INSTANCE_TYPE_FIELD, WARM_TYPE_FIELD, ZONE_AWARENESS_ENABLED_FIELD,
            DEDICATED_MASTER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final Boolean warmEnabled;

    private final Integer warmCount;

    private final Boolean dedicatedMasterEnabled;

    private final AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig;

    private final Integer dedicatedMasterCount;

    private final String instanceType;

    private final String warmType;

    private final Boolean zoneAwarenessEnabled;

    private final String dedicatedMasterType;

    private AwsOpenSearchServiceDomainClusterConfigDetails(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.warmEnabled = builder.warmEnabled;
        this.warmCount = builder.warmCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
        this.instanceType = builder.instanceType;
        this.warmType = builder.warmType;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
        this.dedicatedMasterType = builder.dedicatedMasterType;
    }

    /**
     * <p>
     * The number of data nodes to use in the OpenSearch domain.
     * </p>
     * 
     * @return The number of data nodes to use in the OpenSearch domain.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * Whether UltraWarm is enabled.
     * </p>
     * 
     * @return Whether UltraWarm is enabled.
     */
    public final Boolean warmEnabled() {
        return warmEnabled;
    }

    /**
     * <p>
     * The number of UltraWarm instances.
     * </p>
     * 
     * @return The number of UltraWarm instances.
     */
    public final Integer warmCount() {
        return warmCount;
    }

    /**
     * <p>
     * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster
     * management tasks, but does not hold data or respond to data upload requests.
     * </p>
     * 
     * @return Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs
     *         cluster management tasks, but does not hold data or respond to data upload requests.
     */
    public final Boolean dedicatedMasterEnabled() {
        return dedicatedMasterEnabled;
    }

    /**
     * <p>
     * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
     * </p>
     * 
     * @return Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is
     *         <code>true</code>.
     */
    public final AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig() {
        return zoneAwarenessConfig;
    }

    /**
     * <p>
     * The number of instances to use for the master node. If this attribute is specified, then
     * <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     * </p>
     * 
     * @return The number of instances to use for the master node. If this attribute is specified, then
     *         <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     */
    public final Integer dedicatedMasterCount() {
        return dedicatedMasterCount;
    }

    /**
     * <p>
     * The instance type for your data nodes.
     * </p>
     * 
     * @return The instance type for your data nodes.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The type of UltraWarm instance.
     * </p>
     * 
     * @return The type of UltraWarm instance.
     */
    public final String warmType() {
        return warmType;
    }

    /**
     * <p>
     * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service
     * allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This
     * prevents data loss and minimizes downtime if a node or data center fails.
     * </p>
     * 
     * @return Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch
     *         Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the
     *         same Region. This prevents data loss and minimizes downtime if a node or data center fails.
     */
    public final Boolean zoneAwarenessEnabled() {
        return zoneAwarenessEnabled;
    }

    /**
     * <p>
     * The hardware configuration of the computer that hosts the dedicated master node.
     * </p>
     * <p>
     * If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     * </p>
     * 
     * @return The hardware configuration of the computer that hosts the dedicated master node.</p>
     *         <p>
     *         If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     */
    public final String dedicatedMasterType() {
        return dedicatedMasterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(warmEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(warmCount());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(warmType());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainClusterConfigDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainClusterConfigDetails other = (AwsOpenSearchServiceDomainClusterConfigDetails) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(warmEnabled(), other.warmEnabled())
                && Objects.equals(warmCount(), other.warmCount())
                && Objects.equals(dedicatedMasterEnabled(), other.dedicatedMasterEnabled())
                && Objects.equals(zoneAwarenessConfig(), other.zoneAwarenessConfig())
                && Objects.equals(dedicatedMasterCount(), other.dedicatedMasterCount())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(warmType(), other.warmType())
                && Objects.equals(zoneAwarenessEnabled(), other.zoneAwarenessEnabled())
                && Objects.equals(dedicatedMasterType(), other.dedicatedMasterType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainClusterConfigDetails").add("InstanceCount", instanceCount())
                .add("WarmEnabled", warmEnabled()).add("WarmCount", warmCount())
                .add("DedicatedMasterEnabled", dedicatedMasterEnabled()).add("ZoneAwarenessConfig", zoneAwarenessConfig())
                .add("DedicatedMasterCount", dedicatedMasterCount()).add("InstanceType", instanceType())
                .add("WarmType", warmType()).add("ZoneAwarenessEnabled", zoneAwarenessEnabled())
                .add("DedicatedMasterType", dedicatedMasterType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "WarmEnabled":
            return Optional.ofNullable(clazz.cast(warmEnabled()));
        case "WarmCount":
            return Optional.ofNullable(clazz.cast(warmCount()));
        case "DedicatedMasterEnabled":
            return Optional.ofNullable(clazz.cast(dedicatedMasterEnabled()));
        case "ZoneAwarenessConfig":
            return Optional.ofNullable(clazz.cast(zoneAwarenessConfig()));
        case "DedicatedMasterCount":
            return Optional.ofNullable(clazz.cast(dedicatedMasterCount()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "WarmType":
            return Optional.ofNullable(clazz.cast(warmType()));
        case "ZoneAwarenessEnabled":
            return Optional.ofNullable(clazz.cast(zoneAwarenessEnabled()));
        case "DedicatedMasterType":
            return Optional.ofNullable(clazz.cast(dedicatedMasterType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainClusterConfigDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainClusterConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainClusterConfigDetails> {
        /**
         * <p>
         * The number of data nodes to use in the OpenSearch domain.
         * </p>
         * 
         * @param instanceCount
         *        The number of data nodes to use in the OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * Whether UltraWarm is enabled.
         * </p>
         * 
         * @param warmEnabled
         *        Whether UltraWarm is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmEnabled(Boolean warmEnabled);

        /**
         * <p>
         * The number of UltraWarm instances.
         * </p>
         * 
         * @param warmCount
         *        The number of UltraWarm instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmCount(Integer warmCount);

        /**
         * <p>
         * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster
         * management tasks, but does not hold data or respond to data upload requests.
         * </p>
         * 
         * @param dedicatedMasterEnabled
         *        Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs
         *        cluster management tasks, but does not hold data or respond to data upload requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled);

        /**
         * <p>
         * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
         * </p>
         * 
         * @param zoneAwarenessConfig
         *        Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessConfig(AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig);

        /**
         * <p>
         * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder} avoiding the need to create
         * one manually via {@link AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #zoneAwarenessConfig(AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)}.
         * 
         * @param zoneAwarenessConfig
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zoneAwarenessConfig(AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails)
         */
        default Builder zoneAwarenessConfig(
                Consumer<AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder> zoneAwarenessConfig) {
            return zoneAwarenessConfig(AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.builder()
                    .applyMutation(zoneAwarenessConfig).build());
        }

        /**
         * <p>
         * The number of instances to use for the master node. If this attribute is specified, then
         * <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * </p>
         * 
         * @param dedicatedMasterCount
         *        The number of instances to use for the master node. If this attribute is specified, then
         *        <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterCount(Integer dedicatedMasterCount);

        /**
         * <p>
         * The instance type for your data nodes.
         * </p>
         * 
         * @param instanceType
         *        The instance type for your data nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of UltraWarm instance.
         * </p>
         * 
         * @param warmType
         *        The type of UltraWarm instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmType(String warmType);

        /**
         * <p>
         * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch
         * Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same
         * Region. This prevents data loss and minimizes downtime if a node or data center fails.
         * </p>
         * 
         * @param zoneAwarenessEnabled
         *        Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch
         *        Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the
         *        same Region. This prevents data loss and minimizes downtime if a node or data center fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled);

        /**
         * <p>
         * The hardware configuration of the computer that hosts the dedicated master node.
         * </p>
         * <p>
         * If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * </p>
         * 
         * @param dedicatedMasterType
         *        The hardware configuration of the computer that hosts the dedicated master node.</p>
         *        <p>
         *        If this attribute is specified, then <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterType(String dedicatedMasterType);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private Boolean warmEnabled;

        private Integer warmCount;

        private Boolean dedicatedMasterEnabled;

        private AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig;

        private Integer dedicatedMasterCount;

        private String instanceType;

        private String warmType;

        private Boolean zoneAwarenessEnabled;

        private String dedicatedMasterType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainClusterConfigDetails model) {
            instanceCount(model.instanceCount);
            warmEnabled(model.warmEnabled);
            warmCount(model.warmCount);
            dedicatedMasterEnabled(model.dedicatedMasterEnabled);
            zoneAwarenessConfig(model.zoneAwarenessConfig);
            dedicatedMasterCount(model.dedicatedMasterCount);
            instanceType(model.instanceType);
            warmType(model.warmType);
            zoneAwarenessEnabled(model.zoneAwarenessEnabled);
            dedicatedMasterType(model.dedicatedMasterType);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        @Transient
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Boolean getWarmEnabled() {
            return warmEnabled;
        }

        public final void setWarmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
        }

        @Override
        @Transient
        public final Builder warmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
            return this;
        }

        public final Integer getWarmCount() {
            return warmCount;
        }

        public final void setWarmCount(Integer warmCount) {
            this.warmCount = warmCount;
        }

        @Override
        @Transient
        public final Builder warmCount(Integer warmCount) {
            this.warmCount = warmCount;
            return this;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return dedicatedMasterEnabled;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        @Override
        @Transient
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder getZoneAwarenessConfig() {
            return zoneAwarenessConfig != null ? zoneAwarenessConfig.toBuilder() : null;
        }

        public final void setZoneAwarenessConfig(
                AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.BuilderImpl zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig != null ? zoneAwarenessConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder zoneAwarenessConfig(
                AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig;
            return this;
        }

        public final Integer getDedicatedMasterCount() {
            return dedicatedMasterCount;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        @Override
        @Transient
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getWarmType() {
            return warmType;
        }

        public final void setWarmType(String warmType) {
            this.warmType = warmType;
        }

        @Override
        @Transient
        public final Builder warmType(String warmType) {
            this.warmType = warmType;
            return this;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return zoneAwarenessEnabled;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        @Override
        @Transient
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        public final String getDedicatedMasterType() {
            return dedicatedMasterType;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        @Override
        @Transient
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainClusterConfigDetails build() {
            return new AwsOpenSearchServiceDomainClusterConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
