/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an instance in the DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbClusterMember implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbClusterMember.Builder, AwsRdsDbClusterMember> {
    private static final SdkField<Boolean> IS_CLUSTER_WRITER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsClusterWriter").getter(getter(AwsRdsDbClusterMember::isClusterWriter))
            .setter(setter(Builder::isClusterWriter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsClusterWriter").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(AwsRdsDbClusterMember::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbInstanceIdentifier").getter(getter(AwsRdsDbClusterMember::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DbClusterParameterGroupStatus")
            .getter(getter(AwsRdsDbClusterMember::dbClusterParameterGroupStatus))
            .setter(setter(Builder::dbClusterParameterGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterParameterGroupStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_CLUSTER_WRITER_FIELD,
            PROMOTION_TIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isClusterWriter;

    private final Integer promotionTier;

    private final String dbInstanceIdentifier;

    private final String dbClusterParameterGroupStatus;

    private AwsRdsDbClusterMember(BuilderImpl builder) {
        this.isClusterWriter = builder.isClusterWriter;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbClusterParameterGroupStatus = builder.dbClusterParameterGroupStatus;
    }

    /**
     * <p>
     * Whether the cluster member is the primary instance for the DB cluster.
     * </p>
     * 
     * @return Whether the cluster member is the primary instance for the DB cluster.
     */
    public final Boolean isClusterWriter() {
        return isClusterWriter;
    }

    /**
     * <p>
     * Specifies the order in which an Aurora replica is promoted to the primary instance when the existing primary
     * instance fails.
     * </p>
     * 
     * @return Specifies the order in which an Aurora replica is promoted to the primary instance when the existing
     *         primary instance fails.
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The instance identifier for this member of the DB cluster.
     * </p>
     * 
     * @return The instance identifier for this member of the DB cluster.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The status of the DB cluster parameter group for this member of the DB cluster.
     * </p>
     * 
     * @return The status of the DB cluster parameter group for this member of the DB cluster.
     */
    public final String dbClusterParameterGroupStatus() {
        return dbClusterParameterGroupStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isClusterWriter());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterMember)) {
            return false;
        }
        AwsRdsDbClusterMember other = (AwsRdsDbClusterMember) obj;
        return Objects.equals(isClusterWriter(), other.isClusterWriter())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbClusterParameterGroupStatus(), other.dbClusterParameterGroupStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbClusterMember").add("IsClusterWriter", isClusterWriter())
                .add("PromotionTier", promotionTier()).add("DbInstanceIdentifier", dbInstanceIdentifier())
                .add("DbClusterParameterGroupStatus", dbClusterParameterGroupStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsClusterWriter":
            return Optional.ofNullable(clazz.cast(isClusterWriter()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "DbInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DbClusterParameterGroupStatus":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterMember, T> g) {
        return obj -> g.apply((AwsRdsDbClusterMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbClusterMember> {
        /**
         * <p>
         * Whether the cluster member is the primary instance for the DB cluster.
         * </p>
         * 
         * @param isClusterWriter
         *        Whether the cluster member is the primary instance for the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isClusterWriter(Boolean isClusterWriter);

        /**
         * <p>
         * Specifies the order in which an Aurora replica is promoted to the primary instance when the existing primary
         * instance fails.
         * </p>
         * 
         * @param promotionTier
         *        Specifies the order in which an Aurora replica is promoted to the primary instance when the existing
         *        primary instance fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The instance identifier for this member of the DB cluster.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The instance identifier for this member of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The status of the DB cluster parameter group for this member of the DB cluster.
         * </p>
         * 
         * @param dbClusterParameterGroupStatus
         *        The status of the DB cluster parameter group for this member of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isClusterWriter;

        private Integer promotionTier;

        private String dbInstanceIdentifier;

        private String dbClusterParameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterMember model) {
            isClusterWriter(model.isClusterWriter);
            promotionTier(model.promotionTier);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbClusterParameterGroupStatus(model.dbClusterParameterGroupStatus);
        }

        public final Boolean getIsClusterWriter() {
            return isClusterWriter;
        }

        public final void setIsClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
        }

        @Override
        @Transient
        public final Builder isClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        @Transient
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroupStatus() {
            return dbClusterParameterGroupStatus;
        }

        public final void setDbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
        }

        @Override
        @Transient
        public final Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
            return this;
        }

        @Override
        public AwsRdsDbClusterMember build() {
            return new AwsRdsDbClusterMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
