/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A security group that is associated with the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterClusterSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterClusterSecurityGroup.Builder, AwsRedshiftClusterClusterSecurityGroup> {
    private static final SdkField<String> CLUSTER_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSecurityGroupName")
            .getter(getter(AwsRedshiftClusterClusterSecurityGroup::clusterSecurityGroupName))
            .setter(setter(Builder::clusterSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRedshiftClusterClusterSecurityGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SECURITY_GROUP_NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterSecurityGroupName;

    private final String status;

    private AwsRedshiftClusterClusterSecurityGroup(BuilderImpl builder) {
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the cluster security group.
     * </p>
     * 
     * @return The name of the cluster security group.
     */
    public final String clusterSecurityGroupName() {
        return clusterSecurityGroupName;
    }

    /**
     * <p>
     * The status of the cluster security group.
     * </p>
     * 
     * @return The status of the cluster security group.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterClusterSecurityGroup)) {
            return false;
        }
        AwsRedshiftClusterClusterSecurityGroup other = (AwsRedshiftClusterClusterSecurityGroup) obj;
        return Objects.equals(clusterSecurityGroupName(), other.clusterSecurityGroupName())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterClusterSecurityGroup")
                .add("ClusterSecurityGroupName", clusterSecurityGroupName()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSecurityGroupName":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterClusterSecurityGroup, T> g) {
        return obj -> g.apply((AwsRedshiftClusterClusterSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterClusterSecurityGroup> {
        /**
         * <p>
         * The name of the cluster security group.
         * </p>
         * 
         * @param clusterSecurityGroupName
         *        The name of the cluster security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroupName(String clusterSecurityGroupName);

        /**
         * <p>
         * The status of the cluster security group.
         * </p>
         * 
         * @param status
         *        The status of the cluster security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String clusterSecurityGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterClusterSecurityGroup model) {
            clusterSecurityGroupName(model.clusterSecurityGroupName);
            status(model.status);
        }

        public final String getClusterSecurityGroupName() {
            return clusterSecurityGroupName;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        @Override
        @Transient
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRedshiftClusterClusterSecurityGroup build() {
            return new AwsRedshiftClusterClusterSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
