/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails> {
    private static final SdkField<List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>> OPERANDS_FIELD = SdkField
            .<List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>> builder(MarshallingType.LIST)
            .memberName("Operands")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails::operands))
            .setter(setter(Builder::operands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails> TAG_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Tag").getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails::tag))
            .setter(setter(Builder::tag))
            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERANDS_FIELD, PREFIX_FIELD,
            TAG_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> operands;

    private final String prefix;

    private final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails tag;

    private final String type;

    private AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(BuilderImpl builder) {
        this.operands = builder.operands;
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperands() {
        return operands != null && !(operands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values to use for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperands} method.
     * </p>
     * 
     * @return The values to use for the filter.
     */
    public final List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> operands() {
        return operands;
    }

    /**
     * <p>
     * A prefix filter.
     * </p>
     * 
     * @return A prefix filter.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A tag filter.
     * </p>
     * 
     * @return A tag filter.
     */
    public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails tag() {
        return tag;
    }

    /**
     * <p>
     * Whether to use <code>AND</code> or <code>OR</code> to join the operands.
     * </p>
     * 
     * @return Whether to use <code>AND</code> or <code>OR</code> to join the operands.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOperands() ? operands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails) obj;
        return hasOperands() == other.hasOperands() && Objects.equals(operands(), other.operands())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails")
                .add("Operands", hasOperands() ? operands() : null).add("Prefix", prefix()).add("Tag", tag()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operands":
            return Optional.ofNullable(clazz.cast(operands()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails> {
        /**
         * <p>
         * The values to use for the filter.
         * </p>
         * 
         * @param operands
         *        The values to use for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(Collection<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> operands);

        /**
         * <p>
         * The values to use for the filter.
         * </p>
         * 
         * @param operands
         *        The values to use for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails... operands);

        /**
         * <p>
         * The values to use for the filter.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>.Builder} avoiding the need to
         * create one manually via {@link List
         * <AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #operands(List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>)}.
         * 
         * @param operands
         *        a consumer that will call methods on {@link List
         *        <AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operands(List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails>)
         */
        Builder operands(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.Builder>... operands);

        /**
         * <p>
         * A prefix filter.
         * </p>
         * 
         * @param prefix
         *        A prefix filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A tag filter.
         * </p>
         * 
         * @param tag
         *        A tag filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails tag);

        /**
         * <p>
         * A tag filter.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails)}.
         * 
         * @param tag
         *        a consumer that will call methods on
         *        {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails)
         */
        default Builder tag(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.Builder> tag) {
            return tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.builder().applyMutation(tag).build());
        }

        /**
         * <p>
         * Whether to use <code>AND</code> or <code>OR</code> to join the operands.
         * </p>
         * 
         * @param type
         *        Whether to use <code>AND</code> or <code>OR</code> to join the operands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> operands = DefaultSdkAutoConstructList
                .getInstance();

        private String prefix;

        private AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails tag;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails model) {
            operands(model.operands);
            prefix(model.prefix);
            tag(model.tag);
            type(model.type);
        }

        public final List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.Builder> getOperands() {
            List<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.Builder> result = AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsListCopier
                    .copyToBuilder(this.operands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperands(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.BuilderImpl> operands) {
            this.operands = AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsListCopier
                    .copyFromBuilder(operands);
        }

        @Override
        @Transient
        public final Builder operands(
                Collection<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> operands) {
            this.operands = AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsListCopier.copy(operands);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operands(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails... operands) {
            operands(Arrays.asList(operands));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operands(
                Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.Builder>... operands) {
            operands(Stream
                    .of(operands)
                    .map(c -> AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.builder()
                            .applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        public final void setTag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        @Override
        @Transient
        public final Builder tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails tag) {
            this.tag = tag;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
