/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for an S3 bucket notification configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketNotificationConfigurationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketNotificationConfigurationDetail.Builder, AwsS3BucketNotificationConfigurationDetail> {
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(AwsS3BucketNotificationConfigurationDetail::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsS3BucketNotificationConfigurationFilter> FILTER_FIELD = SdkField
            .<AwsS3BucketNotificationConfigurationFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(AwsS3BucketNotificationConfigurationDetail::filter)).setter(setter(Builder::filter))
            .constructor(AwsS3BucketNotificationConfigurationFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(AwsS3BucketNotificationConfigurationDetail::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsS3BucketNotificationConfigurationDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, FILTER_FIELD,
            DESTINATION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> events;

    private final AwsS3BucketNotificationConfigurationFilter filter;

    private final String destination;

    private final String type;

    private AwsS3BucketNotificationConfigurationDetail(BuilderImpl builder) {
        this.events = builder.events;
        this.filter = builder.filter;
        this.destination = builder.destination;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of events that trigger a notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The list of events that trigger a notification.
     */
    public final List<String> events() {
        return events;
    }

    /**
     * <p>
     * The filters that determine which S3 buckets generate notifications.
     * </p>
     * 
     * @return The filters that determine which S3 buckets generate notifications.
     */
    public final AwsS3BucketNotificationConfigurationFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that generates the notification.
     * </p>
     * 
     * @return The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that generates the notification.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * Indicates the type of notification. Notifications can be generated using Lambda functions, Amazon SQS queues or
     * Amazon SNS topics.
     * </p>
     * 
     * @return Indicates the type of notification. Notifications can be generated using Lambda functions, Amazon SQS
     *         queues or Amazon SNS topics.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketNotificationConfigurationDetail)) {
            return false;
        }
        AwsS3BucketNotificationConfigurationDetail other = (AwsS3BucketNotificationConfigurationDetail) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(filter(), other.filter()) && Objects.equals(destination(), other.destination())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketNotificationConfigurationDetail").add("Events", hasEvents() ? events() : null)
                .add("Filter", filter()).add("Destination", destination()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketNotificationConfigurationDetail, T> g) {
        return obj -> g.apply((AwsS3BucketNotificationConfigurationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketNotificationConfigurationDetail> {
        /**
         * <p>
         * The list of events that trigger a notification.
         * </p>
         * 
         * @param events
         *        The list of events that trigger a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<String> events);

        /**
         * <p>
         * The list of events that trigger a notification.
         * </p>
         * 
         * @param events
         *        The list of events that trigger a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String... events);

        /**
         * <p>
         * The filters that determine which S3 buckets generate notifications.
         * </p>
         * 
         * @param filter
         *        The filters that determine which S3 buckets generate notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(AwsS3BucketNotificationConfigurationFilter filter);

        /**
         * <p>
         * The filters that determine which S3 buckets generate notifications.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsS3BucketNotificationConfigurationFilter.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketNotificationConfigurationFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3BucketNotificationConfigurationFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filter(AwsS3BucketNotificationConfigurationFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link AwsS3BucketNotificationConfigurationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(AwsS3BucketNotificationConfigurationFilter)
         */
        default Builder filter(Consumer<AwsS3BucketNotificationConfigurationFilter.Builder> filter) {
            return filter(AwsS3BucketNotificationConfigurationFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that generates the notification.
         * </p>
         * 
         * @param destination
         *        The ARN of the Lambda function, Amazon SQS queue, or Amazon SNS topic that generates the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * Indicates the type of notification. Notifications can be generated using Lambda functions, Amazon SQS queues
         * or Amazon SNS topics.
         * </p>
         * 
         * @param type
         *        Indicates the type of notification. Notifications can be generated using Lambda functions, Amazon SQS
         *        queues or Amazon SNS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private AwsS3BucketNotificationConfigurationFilter filter;

        private String destination;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketNotificationConfigurationDetail model) {
            events(model.events);
            filter(model.filter);
            destination(model.destination);
            type(model.type);
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = AwsS3BucketNotificationConfigurationEventsCopier.copy(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<String> events) {
            this.events = AwsS3BucketNotificationConfigurationEventsCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(String... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final AwsS3BucketNotificationConfigurationFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(AwsS3BucketNotificationConfigurationFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(AwsS3BucketNotificationConfigurationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsS3BucketNotificationConfigurationDetail build() {
            return new AwsS3BucketNotificationConfigurationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
