/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering information for the notifications. The filtering is based on Amazon S3 key names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketNotificationConfigurationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketNotificationConfigurationFilter.Builder, AwsS3BucketNotificationConfigurationFilter> {
    private static final SdkField<AwsS3BucketNotificationConfigurationS3KeyFilter> S3_KEY_FILTER_FIELD = SdkField
            .<AwsS3BucketNotificationConfigurationS3KeyFilter> builder(MarshallingType.SDK_POJO).memberName("S3KeyFilter")
            .getter(getter(AwsS3BucketNotificationConfigurationFilter::s3KeyFilter)).setter(setter(Builder::s3KeyFilter))
            .constructor(AwsS3BucketNotificationConfigurationS3KeyFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_KEY_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketNotificationConfigurationS3KeyFilter s3KeyFilter;

    private AwsS3BucketNotificationConfigurationFilter(BuilderImpl builder) {
        this.s3KeyFilter = builder.s3KeyFilter;
    }

    /**
     * <p>
     * Details for an Amazon S3 filter.
     * </p>
     * 
     * @return Details for an Amazon S3 filter.
     */
    public final AwsS3BucketNotificationConfigurationS3KeyFilter s3KeyFilter() {
        return s3KeyFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketNotificationConfigurationFilter)) {
            return false;
        }
        AwsS3BucketNotificationConfigurationFilter other = (AwsS3BucketNotificationConfigurationFilter) obj;
        return Objects.equals(s3KeyFilter(), other.s3KeyFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketNotificationConfigurationFilter").add("S3KeyFilter", s3KeyFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3KeyFilter":
            return Optional.ofNullable(clazz.cast(s3KeyFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketNotificationConfigurationFilter, T> g) {
        return obj -> g.apply((AwsS3BucketNotificationConfigurationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketNotificationConfigurationFilter> {
        /**
         * <p>
         * Details for an Amazon S3 filter.
         * </p>
         * 
         * @param s3KeyFilter
         *        Details for an Amazon S3 filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter s3KeyFilter);

        /**
         * <p>
         * Details for an Amazon S3 filter.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsS3BucketNotificationConfigurationS3KeyFilter.Builder} avoiding the need to create one manually via
         * {@link AwsS3BucketNotificationConfigurationS3KeyFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3BucketNotificationConfigurationS3KeyFilter.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #s3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter)}.
         * 
         * @param s3KeyFilter
         *        a consumer that will call methods on {@link AwsS3BucketNotificationConfigurationS3KeyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter)
         */
        default Builder s3KeyFilter(Consumer<AwsS3BucketNotificationConfigurationS3KeyFilter.Builder> s3KeyFilter) {
            return s3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter.builder().applyMutation(s3KeyFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketNotificationConfigurationS3KeyFilter s3KeyFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketNotificationConfigurationFilter model) {
            s3KeyFilter(model.s3KeyFilter);
        }

        public final AwsS3BucketNotificationConfigurationS3KeyFilter.Builder getS3KeyFilter() {
            return s3KeyFilter != null ? s3KeyFilter.toBuilder() : null;
        }

        public final void setS3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter.BuilderImpl s3KeyFilter) {
            this.s3KeyFilter = s3KeyFilter != null ? s3KeyFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder s3KeyFilter(AwsS3BucketNotificationConfigurationS3KeyFilter s3KeyFilter) {
            this.s3KeyFilter = s3KeyFilter;
            return this;
        }

        @Override
        public AwsS3BucketNotificationConfigurationFilter build() {
            return new AwsS3BucketNotificationConfigurationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
